// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A single Performance Insights metric query to process. You must provide the metric to the query. If other parameters aren't specified, Performance Insights returns all data points for the specified metric. Optionally, you can request the data points to be aggregated by dimension group (`GroupBy`) and return only those data points that match your criteria (`Filter`).
 *
 * Constraints:
 * + Must be a valid Performance Insights query.
 */
public class PerformanceInsightsMetricQuery private constructor(builder: Builder) {
    /**
     * A specification for how to aggregate the data points from a query result. You must specify a valid dimension group. Performance Insights will return all of the dimensions within that group, unless you provide the names of specific dimensions within that group. You can also request that Performance Insights return a limited number of values for a dimension.
     */
    public val groupBy: aws.sdk.kotlin.services.rds.model.PerformanceInsightsMetricDimensionGroup? = builder.groupBy
    /**
     * The name of a Performance Insights metric to be measured.
     *
     * Valid Values:
     * + `db.load.avg` - A scaled representation of the number of active sessions for the database engine.
     * + `db.sampledload.avg` - The raw number of active sessions for the database engine.
     * + The counter metrics listed in [Performance Insights operating system counters](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights_Counters.html#USER_PerfInsights_Counters.OS) in the *Amazon Aurora User Guide*.
     *
     * If the number of active sessions is less than an internal Performance Insights threshold, `db.load.avg` and `db.sampledload.avg` are the same value. If the number of active sessions is greater than the internal threshold, Performance Insights samples the active sessions, with `db.load.avg` showing the scaled values, `db.sampledload.avg` showing the raw values, and `db.sampledload.avg` less than `db.load.avg`. For most use cases, you can query `db.load.avg` only.
     */
    public val metric: kotlin.String? = builder.metric

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.PerformanceInsightsMetricQuery = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PerformanceInsightsMetricQuery(")
        append("groupBy=$groupBy,")
        append("metric=$metric")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = groupBy?.hashCode() ?: 0
        result = 31 * result + (metric?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PerformanceInsightsMetricQuery

        if (groupBy != other.groupBy) return false
        if (metric != other.metric) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.PerformanceInsightsMetricQuery = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A specification for how to aggregate the data points from a query result. You must specify a valid dimension group. Performance Insights will return all of the dimensions within that group, unless you provide the names of specific dimensions within that group. You can also request that Performance Insights return a limited number of values for a dimension.
         */
        public var groupBy: aws.sdk.kotlin.services.rds.model.PerformanceInsightsMetricDimensionGroup? = null
        /**
         * The name of a Performance Insights metric to be measured.
         *
         * Valid Values:
         * + `db.load.avg` - A scaled representation of the number of active sessions for the database engine.
         * + `db.sampledload.avg` - The raw number of active sessions for the database engine.
         * + The counter metrics listed in [Performance Insights operating system counters](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights_Counters.html#USER_PerfInsights_Counters.OS) in the *Amazon Aurora User Guide*.
         *
         * If the number of active sessions is less than an internal Performance Insights threshold, `db.load.avg` and `db.sampledload.avg` are the same value. If the number of active sessions is greater than the internal threshold, Performance Insights samples the active sessions, with `db.load.avg` showing the scaled values, `db.sampledload.avg` showing the raw values, and `db.sampledload.avg` less than `db.load.avg`. For most use cases, you can query `db.load.avg` only.
         */
        public var metric: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.PerformanceInsightsMetricQuery) : this() {
            this.groupBy = x.groupBy
            this.metric = x.metric
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.PerformanceInsightsMetricQuery = PerformanceInsightsMetricQuery(this)

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.PerformanceInsightsMetricDimensionGroup] inside the given [block]
         */
        public fun groupBy(block: aws.sdk.kotlin.services.rds.model.PerformanceInsightsMetricDimensionGroup.Builder.() -> kotlin.Unit) {
            this.groupBy = aws.sdk.kotlin.services.rds.model.PerformanceInsightsMetricDimensionGroup.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
