// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Option group option settings are used to display settings available for each option with their default values and other information. These values are used with the DescribeOptionGroupOptions action.
 */
public class OptionGroupOptionSetting private constructor(builder: Builder) {
    /**
     * Indicates the acceptable values for the option group option.
     */
    public val allowedValues: kotlin.String? = builder.allowedValues
    /**
     * The DB engine specific parameter type for the option group option.
     */
    public val applyType: kotlin.String? = builder.applyType
    /**
     * The default value for the option group option.
     */
    public val defaultValue: kotlin.String? = builder.defaultValue
    /**
     * Indicates whether this option group option can be changed from the default value.
     */
    public val isModifiable: kotlin.Boolean? = builder.isModifiable
    /**
     * Indicates whether a value must be specified for this option setting of the option group option.
     */
    public val isRequired: kotlin.Boolean? = builder.isRequired
    /**
     * The minimum DB engine version required for the corresponding allowed value for this option setting.
     */
    public val minimumEngineVersionPerAllowedValue: List<MinimumEngineVersionPerAllowedValue>? = builder.minimumEngineVersionPerAllowedValue
    /**
     * The description of the option group option.
     */
    public val settingDescription: kotlin.String? = builder.settingDescription
    /**
     * The name of the option group option.
     */
    public val settingName: kotlin.String? = builder.settingName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.OptionGroupOptionSetting = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OptionGroupOptionSetting(")
        append("allowedValues=$allowedValues,")
        append("applyType=$applyType,")
        append("defaultValue=$defaultValue,")
        append("isModifiable=$isModifiable,")
        append("isRequired=$isRequired,")
        append("minimumEngineVersionPerAllowedValue=$minimumEngineVersionPerAllowedValue,")
        append("settingDescription=$settingDescription,")
        append("settingName=$settingName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedValues?.hashCode() ?: 0
        result = 31 * result + (applyType?.hashCode() ?: 0)
        result = 31 * result + (defaultValue?.hashCode() ?: 0)
        result = 31 * result + (isModifiable?.hashCode() ?: 0)
        result = 31 * result + (isRequired?.hashCode() ?: 0)
        result = 31 * result + (minimumEngineVersionPerAllowedValue?.hashCode() ?: 0)
        result = 31 * result + (settingDescription?.hashCode() ?: 0)
        result = 31 * result + (settingName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OptionGroupOptionSetting

        if (allowedValues != other.allowedValues) return false
        if (applyType != other.applyType) return false
        if (defaultValue != other.defaultValue) return false
        if (isModifiable != other.isModifiable) return false
        if (isRequired != other.isRequired) return false
        if (minimumEngineVersionPerAllowedValue != other.minimumEngineVersionPerAllowedValue) return false
        if (settingDescription != other.settingDescription) return false
        if (settingName != other.settingName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.OptionGroupOptionSetting = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates the acceptable values for the option group option.
         */
        public var allowedValues: kotlin.String? = null
        /**
         * The DB engine specific parameter type for the option group option.
         */
        public var applyType: kotlin.String? = null
        /**
         * The default value for the option group option.
         */
        public var defaultValue: kotlin.String? = null
        /**
         * Indicates whether this option group option can be changed from the default value.
         */
        public var isModifiable: kotlin.Boolean? = null
        /**
         * Indicates whether a value must be specified for this option setting of the option group option.
         */
        public var isRequired: kotlin.Boolean? = null
        /**
         * The minimum DB engine version required for the corresponding allowed value for this option setting.
         */
        public var minimumEngineVersionPerAllowedValue: List<MinimumEngineVersionPerAllowedValue>? = null
        /**
         * The description of the option group option.
         */
        public var settingDescription: kotlin.String? = null
        /**
         * The name of the option group option.
         */
        public var settingName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.OptionGroupOptionSetting) : this() {
            this.allowedValues = x.allowedValues
            this.applyType = x.applyType
            this.defaultValue = x.defaultValue
            this.isModifiable = x.isModifiable
            this.isRequired = x.isRequired
            this.minimumEngineVersionPerAllowedValue = x.minimumEngineVersionPerAllowedValue
            this.settingDescription = x.settingDescription
            this.settingName = x.settingName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.OptionGroupOptionSetting = OptionGroupOptionSetting(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
