// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ModifyDbSnapshotRequest private constructor(builder: Builder) {
    /**
     * The identifier of the DB snapshot to modify.
     */
    public val dbSnapshotIdentifier: kotlin.String? = builder.dbSnapshotIdentifier
    /**
     * The engine version to upgrade the DB snapshot to.
     *
     * The following are the database engines and engine versions that are available when you upgrade a DB snapshot.
     *
     * **MySQL**
     *
     * For the list of engine versions that are available for upgrading a DB snapshot, see [ Upgrading a MySQL DB snapshot engine version](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/mysql-upgrade-snapshot.html) in the *Amazon RDS User Guide.*
     *
     * **Oracle**
     * + `19.0.0.0.ru-2022-01.rur-2022-01.r1` (supported for 12.2.0.1 DB snapshots)
     * + `19.0.0.0.ru-2022-07.rur-2022-07.r1` (supported for 12.1.0.2 DB snapshots)
     * + `12.1.0.2.v8` (supported for 12.1.0.1 DB snapshots)
     * + `11.2.0.4.v12` (supported for 11.2.0.2 DB snapshots)
     * + `11.2.0.4.v11` (supported for 11.2.0.3 DB snapshots)
     *
     * **PostgreSQL**
     *
     * For the list of engine versions that are available for upgrading a DB snapshot, see [ Upgrading a PostgreSQL DB snapshot engine version](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBSnapshot.PostgreSQL.html) in the *Amazon RDS User Guide.*
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The option group to identify with the upgraded DB snapshot.
     *
     * You can specify this parameter when you upgrade an Oracle DB snapshot. The same option group considerations apply when upgrading a DB snapshot as when upgrading a DB instance. For more information, see [Option group considerations](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Oracle.html#USER_UpgradeDBInstance.Oracle.OGPG.OG) in the *Amazon RDS User Guide.*
     */
    public val optionGroupName: kotlin.String? = builder.optionGroupName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.ModifyDbSnapshotRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyDbSnapshotRequest(")
        append("dbSnapshotIdentifier=$dbSnapshotIdentifier,")
        append("engineVersion=$engineVersion,")
        append("optionGroupName=$optionGroupName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbSnapshotIdentifier?.hashCode() ?: 0
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (optionGroupName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModifyDbSnapshotRequest

        if (dbSnapshotIdentifier != other.dbSnapshotIdentifier) return false
        if (engineVersion != other.engineVersion) return false
        if (optionGroupName != other.optionGroupName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.ModifyDbSnapshotRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the DB snapshot to modify.
         */
        public var dbSnapshotIdentifier: kotlin.String? = null
        /**
         * The engine version to upgrade the DB snapshot to.
         *
         * The following are the database engines and engine versions that are available when you upgrade a DB snapshot.
         *
         * **MySQL**
         *
         * For the list of engine versions that are available for upgrading a DB snapshot, see [ Upgrading a MySQL DB snapshot engine version](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/mysql-upgrade-snapshot.html) in the *Amazon RDS User Guide.*
         *
         * **Oracle**
         * + `19.0.0.0.ru-2022-01.rur-2022-01.r1` (supported for 12.2.0.1 DB snapshots)
         * + `19.0.0.0.ru-2022-07.rur-2022-07.r1` (supported for 12.1.0.2 DB snapshots)
         * + `12.1.0.2.v8` (supported for 12.1.0.1 DB snapshots)
         * + `11.2.0.4.v12` (supported for 11.2.0.2 DB snapshots)
         * + `11.2.0.4.v11` (supported for 11.2.0.3 DB snapshots)
         *
         * **PostgreSQL**
         *
         * For the list of engine versions that are available for upgrading a DB snapshot, see [ Upgrading a PostgreSQL DB snapshot engine version](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBSnapshot.PostgreSQL.html) in the *Amazon RDS User Guide.*
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The option group to identify with the upgraded DB snapshot.
         *
         * You can specify this parameter when you upgrade an Oracle DB snapshot. The same option group considerations apply when upgrading a DB snapshot as when upgrading a DB instance. For more information, see [Option group considerations](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Oracle.html#USER_UpgradeDBInstance.Oracle.OGPG.OG) in the *Amazon RDS User Guide.*
         */
        public var optionGroupName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.ModifyDbSnapshotRequest) : this() {
            this.dbSnapshotIdentifier = x.dbSnapshotIdentifier
            this.engineVersion = x.engineVersion
            this.optionGroupName = x.optionGroupName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.ModifyDbSnapshotRequest = ModifyDbSnapshotRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
