// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 *
 */
public class ModifyDbClusterRequest private constructor(builder: Builder) {
    /**
     * The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB cluster.
     *
     * Valid for Cluster Type: Multi-AZ DB clusters only
     */
    public val allocatedStorage: kotlin.Int? = builder.allocatedStorage
    /**
     * Specifies whether engine mode changes from `serverless` to `provisioned` are allowed.
     *
     * Valid for Cluster Type: Aurora Serverless v1 DB clusters only
     *
     * Constraints:
     * + You must allow engine mode changes when specifying a different value for the `EngineMode` parameter from the DB cluster's current engine mode.
     */
    public val allowEngineModeChange: kotlin.Boolean? = builder.allowEngineModeChange
    /**
     * Specifies whether major version upgrades are allowed.
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *
     * Constraints:
     * + You must allow major version upgrades when specifying a value for the `EngineVersion` parameter that is a different major version than the DB cluster's current version.
     */
    public val allowMajorVersionUpgrade: kotlin.Boolean? = builder.allowMajorVersionUpgrade
    /**
     * Specifies whether the modifications in this request and any pending modifications are asynchronously applied as soon as possible, regardless of the `PreferredMaintenanceWindow` setting for the DB cluster. If this parameter is disabled, changes to the DB cluster are applied during the next maintenance window.
     *
     * Most modifications can be applied immediately or during the next scheduled maintenance window. Some modifications, such as turning on deletion protection and changing the master password, are applied immediately—regardless of when you choose to apply them.
     *
     * By default, this parameter is disabled.
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val applyImmediately: kotlin.Boolean? = builder.applyImmediately
    /**
     * Specifies whether minor engine upgrades are applied automatically to the DB cluster during the maintenance window. By default, minor engine upgrades are applied automatically.
     *
     * Valid for Cluster Type: Multi-AZ DB clusters only
     */
    public val autoMinorVersionUpgrade: kotlin.Boolean? = builder.autoMinorVersionUpgrade
    /**
     * The Amazon Resource Name (ARN) of the recovery point in Amazon Web Services Backup.
     */
    public val awsBackupRecoveryPointArn: kotlin.String? = builder.awsBackupRecoveryPointArn
    /**
     * The target backtrack window, in seconds. To disable backtracking, set this value to `0`.
     *
     * Valid for Cluster Type: Aurora MySQL DB clusters only
     *
     * Default: `0`
     *
     * Constraints:
     * + If specified, this value must be set to a number from 0 to 259,200 (72 hours).
     */
    public val backtrackWindow: kotlin.Long? = builder.backtrackWindow
    /**
     * The number of days for which automated backups are retained. Specify a minimum value of `1`.
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *
     * Default: `1`
     *
     * Constraints:
     * + Must be a value from 1 to 35.
     */
    public val backupRetentionPeriod: kotlin.Int? = builder.backupRetentionPeriod
    /**
     * The CA certificate identifier to use for the DB cluster's server certificate.
     *
     * For more information, see [Using SSL/TLS to encrypt a connection to a DB instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html) in the *Amazon RDS User Guide*.
     *
     * Valid for Cluster Type: Multi-AZ DB clusters
     */
    public val caCertificateIdentifier: kotlin.String? = builder.caCertificateIdentifier
    /**
     * The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB cluster.
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *
     * The following values are valid for each DB engine:
     * + Aurora MySQL - `audit | error | general | slowquery`
     * + Aurora PostgreSQL - `postgresql`
     * + RDS for MySQL - `error | general | slowquery`
     * + RDS for PostgreSQL - `postgresql | upgrade`
     *
     * For more information about exporting CloudWatch Logs for Amazon RDS, see [ Publishing Database Logs to Amazon CloudWatch Logs](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch) in the *Amazon RDS User Guide*.
     *
     * For more information about exporting CloudWatch Logs for Amazon Aurora, see [Publishing Database Logs to Amazon CloudWatch Logs](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch) in the *Amazon Aurora User Guide*.
     */
    public val cloudwatchLogsExportConfiguration: aws.sdk.kotlin.services.rds.model.CloudwatchLogsExportConfiguration? = builder.cloudwatchLogsExportConfiguration
    /**
     * Specifies whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default is not to copy them.
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val copyTagsToSnapshot: kotlin.Boolean? = builder.copyTagsToSnapshot
    /**
     * The DB cluster identifier for the cluster being modified. This parameter isn't case-sensitive.
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *
     * Constraints:
     * + Must match the identifier of an existing DB cluster.
     */
    public val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example `db.m6gd.xlarge`. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines.
     *
     * For the full list of DB instance classes and availability for your engine, see [ DB Instance Class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) in the *Amazon RDS User Guide*.
     *
     * Valid for Cluster Type: Multi-AZ DB clusters only
     */
    public val dbClusterInstanceClass: kotlin.String? = builder.dbClusterInstanceClass
    /**
     * The name of the DB cluster parameter group to use for the DB cluster.
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val dbClusterParameterGroupName: kotlin.String? = builder.dbClusterParameterGroupName
    /**
     * The name of the DB parameter group to apply to all instances of the DB cluster.
     *
     * When you apply a parameter group using the `DBInstanceParameterGroupName` parameter, the DB cluster isn't rebooted automatically. Also, parameter changes are applied immediately rather than during the next maintenance window.
     *
     * Valid for Cluster Type: Aurora DB clusters only
     *
     * Default: The existing name setting
     *
     * Constraints:
     * + The DB parameter group must be in the same DB parameter group family as this DB cluster.
     * + The `DBInstanceParameterGroupName` parameter is valid in combination with the `AllowMajorVersionUpgrade` parameter for a major version upgrade only.
     */
    public val dbInstanceParameterGroupName: kotlin.String? = builder.dbInstanceParameterGroupName
    /**
     * Specifies whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled.
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * The Active Directory directory ID to move the DB cluster to. Specify `none` to remove the cluster from its current domain. The domain must be created prior to this operation.
     *
     * For more information, see [Kerberos Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html) in the *Amazon Aurora User Guide*.
     *
     * Valid for Cluster Type: Aurora DB clusters only
     */
    public val domain: kotlin.String? = builder.domain
    /**
     * The name of the IAM role to use when making API calls to the Directory Service.
     *
     * Valid for Cluster Type: Aurora DB clusters only
     */
    public val domainIamRoleName: kotlin.String? = builder.domainIamRoleName
    /**
     * Specifies whether to enable this DB cluster to forward write operations to the primary cluster of a global cluster (Aurora global database). By default, write operations are not allowed on Aurora DB clusters that are secondary clusters in an Aurora global database.
     *
     * You can set this value only on Aurora DB clusters that are members of an Aurora global database. With this parameter enabled, a secondary cluster can forward writes to the current primary cluster, and the resulting changes are replicated back to this cluster. For the primary DB cluster of an Aurora global database, this value is used immediately if the primary is demoted by a global cluster API operation, but it does nothing until then.
     *
     * Valid for Cluster Type: Aurora DB clusters only
     */
    public val enableGlobalWriteForwarding: kotlin.Boolean? = builder.enableGlobalWriteForwarding
    /**
     * Specifies whether to enable the HTTP endpoint for an Aurora Serverless v1 DB cluster. By default, the HTTP endpoint isn't enabled.
     *
     * When enabled, the HTTP endpoint provides a connectionless web service API (RDS Data API) for running SQL queries on the Aurora Serverless v1 DB cluster. You can also query your database from inside the RDS console with the RDS query editor.
     *
     * For more information, see [Using RDS Data API](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html) in the *Amazon Aurora User Guide*.
     *
     * This parameter applies only to Aurora Serverless v1 DB clusters. To enable or disable the HTTP endpoint for an Aurora PostgreSQL Serverless v2 or provisioned DB cluster, use the `EnableHttpEndpoint` and `DisableHttpEndpoint` operations.
     *
     * Valid for Cluster Type: Aurora DB clusters only
     */
    public val enableHttpEndpoint: kotlin.Boolean? = builder.enableHttpEndpoint
    /**
     * Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn't enabled.
     *
     * For more information, see [ IAM Database Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html) in the *Amazon Aurora User Guide*.
     *
     * Valid for Cluster Type: Aurora DB clusters only
     */
    public val enableIamDatabaseAuthentication: kotlin.Boolean? = builder.enableIamDatabaseAuthentication
    /**
     * Specifies whether to enable Aurora Limitless Database. You must enable Aurora Limitless Database to create a DB shard group.
     *
     * Valid for: Aurora DB clusters only
     */
    public val enableLimitlessDatabase: kotlin.Boolean? = builder.enableLimitlessDatabase
    /**
     * Specifies whether read replicas can forward write operations to the writer DB instance in the DB cluster. By default, write operations aren't allowed on reader DB instances.
     *
     * Valid for: Aurora DB clusters only
     */
    public val enableLocalWriteForwarding: kotlin.Boolean? = builder.enableLocalWriteForwarding
    /**
     * Specifies whether to turn on Performance Insights for the DB cluster.
     *
     * For more information, see [ Using Amazon Performance Insights](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html) in the *Amazon RDS User Guide*.
     *
     * Valid for Cluster Type: Multi-AZ DB clusters only
     */
    public val enablePerformanceInsights: kotlin.Boolean? = builder.enablePerformanceInsights
    /**
     * The DB engine mode of the DB cluster, either `provisioned` or `serverless`.
     *
     * The DB engine mode can be modified only from `serverless` to `provisioned`.
     *
     * For more information, see [ CreateDBCluster](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBCluster.html).
     *
     * Valid for Cluster Type: Aurora DB clusters only
     */
    public val engineMode: kotlin.String? = builder.engineMode
    /**
     * The version number of the database engine to which you want to upgrade. Changing this parameter results in an outage. The change is applied during the next maintenance window unless `ApplyImmediately` is enabled.
     *
     * If the cluster that you're modifying has one or more read replicas, all replicas must be running an engine version that's the same or later than the version you specify.
     *
     * To list all of the available engine versions for Aurora MySQL, use the following command:
     *
     * `aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"`
     *
     * To list all of the available engine versions for Aurora PostgreSQL, use the following command:
     *
     * `aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"`
     *
     * To list all of the available engine versions for RDS for MySQL, use the following command:
     *
     * `aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"`
     *
     * To list all of the available engine versions for RDS for PostgreSQL, use the following command:
     *
     * `aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"`
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB instance in the Multi-AZ DB cluster.
     *
     * For information about valid IOPS values, see [Amazon RDS Provisioned IOPS storage](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS) in the *Amazon RDS User Guide*.
     *
     * Valid for Cluster Type: Multi-AZ DB clusters only
     *
     * Constraints:
     * + Must be a multiple between .5 and 50 of the storage amount for the DB cluster.
     */
    public val iops: kotlin.Int? = builder.iops
    /**
     * Specifies whether to manage the master user password with Amazon Web Services Secrets Manager.
     *
     * If the DB cluster doesn't manage the master user password with Amazon Web Services Secrets Manager, you can turn on this management. In this case, you can't specify `MasterUserPassword`.
     *
     * If the DB cluster already manages the master user password with Amazon Web Services Secrets Manager, and you specify that the master user password is not managed with Amazon Web Services Secrets Manager, then you must specify `MasterUserPassword`. In this case, RDS deletes the secret and uses the new password for the master user specified by `MasterUserPassword`.
     *
     * For more information, see [Password management with Amazon Web Services Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html) in the *Amazon RDS User Guide* and [Password management with Amazon Web Services Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html) in the *Amazon Aurora User Guide.*
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val manageMasterUserPassword: kotlin.Boolean? = builder.manageMasterUserPassword
    /**
     * The new password for the master database user.
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *
     * Constraints:
     * + Must contain from 8 to 41 characters.
     * + Can contain any printable ASCII character except "/", """, or "@".
     * + Can't be specified if `ManageMasterUserPassword` is turned on.
     */
    public val masterUserPassword: kotlin.String? = builder.masterUserPassword
    /**
     * The Amazon Web Services KMS key identifier to encrypt a secret that is automatically generated and managed in Amazon Web Services Secrets Manager.
     *
     * This setting is valid only if both of the following conditions are met:
     * + The DB cluster doesn't manage the master user password in Amazon Web Services Secrets Manager.If the DB cluster already manages the master user password in Amazon Web Services Secrets Manager, you can't change the KMS key that is used to encrypt the secret.
     * + You are turning on `ManageMasterUserPassword` to manage the master user password in Amazon Web Services Secrets Manager.If you are turning on `ManageMasterUserPassword` and don't specify `MasterUserSecretKmsKeyId`, then the `aws/secretsmanager` KMS key is used to encrypt the secret. If the secret is in a different Amazon Web Services account, then you can't use the `aws/secretsmanager` KMS key to encrypt the secret, and you must use a customer managed KMS key.
     *
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
     *
     * There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val masterUserSecretKmsKeyId: kotlin.String? = builder.masterUserSecretKmsKeyId
    /**
     * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster. To turn off collecting Enhanced Monitoring metrics, specify `0`.
     *
     * If `MonitoringRoleArn` is specified, also set `MonitoringInterval` to a value other than `0`.
     *
     * Valid for Cluster Type: Multi-AZ DB clusters only
     *
     * Valid Values: `0 | 1 | 5 | 10 | 15 | 30 | 60`
     *
     * Default: `0`
     */
    public val monitoringInterval: kotlin.Int? = builder.monitoringInterval
    /**
     * The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs. An example is `arn:aws:iam:123456789012:role/emaccess`. For information on creating a monitoring role, see [To create an IAM role for Amazon RDS Enhanced Monitoring](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole) in the *Amazon RDS User Guide.*
     *
     * If `MonitoringInterval` is set to a value other than `0`, supply a `MonitoringRoleArn` value.
     *
     * Valid for Cluster Type: Multi-AZ DB clusters only
     */
    public val monitoringRoleArn: kotlin.String? = builder.monitoringRoleArn
    /**
     * The network type of the DB cluster.
     *
     * The network type is determined by the `DBSubnetGroup` specified for the DB cluster. A `DBSubnetGroup` can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (`DUAL`).
     *
     * For more information, see [ Working with a DB instance in a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html) in the *Amazon Aurora User Guide.*
     *
     * Valid for Cluster Type: Aurora DB clusters only
     *
     * Valid Values: `IPV4 | DUAL`
     */
    public val networkType: kotlin.String? = builder.networkType
    /**
     * The new DB cluster identifier for the DB cluster when renaming a DB cluster. This value is stored as a lowercase string.
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *
     * Constraints:
     * + Must contain from 1 to 63 letters, numbers, or hyphens.
     * + The first character must be a letter.
     * + Can't end with a hyphen or contain two consecutive hyphens.
     *
     * Example: `my-cluster2`
     */
    public val newDbClusterIdentifier: kotlin.String? = builder.newDbClusterIdentifier
    /**
     * The option group to associate the DB cluster with.
     *
     * DB clusters are associated with a default option group that can't be modified.
     */
    public val optionGroupName: kotlin.String? = builder.optionGroupName
    /**
     * The Amazon Web Services KMS key identifier for encryption of Performance Insights data.
     *
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     *
     * If you don't specify a value for `PerformanceInsightsKMSKeyId`, then Amazon RDS uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.
     *
     * Valid for Cluster Type: Multi-AZ DB clusters only
     */
    public val performanceInsightsKmsKeyId: kotlin.String? = builder.performanceInsightsKmsKeyId
    /**
     * The number of days to retain Performance Insights data.
     *
     * Valid for Cluster Type: Multi-AZ DB clusters only
     *
     * Valid Values:
     * + `7`
     * + *month* * 31, where *month* is a number of months from 1-23. Examples: `93` (3 months * 31), `341` (11 months * 31), `589` (19 months * 31)
     * + `731`
     *
     * Default: `7` days
     *
     * If you specify a retention period that isn't valid, such as `94`, Amazon RDS issues an error.
     */
    public val performanceInsightsRetentionPeriod: kotlin.Int? = builder.performanceInsightsRetentionPeriod
    /**
     * The port number on which the DB cluster accepts connections.
     *
     * Valid for Cluster Type: Aurora DB clusters only
     *
     * Valid Values: `1150-65535`
     *
     * Default: The same port as the original DB cluster.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * The daily time range during which automated backups are created if automated backups are enabled, using the `BackupRetentionPeriod` parameter.
     *
     * The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. To view the time blocks available, see [ Backup window](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow) in the *Amazon Aurora User Guide*.
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *
     * Constraints:
     * + Must be in the format `hh24:mi-hh24:mi`.
     * + Must be in Universal Coordinated Time (UTC).
     * + Must not conflict with the preferred maintenance window.
     * + Must be at least 30 minutes.
     */
    public val preferredBackupWindow: kotlin.String? = builder.preferredBackupWindow
    /**
     * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *
     * The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week. To see the time blocks available, see [ Adjusting the Preferred DB Cluster Maintenance Window](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora) in the *Amazon Aurora User Guide*.
     *
     * Constraints:
     * + Must be in the format `ddd:hh24:mi-ddd:hh24:mi`.
     * + Days must be one of `Mon | Tue | Wed | Thu | Fri | Sat | Sun`.
     * + Must be in Universal Coordinated Time (UTC).
     * + Must be at least 30 minutes.
     */
    public val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * Specifies whether to rotate the secret managed by Amazon Web Services Secrets Manager for the master user password.
     *
     * This setting is valid only if the master user password is managed by RDS in Amazon Web Services Secrets Manager for the DB cluster. The secret value contains the updated password.
     *
     * For more information, see [Password management with Amazon Web Services Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html) in the *Amazon RDS User Guide* and [Password management with Amazon Web Services Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html) in the *Amazon Aurora User Guide.*
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *
     * Constraints:
     * + You must apply the change immediately when rotating the master user password.
     */
    public val rotateMasterUserPassword: kotlin.Boolean? = builder.rotateMasterUserPassword
    /**
     * The scaling properties of the DB cluster. You can only modify scaling properties for DB clusters in `serverless` DB engine mode.
     *
     * Valid for Cluster Type: Aurora DB clusters only
     */
    public val scalingConfiguration: aws.sdk.kotlin.services.rds.model.ScalingConfiguration? = builder.scalingConfiguration
    /**
     * Contains the scaling configuration of an Aurora Serverless v2 DB cluster.
     *
     * For more information, see [Using Amazon Aurora Serverless v2](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html) in the *Amazon Aurora User Guide*.
     */
    public val serverlessV2ScalingConfiguration: aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration? = builder.serverlessV2ScalingConfiguration
    /**
     * The storage type to associate with the DB cluster.
     *
     * For information on storage types for Aurora DB clusters, see [Storage configurations for Amazon Aurora DB clusters](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Overview.StorageReliability.html#aurora-storage-type). For information on storage types for Multi-AZ DB clusters, see [Settings for creating Multi-AZ DB clusters](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/create-multi-az-db-cluster.html#create-multi-az-db-cluster-settings).
     *
     * When specified for a Multi-AZ DB cluster, a value for the `Iops` parameter is required.
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *
     * Valid Values:
     * + Aurora DB clusters - `aurora | aurora-iopt1`
     * + Multi-AZ DB clusters - `io1 | io2 | gp3`
     *
     * Default:
     * + Aurora DB clusters - `aurora`
     * + Multi-AZ DB clusters - `io1`
     */
    public val storageType: kotlin.String? = builder.storageType
    /**
     * A list of EC2 VPC security groups to associate with this DB cluster.
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.ModifyDbClusterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyDbClusterRequest(")
        append("allocatedStorage=$allocatedStorage,")
        append("allowEngineModeChange=$allowEngineModeChange,")
        append("allowMajorVersionUpgrade=$allowMajorVersionUpgrade,")
        append("applyImmediately=$applyImmediately,")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("awsBackupRecoveryPointArn=$awsBackupRecoveryPointArn,")
        append("backtrackWindow=$backtrackWindow,")
        append("backupRetentionPeriod=$backupRetentionPeriod,")
        append("caCertificateIdentifier=$caCertificateIdentifier,")
        append("cloudwatchLogsExportConfiguration=$cloudwatchLogsExportConfiguration,")
        append("copyTagsToSnapshot=$copyTagsToSnapshot,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbClusterInstanceClass=$dbClusterInstanceClass,")
        append("dbClusterParameterGroupName=$dbClusterParameterGroupName,")
        append("dbInstanceParameterGroupName=$dbInstanceParameterGroupName,")
        append("deletionProtection=$deletionProtection,")
        append("domain=$domain,")
        append("domainIamRoleName=$domainIamRoleName,")
        append("enableGlobalWriteForwarding=$enableGlobalWriteForwarding,")
        append("enableHttpEndpoint=$enableHttpEndpoint,")
        append("enableIamDatabaseAuthentication=$enableIamDatabaseAuthentication,")
        append("enableLimitlessDatabase=$enableLimitlessDatabase,")
        append("enableLocalWriteForwarding=$enableLocalWriteForwarding,")
        append("enablePerformanceInsights=$enablePerformanceInsights,")
        append("engineMode=$engineMode,")
        append("engineVersion=$engineVersion,")
        append("iops=$iops,")
        append("manageMasterUserPassword=$manageMasterUserPassword,")
        append("masterUserPassword=$masterUserPassword,")
        append("masterUserSecretKmsKeyId=$masterUserSecretKmsKeyId,")
        append("monitoringInterval=$monitoringInterval,")
        append("monitoringRoleArn=$monitoringRoleArn,")
        append("networkType=$networkType,")
        append("newDbClusterIdentifier=$newDbClusterIdentifier,")
        append("optionGroupName=$optionGroupName,")
        append("performanceInsightsKmsKeyId=$performanceInsightsKmsKeyId,")
        append("performanceInsightsRetentionPeriod=$performanceInsightsRetentionPeriod,")
        append("port=$port,")
        append("preferredBackupWindow=$preferredBackupWindow,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("rotateMasterUserPassword=$rotateMasterUserPassword,")
        append("scalingConfiguration=$scalingConfiguration,")
        append("serverlessV2ScalingConfiguration=$serverlessV2ScalingConfiguration,")
        append("storageType=$storageType,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocatedStorage ?: 0
        result = 31 * result + (allowEngineModeChange?.hashCode() ?: 0)
        result = 31 * result + (allowMajorVersionUpgrade?.hashCode() ?: 0)
        result = 31 * result + (applyImmediately?.hashCode() ?: 0)
        result = 31 * result + (autoMinorVersionUpgrade?.hashCode() ?: 0)
        result = 31 * result + (awsBackupRecoveryPointArn?.hashCode() ?: 0)
        result = 31 * result + (backtrackWindow?.hashCode() ?: 0)
        result = 31 * result + (backupRetentionPeriod ?: 0)
        result = 31 * result + (caCertificateIdentifier?.hashCode() ?: 0)
        result = 31 * result + (cloudwatchLogsExportConfiguration?.hashCode() ?: 0)
        result = 31 * result + (copyTagsToSnapshot?.hashCode() ?: 0)
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbClusterInstanceClass?.hashCode() ?: 0)
        result = 31 * result + (dbClusterParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (domainIamRoleName?.hashCode() ?: 0)
        result = 31 * result + (enableGlobalWriteForwarding?.hashCode() ?: 0)
        result = 31 * result + (enableHttpEndpoint?.hashCode() ?: 0)
        result = 31 * result + (enableIamDatabaseAuthentication?.hashCode() ?: 0)
        result = 31 * result + (enableLimitlessDatabase?.hashCode() ?: 0)
        result = 31 * result + (enableLocalWriteForwarding?.hashCode() ?: 0)
        result = 31 * result + (enablePerformanceInsights?.hashCode() ?: 0)
        result = 31 * result + (engineMode?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (manageMasterUserPassword?.hashCode() ?: 0)
        result = 31 * result + (masterUserPassword?.hashCode() ?: 0)
        result = 31 * result + (masterUserSecretKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (monitoringInterval ?: 0)
        result = 31 * result + (monitoringRoleArn?.hashCode() ?: 0)
        result = 31 * result + (networkType?.hashCode() ?: 0)
        result = 31 * result + (newDbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (optionGroupName?.hashCode() ?: 0)
        result = 31 * result + (performanceInsightsKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (performanceInsightsRetentionPeriod ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (preferredBackupWindow?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (rotateMasterUserPassword?.hashCode() ?: 0)
        result = 31 * result + (scalingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (serverlessV2ScalingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModifyDbClusterRequest

        if (allocatedStorage != other.allocatedStorage) return false
        if (allowEngineModeChange != other.allowEngineModeChange) return false
        if (allowMajorVersionUpgrade != other.allowMajorVersionUpgrade) return false
        if (applyImmediately != other.applyImmediately) return false
        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (awsBackupRecoveryPointArn != other.awsBackupRecoveryPointArn) return false
        if (backtrackWindow != other.backtrackWindow) return false
        if (backupRetentionPeriod != other.backupRetentionPeriod) return false
        if (caCertificateIdentifier != other.caCertificateIdentifier) return false
        if (cloudwatchLogsExportConfiguration != other.cloudwatchLogsExportConfiguration) return false
        if (copyTagsToSnapshot != other.copyTagsToSnapshot) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbClusterInstanceClass != other.dbClusterInstanceClass) return false
        if (dbClusterParameterGroupName != other.dbClusterParameterGroupName) return false
        if (dbInstanceParameterGroupName != other.dbInstanceParameterGroupName) return false
        if (deletionProtection != other.deletionProtection) return false
        if (domain != other.domain) return false
        if (domainIamRoleName != other.domainIamRoleName) return false
        if (enableGlobalWriteForwarding != other.enableGlobalWriteForwarding) return false
        if (enableHttpEndpoint != other.enableHttpEndpoint) return false
        if (enableIamDatabaseAuthentication != other.enableIamDatabaseAuthentication) return false
        if (enableLimitlessDatabase != other.enableLimitlessDatabase) return false
        if (enableLocalWriteForwarding != other.enableLocalWriteForwarding) return false
        if (enablePerformanceInsights != other.enablePerformanceInsights) return false
        if (engineMode != other.engineMode) return false
        if (engineVersion != other.engineVersion) return false
        if (iops != other.iops) return false
        if (manageMasterUserPassword != other.manageMasterUserPassword) return false
        if (masterUserPassword != other.masterUserPassword) return false
        if (masterUserSecretKmsKeyId != other.masterUserSecretKmsKeyId) return false
        if (monitoringInterval != other.monitoringInterval) return false
        if (monitoringRoleArn != other.monitoringRoleArn) return false
        if (networkType != other.networkType) return false
        if (newDbClusterIdentifier != other.newDbClusterIdentifier) return false
        if (optionGroupName != other.optionGroupName) return false
        if (performanceInsightsKmsKeyId != other.performanceInsightsKmsKeyId) return false
        if (performanceInsightsRetentionPeriod != other.performanceInsightsRetentionPeriod) return false
        if (port != other.port) return false
        if (preferredBackupWindow != other.preferredBackupWindow) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (rotateMasterUserPassword != other.rotateMasterUserPassword) return false
        if (scalingConfiguration != other.scalingConfiguration) return false
        if (serverlessV2ScalingConfiguration != other.serverlessV2ScalingConfiguration) return false
        if (storageType != other.storageType) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.ModifyDbClusterRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB cluster.
         *
         * Valid for Cluster Type: Multi-AZ DB clusters only
         */
        public var allocatedStorage: kotlin.Int? = null
        /**
         * Specifies whether engine mode changes from `serverless` to `provisioned` are allowed.
         *
         * Valid for Cluster Type: Aurora Serverless v1 DB clusters only
         *
         * Constraints:
         * + You must allow engine mode changes when specifying a different value for the `EngineMode` parameter from the DB cluster's current engine mode.
         */
        public var allowEngineModeChange: kotlin.Boolean? = null
        /**
         * Specifies whether major version upgrades are allowed.
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *
         * Constraints:
         * + You must allow major version upgrades when specifying a value for the `EngineVersion` parameter that is a different major version than the DB cluster's current version.
         */
        public var allowMajorVersionUpgrade: kotlin.Boolean? = null
        /**
         * Specifies whether the modifications in this request and any pending modifications are asynchronously applied as soon as possible, regardless of the `PreferredMaintenanceWindow` setting for the DB cluster. If this parameter is disabled, changes to the DB cluster are applied during the next maintenance window.
         *
         * Most modifications can be applied immediately or during the next scheduled maintenance window. Some modifications, such as turning on deletion protection and changing the master password, are applied immediately—regardless of when you choose to apply them.
         *
         * By default, this parameter is disabled.
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var applyImmediately: kotlin.Boolean? = null
        /**
         * Specifies whether minor engine upgrades are applied automatically to the DB cluster during the maintenance window. By default, minor engine upgrades are applied automatically.
         *
         * Valid for Cluster Type: Multi-AZ DB clusters only
         */
        public var autoMinorVersionUpgrade: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of the recovery point in Amazon Web Services Backup.
         */
        public var awsBackupRecoveryPointArn: kotlin.String? = null
        /**
         * The target backtrack window, in seconds. To disable backtracking, set this value to `0`.
         *
         * Valid for Cluster Type: Aurora MySQL DB clusters only
         *
         * Default: `0`
         *
         * Constraints:
         * + If specified, this value must be set to a number from 0 to 259,200 (72 hours).
         */
        public var backtrackWindow: kotlin.Long? = null
        /**
         * The number of days for which automated backups are retained. Specify a minimum value of `1`.
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *
         * Default: `1`
         *
         * Constraints:
         * + Must be a value from 1 to 35.
         */
        public var backupRetentionPeriod: kotlin.Int? = null
        /**
         * The CA certificate identifier to use for the DB cluster's server certificate.
         *
         * For more information, see [Using SSL/TLS to encrypt a connection to a DB instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html) in the *Amazon RDS User Guide*.
         *
         * Valid for Cluster Type: Multi-AZ DB clusters
         */
        public var caCertificateIdentifier: kotlin.String? = null
        /**
         * The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB cluster.
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *
         * The following values are valid for each DB engine:
         * + Aurora MySQL - `audit | error | general | slowquery`
         * + Aurora PostgreSQL - `postgresql`
         * + RDS for MySQL - `error | general | slowquery`
         * + RDS for PostgreSQL - `postgresql | upgrade`
         *
         * For more information about exporting CloudWatch Logs for Amazon RDS, see [ Publishing Database Logs to Amazon CloudWatch Logs](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch) in the *Amazon RDS User Guide*.
         *
         * For more information about exporting CloudWatch Logs for Amazon Aurora, see [Publishing Database Logs to Amazon CloudWatch Logs](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch) in the *Amazon Aurora User Guide*.
         */
        public var cloudwatchLogsExportConfiguration: aws.sdk.kotlin.services.rds.model.CloudwatchLogsExportConfiguration? = null
        /**
         * Specifies whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default is not to copy them.
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var copyTagsToSnapshot: kotlin.Boolean? = null
        /**
         * The DB cluster identifier for the cluster being modified. This parameter isn't case-sensitive.
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *
         * Constraints:
         * + Must match the identifier of an existing DB cluster.
         */
        public var dbClusterIdentifier: kotlin.String? = null
        /**
         * The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example `db.m6gd.xlarge`. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines.
         *
         * For the full list of DB instance classes and availability for your engine, see [ DB Instance Class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) in the *Amazon RDS User Guide*.
         *
         * Valid for Cluster Type: Multi-AZ DB clusters only
         */
        public var dbClusterInstanceClass: kotlin.String? = null
        /**
         * The name of the DB cluster parameter group to use for the DB cluster.
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var dbClusterParameterGroupName: kotlin.String? = null
        /**
         * The name of the DB parameter group to apply to all instances of the DB cluster.
         *
         * When you apply a parameter group using the `DBInstanceParameterGroupName` parameter, the DB cluster isn't rebooted automatically. Also, parameter changes are applied immediately rather than during the next maintenance window.
         *
         * Valid for Cluster Type: Aurora DB clusters only
         *
         * Default: The existing name setting
         *
         * Constraints:
         * + The DB parameter group must be in the same DB parameter group family as this DB cluster.
         * + The `DBInstanceParameterGroupName` parameter is valid in combination with the `AllowMajorVersionUpgrade` parameter for a major version upgrade only.
         */
        public var dbInstanceParameterGroupName: kotlin.String? = null
        /**
         * Specifies whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled.
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var deletionProtection: kotlin.Boolean? = null
        /**
         * The Active Directory directory ID to move the DB cluster to. Specify `none` to remove the cluster from its current domain. The domain must be created prior to this operation.
         *
         * For more information, see [Kerberos Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html) in the *Amazon Aurora User Guide*.
         *
         * Valid for Cluster Type: Aurora DB clusters only
         */
        public var domain: kotlin.String? = null
        /**
         * The name of the IAM role to use when making API calls to the Directory Service.
         *
         * Valid for Cluster Type: Aurora DB clusters only
         */
        public var domainIamRoleName: kotlin.String? = null
        /**
         * Specifies whether to enable this DB cluster to forward write operations to the primary cluster of a global cluster (Aurora global database). By default, write operations are not allowed on Aurora DB clusters that are secondary clusters in an Aurora global database.
         *
         * You can set this value only on Aurora DB clusters that are members of an Aurora global database. With this parameter enabled, a secondary cluster can forward writes to the current primary cluster, and the resulting changes are replicated back to this cluster. For the primary DB cluster of an Aurora global database, this value is used immediately if the primary is demoted by a global cluster API operation, but it does nothing until then.
         *
         * Valid for Cluster Type: Aurora DB clusters only
         */
        public var enableGlobalWriteForwarding: kotlin.Boolean? = null
        /**
         * Specifies whether to enable the HTTP endpoint for an Aurora Serverless v1 DB cluster. By default, the HTTP endpoint isn't enabled.
         *
         * When enabled, the HTTP endpoint provides a connectionless web service API (RDS Data API) for running SQL queries on the Aurora Serverless v1 DB cluster. You can also query your database from inside the RDS console with the RDS query editor.
         *
         * For more information, see [Using RDS Data API](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html) in the *Amazon Aurora User Guide*.
         *
         * This parameter applies only to Aurora Serverless v1 DB clusters. To enable or disable the HTTP endpoint for an Aurora PostgreSQL Serverless v2 or provisioned DB cluster, use the `EnableHttpEndpoint` and `DisableHttpEndpoint` operations.
         *
         * Valid for Cluster Type: Aurora DB clusters only
         */
        public var enableHttpEndpoint: kotlin.Boolean? = null
        /**
         * Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn't enabled.
         *
         * For more information, see [ IAM Database Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html) in the *Amazon Aurora User Guide*.
         *
         * Valid for Cluster Type: Aurora DB clusters only
         */
        public var enableIamDatabaseAuthentication: kotlin.Boolean? = null
        /**
         * Specifies whether to enable Aurora Limitless Database. You must enable Aurora Limitless Database to create a DB shard group.
         *
         * Valid for: Aurora DB clusters only
         */
        public var enableLimitlessDatabase: kotlin.Boolean? = null
        /**
         * Specifies whether read replicas can forward write operations to the writer DB instance in the DB cluster. By default, write operations aren't allowed on reader DB instances.
         *
         * Valid for: Aurora DB clusters only
         */
        public var enableLocalWriteForwarding: kotlin.Boolean? = null
        /**
         * Specifies whether to turn on Performance Insights for the DB cluster.
         *
         * For more information, see [ Using Amazon Performance Insights](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html) in the *Amazon RDS User Guide*.
         *
         * Valid for Cluster Type: Multi-AZ DB clusters only
         */
        public var enablePerformanceInsights: kotlin.Boolean? = null
        /**
         * The DB engine mode of the DB cluster, either `provisioned` or `serverless`.
         *
         * The DB engine mode can be modified only from `serverless` to `provisioned`.
         *
         * For more information, see [ CreateDBCluster](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBCluster.html).
         *
         * Valid for Cluster Type: Aurora DB clusters only
         */
        public var engineMode: kotlin.String? = null
        /**
         * The version number of the database engine to which you want to upgrade. Changing this parameter results in an outage. The change is applied during the next maintenance window unless `ApplyImmediately` is enabled.
         *
         * If the cluster that you're modifying has one or more read replicas, all replicas must be running an engine version that's the same or later than the version you specify.
         *
         * To list all of the available engine versions for Aurora MySQL, use the following command:
         *
         * `aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"`
         *
         * To list all of the available engine versions for Aurora PostgreSQL, use the following command:
         *
         * `aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"`
         *
         * To list all of the available engine versions for RDS for MySQL, use the following command:
         *
         * `aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"`
         *
         * To list all of the available engine versions for RDS for PostgreSQL, use the following command:
         *
         * `aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"`
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB instance in the Multi-AZ DB cluster.
         *
         * For information about valid IOPS values, see [Amazon RDS Provisioned IOPS storage](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS) in the *Amazon RDS User Guide*.
         *
         * Valid for Cluster Type: Multi-AZ DB clusters only
         *
         * Constraints:
         * + Must be a multiple between .5 and 50 of the storage amount for the DB cluster.
         */
        public var iops: kotlin.Int? = null
        /**
         * Specifies whether to manage the master user password with Amazon Web Services Secrets Manager.
         *
         * If the DB cluster doesn't manage the master user password with Amazon Web Services Secrets Manager, you can turn on this management. In this case, you can't specify `MasterUserPassword`.
         *
         * If the DB cluster already manages the master user password with Amazon Web Services Secrets Manager, and you specify that the master user password is not managed with Amazon Web Services Secrets Manager, then you must specify `MasterUserPassword`. In this case, RDS deletes the secret and uses the new password for the master user specified by `MasterUserPassword`.
         *
         * For more information, see [Password management with Amazon Web Services Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html) in the *Amazon RDS User Guide* and [Password management with Amazon Web Services Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html) in the *Amazon Aurora User Guide.*
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var manageMasterUserPassword: kotlin.Boolean? = null
        /**
         * The new password for the master database user.
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *
         * Constraints:
         * + Must contain from 8 to 41 characters.
         * + Can contain any printable ASCII character except "/", """, or "@".
         * + Can't be specified if `ManageMasterUserPassword` is turned on.
         */
        public var masterUserPassword: kotlin.String? = null
        /**
         * The Amazon Web Services KMS key identifier to encrypt a secret that is automatically generated and managed in Amazon Web Services Secrets Manager.
         *
         * This setting is valid only if both of the following conditions are met:
         * + The DB cluster doesn't manage the master user password in Amazon Web Services Secrets Manager.If the DB cluster already manages the master user password in Amazon Web Services Secrets Manager, you can't change the KMS key that is used to encrypt the secret.
         * + You are turning on `ManageMasterUserPassword` to manage the master user password in Amazon Web Services Secrets Manager.If you are turning on `ManageMasterUserPassword` and don't specify `MasterUserSecretKmsKeyId`, then the `aws/secretsmanager` KMS key is used to encrypt the secret. If the secret is in a different Amazon Web Services account, then you can't use the `aws/secretsmanager` KMS key to encrypt the secret, and you must use a customer managed KMS key.
         *
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
         *
         * There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var masterUserSecretKmsKeyId: kotlin.String? = null
        /**
         * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster. To turn off collecting Enhanced Monitoring metrics, specify `0`.
         *
         * If `MonitoringRoleArn` is specified, also set `MonitoringInterval` to a value other than `0`.
         *
         * Valid for Cluster Type: Multi-AZ DB clusters only
         *
         * Valid Values: `0 | 1 | 5 | 10 | 15 | 30 | 60`
         *
         * Default: `0`
         */
        public var monitoringInterval: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs. An example is `arn:aws:iam:123456789012:role/emaccess`. For information on creating a monitoring role, see [To create an IAM role for Amazon RDS Enhanced Monitoring](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole) in the *Amazon RDS User Guide.*
         *
         * If `MonitoringInterval` is set to a value other than `0`, supply a `MonitoringRoleArn` value.
         *
         * Valid for Cluster Type: Multi-AZ DB clusters only
         */
        public var monitoringRoleArn: kotlin.String? = null
        /**
         * The network type of the DB cluster.
         *
         * The network type is determined by the `DBSubnetGroup` specified for the DB cluster. A `DBSubnetGroup` can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (`DUAL`).
         *
         * For more information, see [ Working with a DB instance in a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html) in the *Amazon Aurora User Guide.*
         *
         * Valid for Cluster Type: Aurora DB clusters only
         *
         * Valid Values: `IPV4 | DUAL`
         */
        public var networkType: kotlin.String? = null
        /**
         * The new DB cluster identifier for the DB cluster when renaming a DB cluster. This value is stored as a lowercase string.
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *
         * Constraints:
         * + Must contain from 1 to 63 letters, numbers, or hyphens.
         * + The first character must be a letter.
         * + Can't end with a hyphen or contain two consecutive hyphens.
         *
         * Example: `my-cluster2`
         */
        public var newDbClusterIdentifier: kotlin.String? = null
        /**
         * The option group to associate the DB cluster with.
         *
         * DB clusters are associated with a default option group that can't be modified.
         */
        public var optionGroupName: kotlin.String? = null
        /**
         * The Amazon Web Services KMS key identifier for encryption of Performance Insights data.
         *
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         *
         * If you don't specify a value for `PerformanceInsightsKMSKeyId`, then Amazon RDS uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.
         *
         * Valid for Cluster Type: Multi-AZ DB clusters only
         */
        public var performanceInsightsKmsKeyId: kotlin.String? = null
        /**
         * The number of days to retain Performance Insights data.
         *
         * Valid for Cluster Type: Multi-AZ DB clusters only
         *
         * Valid Values:
         * + `7`
         * + *month* * 31, where *month* is a number of months from 1-23. Examples: `93` (3 months * 31), `341` (11 months * 31), `589` (19 months * 31)
         * + `731`
         *
         * Default: `7` days
         *
         * If you specify a retention period that isn't valid, such as `94`, Amazon RDS issues an error.
         */
        public var performanceInsightsRetentionPeriod: kotlin.Int? = null
        /**
         * The port number on which the DB cluster accepts connections.
         *
         * Valid for Cluster Type: Aurora DB clusters only
         *
         * Valid Values: `1150-65535`
         *
         * Default: The same port as the original DB cluster.
         */
        public var port: kotlin.Int? = null
        /**
         * The daily time range during which automated backups are created if automated backups are enabled, using the `BackupRetentionPeriod` parameter.
         *
         * The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. To view the time blocks available, see [ Backup window](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow) in the *Amazon Aurora User Guide*.
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *
         * Constraints:
         * + Must be in the format `hh24:mi-hh24:mi`.
         * + Must be in Universal Coordinated Time (UTC).
         * + Must not conflict with the preferred maintenance window.
         * + Must be at least 30 minutes.
         */
        public var preferredBackupWindow: kotlin.String? = null
        /**
         * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *
         * The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week. To see the time blocks available, see [ Adjusting the Preferred DB Cluster Maintenance Window](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora) in the *Amazon Aurora User Guide*.
         *
         * Constraints:
         * + Must be in the format `ddd:hh24:mi-ddd:hh24:mi`.
         * + Days must be one of `Mon | Tue | Wed | Thu | Fri | Sat | Sun`.
         * + Must be in Universal Coordinated Time (UTC).
         * + Must be at least 30 minutes.
         */
        public var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * Specifies whether to rotate the secret managed by Amazon Web Services Secrets Manager for the master user password.
         *
         * This setting is valid only if the master user password is managed by RDS in Amazon Web Services Secrets Manager for the DB cluster. The secret value contains the updated password.
         *
         * For more information, see [Password management with Amazon Web Services Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html) in the *Amazon RDS User Guide* and [Password management with Amazon Web Services Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html) in the *Amazon Aurora User Guide.*
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *
         * Constraints:
         * + You must apply the change immediately when rotating the master user password.
         */
        public var rotateMasterUserPassword: kotlin.Boolean? = null
        /**
         * The scaling properties of the DB cluster. You can only modify scaling properties for DB clusters in `serverless` DB engine mode.
         *
         * Valid for Cluster Type: Aurora DB clusters only
         */
        public var scalingConfiguration: aws.sdk.kotlin.services.rds.model.ScalingConfiguration? = null
        /**
         * Contains the scaling configuration of an Aurora Serverless v2 DB cluster.
         *
         * For more information, see [Using Amazon Aurora Serverless v2](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html) in the *Amazon Aurora User Guide*.
         */
        public var serverlessV2ScalingConfiguration: aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration? = null
        /**
         * The storage type to associate with the DB cluster.
         *
         * For information on storage types for Aurora DB clusters, see [Storage configurations for Amazon Aurora DB clusters](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Overview.StorageReliability.html#aurora-storage-type). For information on storage types for Multi-AZ DB clusters, see [Settings for creating Multi-AZ DB clusters](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/create-multi-az-db-cluster.html#create-multi-az-db-cluster-settings).
         *
         * When specified for a Multi-AZ DB cluster, a value for the `Iops` parameter is required.
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *
         * Valid Values:
         * + Aurora DB clusters - `aurora | aurora-iopt1`
         * + Multi-AZ DB clusters - `io1 | io2 | gp3`
         *
         * Default:
         * + Aurora DB clusters - `aurora`
         * + Multi-AZ DB clusters - `io1`
         */
        public var storageType: kotlin.String? = null
        /**
         * A list of EC2 VPC security groups to associate with this DB cluster.
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var vpcSecurityGroupIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.ModifyDbClusterRequest) : this() {
            this.allocatedStorage = x.allocatedStorage
            this.allowEngineModeChange = x.allowEngineModeChange
            this.allowMajorVersionUpgrade = x.allowMajorVersionUpgrade
            this.applyImmediately = x.applyImmediately
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.awsBackupRecoveryPointArn = x.awsBackupRecoveryPointArn
            this.backtrackWindow = x.backtrackWindow
            this.backupRetentionPeriod = x.backupRetentionPeriod
            this.caCertificateIdentifier = x.caCertificateIdentifier
            this.cloudwatchLogsExportConfiguration = x.cloudwatchLogsExportConfiguration
            this.copyTagsToSnapshot = x.copyTagsToSnapshot
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbClusterInstanceClass = x.dbClusterInstanceClass
            this.dbClusterParameterGroupName = x.dbClusterParameterGroupName
            this.dbInstanceParameterGroupName = x.dbInstanceParameterGroupName
            this.deletionProtection = x.deletionProtection
            this.domain = x.domain
            this.domainIamRoleName = x.domainIamRoleName
            this.enableGlobalWriteForwarding = x.enableGlobalWriteForwarding
            this.enableHttpEndpoint = x.enableHttpEndpoint
            this.enableIamDatabaseAuthentication = x.enableIamDatabaseAuthentication
            this.enableLimitlessDatabase = x.enableLimitlessDatabase
            this.enableLocalWriteForwarding = x.enableLocalWriteForwarding
            this.enablePerformanceInsights = x.enablePerformanceInsights
            this.engineMode = x.engineMode
            this.engineVersion = x.engineVersion
            this.iops = x.iops
            this.manageMasterUserPassword = x.manageMasterUserPassword
            this.masterUserPassword = x.masterUserPassword
            this.masterUserSecretKmsKeyId = x.masterUserSecretKmsKeyId
            this.monitoringInterval = x.monitoringInterval
            this.monitoringRoleArn = x.monitoringRoleArn
            this.networkType = x.networkType
            this.newDbClusterIdentifier = x.newDbClusterIdentifier
            this.optionGroupName = x.optionGroupName
            this.performanceInsightsKmsKeyId = x.performanceInsightsKmsKeyId
            this.performanceInsightsRetentionPeriod = x.performanceInsightsRetentionPeriod
            this.port = x.port
            this.preferredBackupWindow = x.preferredBackupWindow
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.rotateMasterUserPassword = x.rotateMasterUserPassword
            this.scalingConfiguration = x.scalingConfiguration
            this.serverlessV2ScalingConfiguration = x.serverlessV2ScalingConfiguration
            this.storageType = x.storageType
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.ModifyDbClusterRequest = ModifyDbClusterRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.CloudwatchLogsExportConfiguration] inside the given [block]
         */
        public fun cloudwatchLogsExportConfiguration(block: aws.sdk.kotlin.services.rds.model.CloudwatchLogsExportConfiguration.Builder.() -> kotlin.Unit) {
            this.cloudwatchLogsExportConfiguration = aws.sdk.kotlin.services.rds.model.CloudwatchLogsExportConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.ScalingConfiguration] inside the given [block]
         */
        public fun scalingConfiguration(block: aws.sdk.kotlin.services.rds.model.ScalingConfiguration.Builder.() -> kotlin.Unit) {
            this.scalingConfiguration = aws.sdk.kotlin.services.rds.model.ScalingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration] inside the given [block]
         */
        public fun serverlessV2ScalingConfiguration(block: aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration.Builder.() -> kotlin.Unit) {
            this.serverlessV2ScalingConfiguration = aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
