// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A data structure with information about any primary and secondary clusters associated with a global cluster (Aurora global database).
 */
public class GlobalClusterMember private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for each Aurora DB cluster in the global cluster.
     */
    public val dbClusterArn: kotlin.String? = builder.dbClusterArn
    /**
     * The status of write forwarding for a secondary cluster in the global cluster.
     */
    public val globalWriteForwardingStatus: aws.sdk.kotlin.services.rds.model.WriteForwardingStatus? = builder.globalWriteForwardingStatus
    /**
     * Indicates whether the Aurora DB cluster is the primary cluster (that is, has read-write capability) for the global cluster with which it is associated.
     */
    public val isWriter: kotlin.Boolean? = builder.isWriter
    /**
     * The Amazon Resource Name (ARN) for each read-only secondary cluster associated with the global cluster.
     */
    public val readers: List<String>? = builder.readers
    /**
     * The status of synchronization of each Aurora DB cluster in the global cluster.
     */
    public val synchronizationStatus: aws.sdk.kotlin.services.rds.model.GlobalClusterMemberSynchronizationStatus? = builder.synchronizationStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.GlobalClusterMember = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GlobalClusterMember(")
        append("dbClusterArn=$dbClusterArn,")
        append("globalWriteForwardingStatus=$globalWriteForwardingStatus,")
        append("isWriter=$isWriter,")
        append("readers=$readers,")
        append("synchronizationStatus=$synchronizationStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbClusterArn?.hashCode() ?: 0
        result = 31 * result + (globalWriteForwardingStatus?.hashCode() ?: 0)
        result = 31 * result + (isWriter?.hashCode() ?: 0)
        result = 31 * result + (readers?.hashCode() ?: 0)
        result = 31 * result + (synchronizationStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GlobalClusterMember

        if (dbClusterArn != other.dbClusterArn) return false
        if (globalWriteForwardingStatus != other.globalWriteForwardingStatus) return false
        if (isWriter != other.isWriter) return false
        if (readers != other.readers) return false
        if (synchronizationStatus != other.synchronizationStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.GlobalClusterMember = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) for each Aurora DB cluster in the global cluster.
         */
        public var dbClusterArn: kotlin.String? = null
        /**
         * The status of write forwarding for a secondary cluster in the global cluster.
         */
        public var globalWriteForwardingStatus: aws.sdk.kotlin.services.rds.model.WriteForwardingStatus? = null
        /**
         * Indicates whether the Aurora DB cluster is the primary cluster (that is, has read-write capability) for the global cluster with which it is associated.
         */
        public var isWriter: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) for each read-only secondary cluster associated with the global cluster.
         */
        public var readers: List<String>? = null
        /**
         * The status of synchronization of each Aurora DB cluster in the global cluster.
         */
        public var synchronizationStatus: aws.sdk.kotlin.services.rds.model.GlobalClusterMemberSynchronizationStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.GlobalClusterMember) : this() {
            this.dbClusterArn = x.dbClusterArn
            this.globalWriteForwardingStatus = x.globalWriteForwardingStatus
            this.isWriter = x.isWriter
            this.readers = x.readers
            this.synchronizationStatus = x.synchronizationStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.GlobalClusterMember = GlobalClusterMember(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
