// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An Active Directory Domain membership record associated with the DB instance or cluster.
 */
public class DomainMembership private constructor(builder: Builder) {
    /**
     * The ARN for the Secrets Manager secret with the credentials for the user that's a member of the domain.
     */
    public val authSecretArn: kotlin.String? = builder.authSecretArn
    /**
     * The IPv4 DNS IP addresses of the primary and secondary Active Directory domain controllers.
     */
    public val dnsIps: List<String>? = builder.dnsIps
    /**
     * The identifier of the Active Directory Domain.
     */
    public val domain: kotlin.String? = builder.domain
    /**
     * The fully qualified domain name (FQDN) of the Active Directory Domain.
     */
    public val fqdn: kotlin.String? = builder.fqdn
    /**
     * The name of the IAM role used when making API calls to the Directory Service.
     */
    public val iamRoleName: kotlin.String? = builder.iamRoleName
    /**
     * The Active Directory organizational unit for the DB instance or cluster.
     */
    public val ou: kotlin.String? = builder.ou
    /**
     * The status of the Active Directory Domain membership for the DB instance or cluster. Values include `joined`, `pending-join`, `failed`, and so on.
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DomainMembership = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DomainMembership(")
        append("authSecretArn=$authSecretArn,")
        append("dnsIps=$dnsIps,")
        append("domain=$domain,")
        append("fqdn=$fqdn,")
        append("iamRoleName=$iamRoleName,")
        append("ou=$ou,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authSecretArn?.hashCode() ?: 0
        result = 31 * result + (dnsIps?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (fqdn?.hashCode() ?: 0)
        result = 31 * result + (iamRoleName?.hashCode() ?: 0)
        result = 31 * result + (ou?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DomainMembership

        if (authSecretArn != other.authSecretArn) return false
        if (dnsIps != other.dnsIps) return false
        if (domain != other.domain) return false
        if (fqdn != other.fqdn) return false
        if (iamRoleName != other.iamRoleName) return false
        if (ou != other.ou) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DomainMembership = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN for the Secrets Manager secret with the credentials for the user that's a member of the domain.
         */
        public var authSecretArn: kotlin.String? = null
        /**
         * The IPv4 DNS IP addresses of the primary and secondary Active Directory domain controllers.
         */
        public var dnsIps: List<String>? = null
        /**
         * The identifier of the Active Directory Domain.
         */
        public var domain: kotlin.String? = null
        /**
         * The fully qualified domain name (FQDN) of the Active Directory Domain.
         */
        public var fqdn: kotlin.String? = null
        /**
         * The name of the IAM role used when making API calls to the Directory Service.
         */
        public var iamRoleName: kotlin.String? = null
        /**
         * The Active Directory organizational unit for the DB instance or cluster.
         */
        public var ou: kotlin.String? = null
        /**
         * The status of the Active Directory Domain membership for the DB instance or cluster. Values include `joined`, `pending-join`, `failed`, and so on.
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DomainMembership) : this() {
            this.authSecretArn = x.authSecretArn
            this.dnsIps = x.dnsIps
            this.domain = x.domain
            this.fqdn = x.fqdn
            this.iamRoleName = x.iamRoleName
            this.ou = x.ou
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DomainMembership = DomainMembership(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
