// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.SdkDsl

public class DescribeDbShardGroupsRequest private constructor(builder: Builder) {
    /**
     * The user-supplied DB shard group identifier or the Amazon Resource Name (ARN) of the DB shard group. If this parameter is specified, information for only the specific DB shard group is returned. This parameter isn't case-sensitive.
     *
     * Constraints:
     * + If supplied, must match an existing DB shard group identifier.
     */
    public val dbShardGroupIdentifier: kotlin.String? = builder.dbShardGroupIdentifier
    /**
     * A filter that specifies one or more DB shard groups to describe.
     */
    public val filters: List<Filter>? = builder.filters
    /**
     * An optional pagination token provided by a previous `DescribeDBShardGroups` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by `MaxRecords`.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * The maximum number of records to include in the response. If more records exist than the specified `MaxRecords` value, a pagination token called a marker is included in the response so you can retrieve the remaining results.
     *
     * Default: 100
     *
     * Constraints: Minimum 20, maximum 100
     */
    public val maxRecords: kotlin.Int? = builder.maxRecords

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DescribeDbShardGroupsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeDbShardGroupsRequest(")
        append("dbShardGroupIdentifier=$dbShardGroupIdentifier,")
        append("filters=$filters,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbShardGroupIdentifier?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeDbShardGroupsRequest

        if (dbShardGroupIdentifier != other.dbShardGroupIdentifier) return false
        if (filters != other.filters) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DescribeDbShardGroupsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The user-supplied DB shard group identifier or the Amazon Resource Name (ARN) of the DB shard group. If this parameter is specified, information for only the specific DB shard group is returned. This parameter isn't case-sensitive.
         *
         * Constraints:
         * + If supplied, must match an existing DB shard group identifier.
         */
        public var dbShardGroupIdentifier: kotlin.String? = null
        /**
         * A filter that specifies one or more DB shard groups to describe.
         */
        public var filters: List<Filter>? = null
        /**
         * An optional pagination token provided by a previous `DescribeDBShardGroups` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by `MaxRecords`.
         */
        public var marker: kotlin.String? = null
        /**
         * The maximum number of records to include in the response. If more records exist than the specified `MaxRecords` value, a pagination token called a marker is included in the response so you can retrieve the remaining results.
         *
         * Default: 100
         *
         * Constraints: Minimum 20, maximum 100
         */
        public var maxRecords: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DescribeDbShardGroupsRequest) : this() {
            this.dbShardGroupIdentifier = x.dbShardGroupIdentifier
            this.filters = x.filters
            this.marker = x.marker
            this.maxRecords = x.maxRecords
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DescribeDbShardGroupsRequest = DescribeDbShardGroupsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
