// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 *
 */
public class DescribeDbClusterBacktracksRequest private constructor(builder: Builder) {
    /**
     * If specified, this value is the backtrack identifier of the backtrack to be described.
     *
     * Constraints:
     * + Must contain a valid universally unique identifier (UUID). For more information about UUIDs, see [Universally unique identifier](https://en.wikipedia.org/wiki/Universally_unique_identifier).
     *
     * Example: `123e4567-e89b-12d3-a456-426655440000`
     */
    public val backtrackIdentifier: kotlin.String? = builder.backtrackIdentifier
    /**
     * The DB cluster identifier of the DB cluster to be described. This parameter is stored as a lowercase string.
     *
     * Constraints:
     * + Must contain from 1 to 63 alphanumeric characters or hyphens.
     * + First character must be a letter.
     * + Can't end with a hyphen or contain two consecutive hyphens.
     *
     * Example: `my-cluster1`
     */
    public val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * A filter that specifies one or more DB clusters to describe. Supported filters include the following:
     * + `db-cluster-backtrack-id` - Accepts backtrack identifiers. The results list includes information about only the backtracks identified by these identifiers.
     * + `db-cluster-backtrack-status` - Accepts any of the following backtrack status values:
     *    + `applying`
     *    + `completed`
     *    + `failed`
     *    + `pending`
     * The results list includes information about only the backtracks identified by these values.
     */
    public val filters: List<Filter>? = builder.filters
    /**
     * An optional pagination token provided by a previous `DescribeDBClusterBacktracks` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by `MaxRecords`.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * The maximum number of records to include in the response. If more records exist than the specified `MaxRecords` value, a pagination token called a marker is included in the response so you can retrieve the remaining results.
     *
     * Default: 100
     *
     * Constraints: Minimum 20, maximum 100.
     */
    public val maxRecords: kotlin.Int? = builder.maxRecords

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DescribeDbClusterBacktracksRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeDbClusterBacktracksRequest(")
        append("backtrackIdentifier=$backtrackIdentifier,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("filters=$filters,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = backtrackIdentifier?.hashCode() ?: 0
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeDbClusterBacktracksRequest

        if (backtrackIdentifier != other.backtrackIdentifier) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (filters != other.filters) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DescribeDbClusterBacktracksRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * If specified, this value is the backtrack identifier of the backtrack to be described.
         *
         * Constraints:
         * + Must contain a valid universally unique identifier (UUID). For more information about UUIDs, see [Universally unique identifier](https://en.wikipedia.org/wiki/Universally_unique_identifier).
         *
         * Example: `123e4567-e89b-12d3-a456-426655440000`
         */
        public var backtrackIdentifier: kotlin.String? = null
        /**
         * The DB cluster identifier of the DB cluster to be described. This parameter is stored as a lowercase string.
         *
         * Constraints:
         * + Must contain from 1 to 63 alphanumeric characters or hyphens.
         * + First character must be a letter.
         * + Can't end with a hyphen or contain two consecutive hyphens.
         *
         * Example: `my-cluster1`
         */
        public var dbClusterIdentifier: kotlin.String? = null
        /**
         * A filter that specifies one or more DB clusters to describe. Supported filters include the following:
         * + `db-cluster-backtrack-id` - Accepts backtrack identifiers. The results list includes information about only the backtracks identified by these identifiers.
         * + `db-cluster-backtrack-status` - Accepts any of the following backtrack status values:
         *    + `applying`
         *    + `completed`
         *    + `failed`
         *    + `pending`
         * The results list includes information about only the backtracks identified by these values.
         */
        public var filters: List<Filter>? = null
        /**
         * An optional pagination token provided by a previous `DescribeDBClusterBacktracks` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by `MaxRecords`.
         */
        public var marker: kotlin.String? = null
        /**
         * The maximum number of records to include in the response. If more records exist than the specified `MaxRecords` value, a pagination token called a marker is included in the response so you can retrieve the remaining results.
         *
         * Default: 100
         *
         * Constraints: Minimum 20, maximum 100.
         */
        public var maxRecords: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DescribeDbClusterBacktracksRequest) : this() {
            this.backtrackIdentifier = x.backtrackIdentifier
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.filters = x.filters
            this.marker = x.marker
            this.maxRecords = x.maxRecords
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DescribeDbClusterBacktracksRequest = DescribeDbClusterBacktracksRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
