// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.SdkDsl

public class DescribeDbClusterAutomatedBackupsRequest private constructor(builder: Builder) {
    /**
     * (Optional) The user-supplied DB cluster identifier. If this parameter is specified, it must match the identifier of an existing DB cluster. It returns information from the specific DB cluster's automated backup. This parameter isn't case-sensitive.
     */
    public val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * The resource ID of the DB cluster that is the source of the automated backup. This parameter isn't case-sensitive.
     */
    public val dbClusterResourceId: kotlin.String? = builder.dbClusterResourceId
    /**
     * A filter that specifies which resources to return based on status.
     *
     * Supported filters are the following:
     * + `status`
     *    + `retained` - Automated backups for deleted clusters and after backup replication is stopped.
     * + `db-cluster-id` - Accepts DB cluster identifiers and Amazon Resource Names (ARNs). The results list includes only information about the DB cluster automated backups identified by these ARNs.
     * + `db-cluster-resource-id` - Accepts DB resource identifiers and Amazon Resource Names (ARNs). The results list includes only information about the DB cluster resources identified by these ARNs.
     *
     * Returns all resources by default. The status for each resource is specified in the response.
     */
    public val filters: List<Filter>? = builder.filters
    /**
     * The pagination token provided in the previous request. If this parameter is specified the response includes only records beyond the marker, up to `MaxRecords`.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * The maximum number of records to include in the response. If more records exist than the specified `MaxRecords` value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.
     */
    public val maxRecords: kotlin.Int? = builder.maxRecords

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DescribeDbClusterAutomatedBackupsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeDbClusterAutomatedBackupsRequest(")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbClusterResourceId=$dbClusterResourceId,")
        append("filters=$filters,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbClusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (dbClusterResourceId?.hashCode() ?: 0)
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeDbClusterAutomatedBackupsRequest

        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbClusterResourceId != other.dbClusterResourceId) return false
        if (filters != other.filters) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DescribeDbClusterAutomatedBackupsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * (Optional) The user-supplied DB cluster identifier. If this parameter is specified, it must match the identifier of an existing DB cluster. It returns information from the specific DB cluster's automated backup. This parameter isn't case-sensitive.
         */
        public var dbClusterIdentifier: kotlin.String? = null
        /**
         * The resource ID of the DB cluster that is the source of the automated backup. This parameter isn't case-sensitive.
         */
        public var dbClusterResourceId: kotlin.String? = null
        /**
         * A filter that specifies which resources to return based on status.
         *
         * Supported filters are the following:
         * + `status`
         *    + `retained` - Automated backups for deleted clusters and after backup replication is stopped.
         * + `db-cluster-id` - Accepts DB cluster identifiers and Amazon Resource Names (ARNs). The results list includes only information about the DB cluster automated backups identified by these ARNs.
         * + `db-cluster-resource-id` - Accepts DB resource identifiers and Amazon Resource Names (ARNs). The results list includes only information about the DB cluster resources identified by these ARNs.
         *
         * Returns all resources by default. The status for each resource is specified in the response.
         */
        public var filters: List<Filter>? = null
        /**
         * The pagination token provided in the previous request. If this parameter is specified the response includes only records beyond the marker, up to `MaxRecords`.
         */
        public var marker: kotlin.String? = null
        /**
         * The maximum number of records to include in the response. If more records exist than the specified `MaxRecords` value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.
         */
        public var maxRecords: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DescribeDbClusterAutomatedBackupsRequest) : this() {
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbClusterResourceId = x.dbClusterResourceId
            this.filters = x.filters
            this.marker = x.marker
            this.maxRecords = x.maxRecords
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DescribeDbClusterAutomatedBackupsRequest = DescribeDbClusterAutomatedBackupsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
