// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains the details of a tenant database in a snapshot of a DB instance.
 */
public class DbSnapshotTenantDatabase private constructor(builder: Builder) {
    /**
     * The name of the character set of a tenant database.
     */
    public val characterSetName: kotlin.String? = builder.characterSetName
    /**
     * The ID for the DB instance that contains the tenant databases.
     */
    public val dbInstanceIdentifier: kotlin.String? = builder.dbInstanceIdentifier
    /**
     * The identifier for the snapshot of the DB instance.
     */
    public val dbSnapshotIdentifier: kotlin.String? = builder.dbSnapshotIdentifier
    /**
     * The Amazon Resource Name (ARN) for the snapshot tenant database.
     */
    public val dbSnapshotTenantDatabaseArn: kotlin.String? = builder.dbSnapshotTenantDatabaseArn
    /**
     * The resource identifier of the source CDB instance. This identifier can't be changed and is unique to an Amazon Web Services Region.
     */
    public val dbiResourceId: kotlin.String? = builder.dbiResourceId
    /**
     * The name of the database engine.
     */
    public val engineName: kotlin.String? = builder.engineName
    /**
     * The master username of the tenant database.
     */
    public val masterUsername: kotlin.String? = builder.masterUsername
    /**
     * The `NCHAR` character set name of the tenant database.
     */
    public val ncharCharacterSetName: kotlin.String? = builder.ncharCharacterSetName
    /**
     * The type of DB snapshot.
     */
    public val snapshotType: kotlin.String? = builder.snapshotType
    /**
     * A list of tags. For more information, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide.*
     */
    public val tagList: List<Tag>? = builder.tagList
    /**
     * The time the DB snapshot was taken, specified in Coordinated Universal Time (UTC). If you copy the snapshot, the creation time changes.
     */
    public val tenantDatabaseCreateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.tenantDatabaseCreateTime
    /**
     * The resource ID of the tenant database.
     */
    public val tenantDatabaseResourceId: kotlin.String? = builder.tenantDatabaseResourceId
    /**
     * The name of the tenant database.
     */
    public val tenantDbName: kotlin.String? = builder.tenantDbName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DbSnapshotTenantDatabase = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DbSnapshotTenantDatabase(")
        append("characterSetName=$characterSetName,")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("dbSnapshotIdentifier=$dbSnapshotIdentifier,")
        append("dbSnapshotTenantDatabaseArn=$dbSnapshotTenantDatabaseArn,")
        append("dbiResourceId=$dbiResourceId,")
        append("engineName=$engineName,")
        append("masterUsername=$masterUsername,")
        append("ncharCharacterSetName=$ncharCharacterSetName,")
        append("snapshotType=$snapshotType,")
        append("tagList=$tagList,")
        append("tenantDatabaseCreateTime=$tenantDatabaseCreateTime,")
        append("tenantDatabaseResourceId=$tenantDatabaseResourceId,")
        append("tenantDbName=$tenantDbName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = characterSetName?.hashCode() ?: 0
        result = 31 * result + (dbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbSnapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbSnapshotTenantDatabaseArn?.hashCode() ?: 0)
        result = 31 * result + (dbiResourceId?.hashCode() ?: 0)
        result = 31 * result + (engineName?.hashCode() ?: 0)
        result = 31 * result + (masterUsername?.hashCode() ?: 0)
        result = 31 * result + (ncharCharacterSetName?.hashCode() ?: 0)
        result = 31 * result + (snapshotType?.hashCode() ?: 0)
        result = 31 * result + (tagList?.hashCode() ?: 0)
        result = 31 * result + (tenantDatabaseCreateTime?.hashCode() ?: 0)
        result = 31 * result + (tenantDatabaseResourceId?.hashCode() ?: 0)
        result = 31 * result + (tenantDbName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DbSnapshotTenantDatabase

        if (characterSetName != other.characterSetName) return false
        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (dbSnapshotIdentifier != other.dbSnapshotIdentifier) return false
        if (dbSnapshotTenantDatabaseArn != other.dbSnapshotTenantDatabaseArn) return false
        if (dbiResourceId != other.dbiResourceId) return false
        if (engineName != other.engineName) return false
        if (masterUsername != other.masterUsername) return false
        if (ncharCharacterSetName != other.ncharCharacterSetName) return false
        if (snapshotType != other.snapshotType) return false
        if (tagList != other.tagList) return false
        if (tenantDatabaseCreateTime != other.tenantDatabaseCreateTime) return false
        if (tenantDatabaseResourceId != other.tenantDatabaseResourceId) return false
        if (tenantDbName != other.tenantDbName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DbSnapshotTenantDatabase = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the character set of a tenant database.
         */
        public var characterSetName: kotlin.String? = null
        /**
         * The ID for the DB instance that contains the tenant databases.
         */
        public var dbInstanceIdentifier: kotlin.String? = null
        /**
         * The identifier for the snapshot of the DB instance.
         */
        public var dbSnapshotIdentifier: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the snapshot tenant database.
         */
        public var dbSnapshotTenantDatabaseArn: kotlin.String? = null
        /**
         * The resource identifier of the source CDB instance. This identifier can't be changed and is unique to an Amazon Web Services Region.
         */
        public var dbiResourceId: kotlin.String? = null
        /**
         * The name of the database engine.
         */
        public var engineName: kotlin.String? = null
        /**
         * The master username of the tenant database.
         */
        public var masterUsername: kotlin.String? = null
        /**
         * The `NCHAR` character set name of the tenant database.
         */
        public var ncharCharacterSetName: kotlin.String? = null
        /**
         * The type of DB snapshot.
         */
        public var snapshotType: kotlin.String? = null
        /**
         * A list of tags. For more information, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide.*
         */
        public var tagList: List<Tag>? = null
        /**
         * The time the DB snapshot was taken, specified in Coordinated Universal Time (UTC). If you copy the snapshot, the creation time changes.
         */
        public var tenantDatabaseCreateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The resource ID of the tenant database.
         */
        public var tenantDatabaseResourceId: kotlin.String? = null
        /**
         * The name of the tenant database.
         */
        public var tenantDbName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DbSnapshotTenantDatabase) : this() {
            this.characterSetName = x.characterSetName
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.dbSnapshotIdentifier = x.dbSnapshotIdentifier
            this.dbSnapshotTenantDatabaseArn = x.dbSnapshotTenantDatabaseArn
            this.dbiResourceId = x.dbiResourceId
            this.engineName = x.engineName
            this.masterUsername = x.masterUsername
            this.ncharCharacterSetName = x.ncharCharacterSetName
            this.snapshotType = x.snapshotType
            this.tagList = x.tagList
            this.tenantDatabaseCreateTime = x.tenantDatabaseCreateTime
            this.tenantDatabaseResourceId = x.tenantDatabaseResourceId
            this.tenantDbName = x.tenantDbName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DbSnapshotTenantDatabase = DbSnapshotTenantDatabase(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
