// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateDbInstanceReadReplicaRequest private constructor(builder: Builder) {
    /**
     * The amount of storage (in gibibytes) to allocate initially for the read replica. Follow the allocation rules specified in `CreateDBInstance`.
     *
     * Be sure to allocate enough storage for your read replica so that the create operation can succeed. You can also allocate additional storage for future growth.
     */
    public val allocatedStorage: kotlin.Int? = builder.allocatedStorage
    /**
     * Specifies whether to automatically apply minor engine upgrades to the read replica during the maintenance window.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     *
     * Default: Inherits the value from the source DB instance.
     */
    public val autoMinorVersionUpgrade: kotlin.Boolean? = builder.autoMinorVersionUpgrade
    /**
     * The Availability Zone (AZ) where the read replica will be created.
     *
     * Default: A random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region.
     *
     * Example: `us-east-1d`
     */
    public val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The CA certificate identifier to use for the read replica's server certificate.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     *
     * For more information, see [Using SSL/TLS to encrypt a connection to a DB instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html) in the *Amazon RDS User Guide* and [ Using SSL/TLS to encrypt a connection to a DB cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html) in the *Amazon Aurora User Guide*.
     */
    public val caCertificateIdentifier: kotlin.String? = builder.caCertificateIdentifier
    /**
     * Specifies whether to copy all tags from the read replica to snapshots of the read replica. By default, tags aren't copied.
     */
    public val copyTagsToSnapshot: kotlin.Boolean? = builder.copyTagsToSnapshot
    /**
     * The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance. The instance profile must meet the following requirements:
     * + The profile must exist in your account.
     * + The profile must have an IAM role that Amazon EC2 has permissions to assume.
     * + The instance profile name and the associated IAM role name must start with the prefix `AWSRDSCustom`.
     *
     * For the list of permissions required for the IAM role, see [ Configure IAM and your VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc) in the *Amazon RDS User Guide*.
     *
     * This setting is required for RDS Custom DB instances.
     */
    public val customIamInstanceProfile: kotlin.String? = builder.customIamInstanceProfile
    /**
     * The compute and memory capacity of the read replica, for example db.m4.large. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see [DB Instance Class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) in the *Amazon RDS User Guide*.
     *
     * Default: Inherits the value from the source DB instance.
     */
    public val dbInstanceClass: kotlin.String? = builder.dbInstanceClass
    /**
     * The DB instance identifier of the read replica. This identifier is the unique key that identifies a DB instance. This parameter is stored as a lowercase string.
     */
    public val dbInstanceIdentifier: kotlin.String? = builder.dbInstanceIdentifier
    /**
     * The name of the DB parameter group to associate with this DB instance.
     *
     * If you don't specify a value for `DBParameterGroupName`, then Amazon RDS uses the `DBParameterGroup` of the source DB instance for a same Region read replica, or the default `DBParameterGroup` for the specified DB engine for a cross-Region read replica.
     *
     * Specifying a parameter group for this operation is only supported for MySQL DB instances for cross-Region read replicas and for Oracle DB instances. It isn't supported for MySQL DB instances for same Region read replicas or for RDS Custom.
     *
     * Constraints:
     * + Must be 1 to 255 letters, numbers, or hyphens.
     * + First character must be a letter.
     * + Can't end with a hyphen or contain two consecutive hyphens.
     */
    public val dbParameterGroupName: kotlin.String? = builder.dbParameterGroupName
    /**
     * A DB subnet group for the DB instance. The new DB instance is created in the VPC associated with the DB subnet group. If no DB subnet group is specified, then the new DB instance isn't created in a VPC.
     *
     * Constraints:
     * + If supplied, must match the name of an existing DB subnet group.
     * + The specified DB subnet group must be in the same Amazon Web Services Region in which the operation is running.
     * + All read replicas in one Amazon Web Services Region that are created from the same source DB instance must either:
     *    + Specify DB subnet groups from the same VPC. All these read replicas are created in the same VPC.
     *    + Not specify a DB subnet group. All these read replicas are created outside of any VPC.
     *
     * Example: `mydbsubnetgroup`
     */
    public val dbSubnetGroupName: kotlin.String? = builder.dbSubnetGroupName
    /**
     * Indicates whether the DB instance has a dedicated log volume (DLV) enabled.
     */
    public val dedicatedLogVolume: kotlin.Boolean? = builder.dedicatedLogVolume
    /**
     * Specifies whether to enable deletion protection for the DB instance. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled. For more information, see [ Deleting a DB Instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html).
     */
    public val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * The Active Directory directory ID to create the DB instance in. Currently, only MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.
     *
     * For more information, see [ Kerberos Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html) in the *Amazon RDS User Guide*.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     */
    public val domain: kotlin.String? = builder.domain
    /**
     * The ARN for the Secrets Manager secret with the credentials for the user joining the domain.
     *
     * Example: `arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456`
     */
    public val domainAuthSecretArn: kotlin.String? = builder.domainAuthSecretArn
    /**
     * The IPv4 DNS IP addresses of your primary and secondary Active Directory domain controllers.
     *
     * Constraints:
     * + Two IP addresses must be provided. If there isn't a secondary domain controller, use the IP address of the primary domain controller for both entries in the list.
     *
     * Example: `123.124.125.126,234.235.236.237`
     */
    public val domainDnsIps: List<String>? = builder.domainDnsIps
    /**
     * The fully qualified domain name (FQDN) of an Active Directory domain.
     *
     * Constraints:
     * + Can't be longer than 64 characters.
     *
     * Example: `mymanagedADtest.mymanagedAD.mydomain`
     */
    public val domainFqdn: kotlin.String? = builder.domainFqdn
    /**
     * The name of the IAM role to use when making API calls to the Directory Service.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     */
    public val domainIamRoleName: kotlin.String? = builder.domainIamRoleName
    /**
     * The Active Directory organizational unit for your DB instance to join.
     *
     * Constraints:
     * + Must be in the distinguished name format.
     * + Can't be longer than 64 characters.
     *
     * Example: `OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain`
     */
    public val domainOu: kotlin.String? = builder.domainOu
    /**
     * The list of logs that the new DB instance is to export to CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see [Publishing Database Logs to Amazon CloudWatch Logs ](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch) in the *Amazon RDS User Guide*.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     */
    public val enableCloudwatchLogsExports: List<String>? = builder.enableCloudwatchLogsExports
    /**
     * Specifies whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts read replica.
     *
     * A *CoIP* provides local or external connectivity to resources in your Outpost subnets through your on-premises network. For some use cases, a CoIP can provide lower latency for connections to the read replica from outside of its virtual private cloud (VPC) on your local network.
     *
     * For more information about RDS on Outposts, see [Working with Amazon RDS on Amazon Web Services Outposts](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html) in the *Amazon RDS User Guide*.
     *
     * For more information about CoIPs, see [Customer-owned IP addresses](https://docs.aws.amazon.com/outposts/latest/userguide/routing.html#ip-addressing) in the *Amazon Web Services Outposts User Guide*.
     */
    public val enableCustomerOwnedIp: kotlin.Boolean? = builder.enableCustomerOwnedIp
    /**
     * Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn't enabled.
     *
     * For more information about IAM database authentication, see [ IAM Database Authentication for MySQL and PostgreSQL](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html) in the *Amazon RDS User Guide*.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     */
    public val enableIamDatabaseAuthentication: kotlin.Boolean? = builder.enableIamDatabaseAuthentication
    /**
     * Specifies whether to enable Performance Insights for the read replica.
     *
     * For more information, see [Using Amazon Performance Insights](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html) in the *Amazon RDS User Guide*.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     */
    public val enablePerformanceInsights: kotlin.Boolean? = builder.enablePerformanceInsights
    /**
     * The amount of Provisioned IOPS (input/output operations per second) to initially allocate for the DB instance.
     */
    public val iops: kotlin.Int? = builder.iops
    /**
     * The Amazon Web Services KMS key identifier for an encrypted read replica.
     *
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     *
     * If you create an encrypted read replica in the same Amazon Web Services Region as the source DB instance or Multi-AZ DB cluster, don't specify a value for this parameter. A read replica in the same Amazon Web Services Region is always encrypted with the same KMS key as the source DB instance or cluster.
     *
     * If you create an encrypted read replica in a different Amazon Web Services Region, then you must specify a KMS key identifier for the destination Amazon Web Services Region. KMS keys are specific to the Amazon Web Services Region that they are created in, and you can't use KMS keys from one Amazon Web Services Region in another Amazon Web Services Region.
     *
     * You can't create an encrypted read replica from an unencrypted DB instance or Multi-AZ DB cluster.
     *
     * This setting doesn't apply to RDS Custom, which uses the same KMS key as the primary replica.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.
     *
     * For more information about this setting, including limitations that apply to it, see [ Managing capacity automatically with Amazon RDS storage autoscaling](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling) in the *Amazon RDS User Guide*.
     */
    public val maxAllocatedStorage: kotlin.Int? = builder.maxAllocatedStorage
    /**
     * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the read replica. To disable collection of Enhanced Monitoring metrics, specify `0`. The default is `0`.
     *
     * If `MonitoringRoleArn` is specified, then you must set `MonitoringInterval` to a value other than `0`.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     *
     * Valid Values: `0, 1, 5, 10, 15, 30, 60`
     *
     * Default: `0`
     */
    public val monitoringInterval: kotlin.Int? = builder.monitoringInterval
    /**
     * The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, `arn:aws:iam:123456789012:role/emaccess`. For information on creating a monitoring role, go to [To create an IAM role for Amazon RDS Enhanced Monitoring](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole) in the *Amazon RDS User Guide*.
     *
     * If `MonitoringInterval` is set to a value other than 0, then you must supply a `MonitoringRoleArn` value.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     */
    public val monitoringRoleArn: kotlin.String? = builder.monitoringRoleArn
    /**
     * Specifies whether the read replica is in a Multi-AZ deployment.
     *
     * You can create a read replica as a Multi-AZ DB instance. RDS creates a standby of your replica in another Availability Zone for failover support for the replica. Creating your read replica as a Multi-AZ DB instance is independent of whether the source is a Multi-AZ DB instance or a Multi-AZ DB cluster.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     */
    public val multiAz: kotlin.Boolean? = builder.multiAz
    /**
     * The network type of the DB instance.
     *
     * Valid Values:
     * + `IPV4`
     * + `DUAL`
     *
     * The network type is determined by the `DBSubnetGroup` specified for read replica. A `DBSubnetGroup` can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (`DUAL`).
     *
     * For more information, see [ Working with a DB instance in a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html) in the *Amazon RDS User Guide.*
     */
    public val networkType: kotlin.String? = builder.networkType
    /**
     * The option group to associate the DB instance with. If not specified, RDS uses the option group associated with the source DB instance or cluster.
     *
     * For SQL Server, you must use the option group associated with the source.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     */
    public val optionGroupName: kotlin.String? = builder.optionGroupName
    /**
     * The Amazon Web Services KMS key identifier for encryption of Performance Insights data.
     *
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     *
     * If you do not specify a value for `PerformanceInsightsKMSKeyId`, then Amazon RDS uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     */
    public val performanceInsightsKmsKeyId: kotlin.String? = builder.performanceInsightsKmsKeyId
    /**
     * The number of days to retain Performance Insights data.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     *
     * Valid Values:
     * + `7`
     * + *month* * 31, where *month* is a number of months from 1-23. Examples: `93` (3 months * 31), `341` (11 months * 31), `589` (19 months * 31)
     * + `731`
     *
     * Default: `7` days
     *
     * If you specify a retention period that isn't valid, such as `94`, Amazon RDS returns an error.
     */
    public val performanceInsightsRetentionPeriod: kotlin.Int? = builder.performanceInsightsRetentionPeriod
    /**
     * The port number that the DB instance uses for connections.
     *
     * Valid Values: `1150-65535`
     *
     * Default: Inherits the value from the source DB instance.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * When you are creating a read replica from one Amazon Web Services GovCloud (US) Region to another or from one China Amazon Web Services Region to another, the URL that contains a Signature Version 4 signed request for the `CreateDBInstanceReadReplica` API operation in the source Amazon Web Services Region that contains the source DB instance.
     *
     * This setting applies only to Amazon Web Services GovCloud (US) Regions and China Amazon Web Services Regions. It's ignored in other Amazon Web Services Regions.
     *
     * This setting applies only when replicating from a source DB *instance*. Source DB clusters aren't supported in Amazon Web Services GovCloud (US) Regions and China Amazon Web Services Regions.
     *
     * You must specify this parameter when you create an encrypted read replica from another Amazon Web Services Region by using the Amazon RDS API. Don't specify `PreSignedUrl` when you are creating an encrypted read replica in the same Amazon Web Services Region.
     *
     * The presigned URL must be a valid request for the `CreateDBInstanceReadReplica` API operation that can run in the source Amazon Web Services Region that contains the encrypted source DB instance. The presigned URL request must contain the following parameter values:
     * + `DestinationRegion` - The Amazon Web Services Region that the encrypted read replica is created in. This Amazon Web Services Region is the same one where the `CreateDBInstanceReadReplica` operation is called that contains this presigned URL.For example, if you create an encrypted DB instance in the us-west-1 Amazon Web Services Region, from a source DB instance in the us-east-2 Amazon Web Services Region, then you call the `CreateDBInstanceReadReplica` operation in the us-east-1 Amazon Web Services Region and provide a presigned URL that contains a call to the `CreateDBInstanceReadReplica` operation in the us-west-2 Amazon Web Services Region. For this example, the `DestinationRegion` in the presigned URL must be set to the us-east-1 Amazon Web Services Region.
     * + `KmsKeyId` - The KMS key identifier for the key to use to encrypt the read replica in the destination Amazon Web Services Region. This is the same identifier for both the `CreateDBInstanceReadReplica` operation that is called in the destination Amazon Web Services Region, and the operation contained in the presigned URL.
     * + `SourceDBInstanceIdentifier` - The DB instance identifier for the encrypted DB instance to be replicated. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you are creating an encrypted read replica from a DB instance in the us-west-2 Amazon Web Services Region, then your `SourceDBInstanceIdentifier` looks like the following example: `arn:aws:rds:us-west-2:123456789012:instance:mysql-instance1-20161115`.
     *
     * To learn how to generate a Signature Version 4 signed request, see [Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)](https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html) and [Signature Version 4 Signing Process](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
     *
     * If you are using an Amazon Web Services SDK tool or the CLI, you can specify `SourceRegion` (or `--source-region` for the CLI) instead of specifying `PreSignedUrl` manually. Specifying `SourceRegion` autogenerates a presigned URL that is a valid request for the operation that can run in the source Amazon Web Services Region.
     *
     * `SourceRegion` isn't supported for SQL Server, because Amazon RDS for SQL Server doesn't support cross-Region read replicas.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     */
    public val preSignedUrl: kotlin.String? = builder.preSignedUrl
    /**
     * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     */
    public val processorFeatures: List<ProcessorFeature>? = builder.processorFeatures
    /**
     * Specifies whether the DB instance is publicly accessible.
     *
     * When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.
     *
     * When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.
     *
     * For more information, see CreateDBInstance.
     */
    public val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible
    /**
     * The open mode of the replica database: mounted or read-only.
     *
     * This parameter is only supported for Oracle DB instances.
     *
     * Mounted DB replicas are included in Oracle Database Enterprise Edition. The main use case for mounted replicas is cross-Region disaster recovery. The primary database doesn't use Active Data Guard to transmit information to the mounted replica. Because it doesn't accept user connections, a mounted replica can't serve a read-only workload.
     *
     * You can create a combination of mounted and read-only DB replicas for the same primary DB instance. For more information, see [Working with Oracle Read Replicas for Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html) in the *Amazon RDS User Guide*.
     *
     * For RDS Custom, you must specify this parameter and set it to `mounted`. The value won't be set by default. After replica creation, you can manage the open mode manually.
     */
    public val replicaMode: aws.sdk.kotlin.services.rds.model.ReplicaMode? = builder.replicaMode
    /**
     * The identifier of the Multi-AZ DB cluster that will act as the source for the read replica. Each DB cluster can have up to 15 read replicas.
     *
     * Constraints:
     * + Must be the identifier of an existing Multi-AZ DB cluster.
     * + Can't be specified if the `SourceDBInstanceIdentifier` parameter is also specified.
     * + The specified DB cluster must have automatic backups enabled, that is, its backup retention period must be greater than 0.
     * + The source DB cluster must be in the same Amazon Web Services Region as the read replica. Cross-Region replication isn't supported.
     */
    public val sourceDbClusterIdentifier: kotlin.String? = builder.sourceDbClusterIdentifier
    /**
     * The identifier of the DB instance that will act as the source for the read replica. Each DB instance can have up to 15 read replicas, with the exception of Oracle and SQL Server, which can have up to five.
     *
     * Constraints:
     * + Must be the identifier of an existing Db2, MariaDB, MySQL, Oracle, PostgreSQL, or SQL Server DB instance.
     * + Can't be specified if the `SourceDBClusterIdentifier` parameter is also specified.
     * + For the limitations of Oracle read replicas, see [Version and licensing considerations for RDS for Oracle replicas](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.limitations.html#oracle-read-replicas.limitations.versions-and-licenses) in the *Amazon RDS User Guide*.
     * + For the limitations of SQL Server read replicas, see [Read replica limitations with SQL Server](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/SQLServer.ReadReplicas.html#SQLServer.ReadReplicas.Limitations) in the *Amazon RDS User Guide*.
     * + The specified DB instance must have automatic backups enabled, that is, its backup retention period must be greater than 0.
     * + If the source DB instance is in the same Amazon Web Services Region as the read replica, specify a valid DB instance identifier.
     * + If the source DB instance is in a different Amazon Web Services Region from the read replica, specify a valid DB instance ARN. For more information, see [Constructing an ARN for Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing) in the *Amazon RDS User Guide*. This doesn't apply to SQL Server or RDS Custom, which don't support cross-Region replicas.
     */
    public val sourceDbInstanceIdentifier: kotlin.String? = builder.sourceDbInstanceIdentifier
    /**
     * Specifies the storage throughput value for the read replica.
     *
     * This setting doesn't apply to RDS Custom or Amazon Aurora DB instances.
     */
    public val storageThroughput: kotlin.Int? = builder.storageThroughput
    /**
     * The storage type to associate with the read replica.
     *
     * If you specify `io1`, `io2`, or `gp3`, you must also include a value for the `Iops` parameter.
     *
     * Valid Values: `gp2 | gp3 | io1 | io2 | standard`
     *
     * Default: `io1` if the `Iops` parameter is specified. Otherwise, `gp2`.
     */
    public val storageType: kotlin.String? = builder.storageType
    /**
     * A list of tags. For more information, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide.*
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Whether to upgrade the storage file system configuration on the read replica. This option migrates the read replica from the old storage file system layout to the preferred layout.
     */
    public val upgradeStorageConfig: kotlin.Boolean? = builder.upgradeStorageConfig
    /**
     * Specifies whether the DB instance class of the DB instance uses its default processor features.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     */
    public val useDefaultProcessorFeatures: kotlin.Boolean? = builder.useDefaultProcessorFeatures
    /**
     * A list of Amazon EC2 VPC security groups to associate with the read replica.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     *
     * Default: The default EC2 VPC security group for the DB subnet group's VPC.
     */
    public val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.CreateDbInstanceReadReplicaRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDbInstanceReadReplicaRequest(")
        append("allocatedStorage=$allocatedStorage,")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("availabilityZone=$availabilityZone,")
        append("caCertificateIdentifier=$caCertificateIdentifier,")
        append("copyTagsToSnapshot=$copyTagsToSnapshot,")
        append("customIamInstanceProfile=$customIamInstanceProfile,")
        append("dbInstanceClass=$dbInstanceClass,")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("dbParameterGroupName=$dbParameterGroupName,")
        append("dbSubnetGroupName=$dbSubnetGroupName,")
        append("dedicatedLogVolume=$dedicatedLogVolume,")
        append("deletionProtection=$deletionProtection,")
        append("domain=$domain,")
        append("domainAuthSecretArn=$domainAuthSecretArn,")
        append("domainDnsIps=$domainDnsIps,")
        append("domainFqdn=$domainFqdn,")
        append("domainIamRoleName=$domainIamRoleName,")
        append("domainOu=$domainOu,")
        append("enableCloudwatchLogsExports=$enableCloudwatchLogsExports,")
        append("enableCustomerOwnedIp=$enableCustomerOwnedIp,")
        append("enableIamDatabaseAuthentication=$enableIamDatabaseAuthentication,")
        append("enablePerformanceInsights=$enablePerformanceInsights,")
        append("iops=$iops,")
        append("kmsKeyId=$kmsKeyId,")
        append("maxAllocatedStorage=$maxAllocatedStorage,")
        append("monitoringInterval=$monitoringInterval,")
        append("monitoringRoleArn=$monitoringRoleArn,")
        append("multiAz=$multiAz,")
        append("networkType=$networkType,")
        append("optionGroupName=$optionGroupName,")
        append("performanceInsightsKmsKeyId=$performanceInsightsKmsKeyId,")
        append("performanceInsightsRetentionPeriod=$performanceInsightsRetentionPeriod,")
        append("port=$port,")
        append("preSignedUrl=$preSignedUrl,")
        append("processorFeatures=$processorFeatures,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("replicaMode=$replicaMode,")
        append("sourceDbClusterIdentifier=$sourceDbClusterIdentifier,")
        append("sourceDbInstanceIdentifier=$sourceDbInstanceIdentifier,")
        append("storageThroughput=$storageThroughput,")
        append("storageType=$storageType,")
        append("tags=$tags,")
        append("upgradeStorageConfig=$upgradeStorageConfig,")
        append("useDefaultProcessorFeatures=$useDefaultProcessorFeatures,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocatedStorage ?: 0
        result = 31 * result + (autoMinorVersionUpgrade?.hashCode() ?: 0)
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (caCertificateIdentifier?.hashCode() ?: 0)
        result = 31 * result + (copyTagsToSnapshot?.hashCode() ?: 0)
        result = 31 * result + (customIamInstanceProfile?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceClass?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (dbSubnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (dedicatedLogVolume?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (domainAuthSecretArn?.hashCode() ?: 0)
        result = 31 * result + (domainDnsIps?.hashCode() ?: 0)
        result = 31 * result + (domainFqdn?.hashCode() ?: 0)
        result = 31 * result + (domainIamRoleName?.hashCode() ?: 0)
        result = 31 * result + (domainOu?.hashCode() ?: 0)
        result = 31 * result + (enableCloudwatchLogsExports?.hashCode() ?: 0)
        result = 31 * result + (enableCustomerOwnedIp?.hashCode() ?: 0)
        result = 31 * result + (enableIamDatabaseAuthentication?.hashCode() ?: 0)
        result = 31 * result + (enablePerformanceInsights?.hashCode() ?: 0)
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (maxAllocatedStorage ?: 0)
        result = 31 * result + (monitoringInterval ?: 0)
        result = 31 * result + (monitoringRoleArn?.hashCode() ?: 0)
        result = 31 * result + (multiAz?.hashCode() ?: 0)
        result = 31 * result + (networkType?.hashCode() ?: 0)
        result = 31 * result + (optionGroupName?.hashCode() ?: 0)
        result = 31 * result + (performanceInsightsKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (performanceInsightsRetentionPeriod ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (preSignedUrl?.hashCode() ?: 0)
        result = 31 * result + (processorFeatures?.hashCode() ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (replicaMode?.hashCode() ?: 0)
        result = 31 * result + (sourceDbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (sourceDbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (storageThroughput ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (upgradeStorageConfig?.hashCode() ?: 0)
        result = 31 * result + (useDefaultProcessorFeatures?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDbInstanceReadReplicaRequest

        if (allocatedStorage != other.allocatedStorage) return false
        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (availabilityZone != other.availabilityZone) return false
        if (caCertificateIdentifier != other.caCertificateIdentifier) return false
        if (copyTagsToSnapshot != other.copyTagsToSnapshot) return false
        if (customIamInstanceProfile != other.customIamInstanceProfile) return false
        if (dbInstanceClass != other.dbInstanceClass) return false
        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (dbParameterGroupName != other.dbParameterGroupName) return false
        if (dbSubnetGroupName != other.dbSubnetGroupName) return false
        if (dedicatedLogVolume != other.dedicatedLogVolume) return false
        if (deletionProtection != other.deletionProtection) return false
        if (domain != other.domain) return false
        if (domainAuthSecretArn != other.domainAuthSecretArn) return false
        if (domainDnsIps != other.domainDnsIps) return false
        if (domainFqdn != other.domainFqdn) return false
        if (domainIamRoleName != other.domainIamRoleName) return false
        if (domainOu != other.domainOu) return false
        if (enableCloudwatchLogsExports != other.enableCloudwatchLogsExports) return false
        if (enableCustomerOwnedIp != other.enableCustomerOwnedIp) return false
        if (enableIamDatabaseAuthentication != other.enableIamDatabaseAuthentication) return false
        if (enablePerformanceInsights != other.enablePerformanceInsights) return false
        if (iops != other.iops) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (maxAllocatedStorage != other.maxAllocatedStorage) return false
        if (monitoringInterval != other.monitoringInterval) return false
        if (monitoringRoleArn != other.monitoringRoleArn) return false
        if (multiAz != other.multiAz) return false
        if (networkType != other.networkType) return false
        if (optionGroupName != other.optionGroupName) return false
        if (performanceInsightsKmsKeyId != other.performanceInsightsKmsKeyId) return false
        if (performanceInsightsRetentionPeriod != other.performanceInsightsRetentionPeriod) return false
        if (port != other.port) return false
        if (preSignedUrl != other.preSignedUrl) return false
        if (processorFeatures != other.processorFeatures) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (replicaMode != other.replicaMode) return false
        if (sourceDbClusterIdentifier != other.sourceDbClusterIdentifier) return false
        if (sourceDbInstanceIdentifier != other.sourceDbInstanceIdentifier) return false
        if (storageThroughput != other.storageThroughput) return false
        if (storageType != other.storageType) return false
        if (tags != other.tags) return false
        if (upgradeStorageConfig != other.upgradeStorageConfig) return false
        if (useDefaultProcessorFeatures != other.useDefaultProcessorFeatures) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.CreateDbInstanceReadReplicaRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The amount of storage (in gibibytes) to allocate initially for the read replica. Follow the allocation rules specified in `CreateDBInstance`.
         *
         * Be sure to allocate enough storage for your read replica so that the create operation can succeed. You can also allocate additional storage for future growth.
         */
        public var allocatedStorage: kotlin.Int? = null
        /**
         * Specifies whether to automatically apply minor engine upgrades to the read replica during the maintenance window.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         *
         * Default: Inherits the value from the source DB instance.
         */
        public var autoMinorVersionUpgrade: kotlin.Boolean? = null
        /**
         * The Availability Zone (AZ) where the read replica will be created.
         *
         * Default: A random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region.
         *
         * Example: `us-east-1d`
         */
        public var availabilityZone: kotlin.String? = null
        /**
         * The CA certificate identifier to use for the read replica's server certificate.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         *
         * For more information, see [Using SSL/TLS to encrypt a connection to a DB instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html) in the *Amazon RDS User Guide* and [ Using SSL/TLS to encrypt a connection to a DB cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html) in the *Amazon Aurora User Guide*.
         */
        public var caCertificateIdentifier: kotlin.String? = null
        /**
         * Specifies whether to copy all tags from the read replica to snapshots of the read replica. By default, tags aren't copied.
         */
        public var copyTagsToSnapshot: kotlin.Boolean? = null
        /**
         * The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance. The instance profile must meet the following requirements:
         * + The profile must exist in your account.
         * + The profile must have an IAM role that Amazon EC2 has permissions to assume.
         * + The instance profile name and the associated IAM role name must start with the prefix `AWSRDSCustom`.
         *
         * For the list of permissions required for the IAM role, see [ Configure IAM and your VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc) in the *Amazon RDS User Guide*.
         *
         * This setting is required for RDS Custom DB instances.
         */
        public var customIamInstanceProfile: kotlin.String? = null
        /**
         * The compute and memory capacity of the read replica, for example db.m4.large. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see [DB Instance Class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) in the *Amazon RDS User Guide*.
         *
         * Default: Inherits the value from the source DB instance.
         */
        public var dbInstanceClass: kotlin.String? = null
        /**
         * The DB instance identifier of the read replica. This identifier is the unique key that identifies a DB instance. This parameter is stored as a lowercase string.
         */
        public var dbInstanceIdentifier: kotlin.String? = null
        /**
         * The name of the DB parameter group to associate with this DB instance.
         *
         * If you don't specify a value for `DBParameterGroupName`, then Amazon RDS uses the `DBParameterGroup` of the source DB instance for a same Region read replica, or the default `DBParameterGroup` for the specified DB engine for a cross-Region read replica.
         *
         * Specifying a parameter group for this operation is only supported for MySQL DB instances for cross-Region read replicas and for Oracle DB instances. It isn't supported for MySQL DB instances for same Region read replicas or for RDS Custom.
         *
         * Constraints:
         * + Must be 1 to 255 letters, numbers, or hyphens.
         * + First character must be a letter.
         * + Can't end with a hyphen or contain two consecutive hyphens.
         */
        public var dbParameterGroupName: kotlin.String? = null
        /**
         * A DB subnet group for the DB instance. The new DB instance is created in the VPC associated with the DB subnet group. If no DB subnet group is specified, then the new DB instance isn't created in a VPC.
         *
         * Constraints:
         * + If supplied, must match the name of an existing DB subnet group.
         * + The specified DB subnet group must be in the same Amazon Web Services Region in which the operation is running.
         * + All read replicas in one Amazon Web Services Region that are created from the same source DB instance must either:
         *    + Specify DB subnet groups from the same VPC. All these read replicas are created in the same VPC.
         *    + Not specify a DB subnet group. All these read replicas are created outside of any VPC.
         *
         * Example: `mydbsubnetgroup`
         */
        public var dbSubnetGroupName: kotlin.String? = null
        /**
         * Indicates whether the DB instance has a dedicated log volume (DLV) enabled.
         */
        public var dedicatedLogVolume: kotlin.Boolean? = null
        /**
         * Specifies whether to enable deletion protection for the DB instance. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled. For more information, see [ Deleting a DB Instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html).
         */
        public var deletionProtection: kotlin.Boolean? = null
        /**
         * The Active Directory directory ID to create the DB instance in. Currently, only MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.
         *
         * For more information, see [ Kerberos Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html) in the *Amazon RDS User Guide*.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         */
        public var domain: kotlin.String? = null
        /**
         * The ARN for the Secrets Manager secret with the credentials for the user joining the domain.
         *
         * Example: `arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456`
         */
        public var domainAuthSecretArn: kotlin.String? = null
        /**
         * The IPv4 DNS IP addresses of your primary and secondary Active Directory domain controllers.
         *
         * Constraints:
         * + Two IP addresses must be provided. If there isn't a secondary domain controller, use the IP address of the primary domain controller for both entries in the list.
         *
         * Example: `123.124.125.126,234.235.236.237`
         */
        public var domainDnsIps: List<String>? = null
        /**
         * The fully qualified domain name (FQDN) of an Active Directory domain.
         *
         * Constraints:
         * + Can't be longer than 64 characters.
         *
         * Example: `mymanagedADtest.mymanagedAD.mydomain`
         */
        public var domainFqdn: kotlin.String? = null
        /**
         * The name of the IAM role to use when making API calls to the Directory Service.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         */
        public var domainIamRoleName: kotlin.String? = null
        /**
         * The Active Directory organizational unit for your DB instance to join.
         *
         * Constraints:
         * + Must be in the distinguished name format.
         * + Can't be longer than 64 characters.
         *
         * Example: `OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain`
         */
        public var domainOu: kotlin.String? = null
        /**
         * The list of logs that the new DB instance is to export to CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see [Publishing Database Logs to Amazon CloudWatch Logs ](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch) in the *Amazon RDS User Guide*.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         */
        public var enableCloudwatchLogsExports: List<String>? = null
        /**
         * Specifies whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts read replica.
         *
         * A *CoIP* provides local or external connectivity to resources in your Outpost subnets through your on-premises network. For some use cases, a CoIP can provide lower latency for connections to the read replica from outside of its virtual private cloud (VPC) on your local network.
         *
         * For more information about RDS on Outposts, see [Working with Amazon RDS on Amazon Web Services Outposts](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html) in the *Amazon RDS User Guide*.
         *
         * For more information about CoIPs, see [Customer-owned IP addresses](https://docs.aws.amazon.com/outposts/latest/userguide/routing.html#ip-addressing) in the *Amazon Web Services Outposts User Guide*.
         */
        public var enableCustomerOwnedIp: kotlin.Boolean? = null
        /**
         * Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn't enabled.
         *
         * For more information about IAM database authentication, see [ IAM Database Authentication for MySQL and PostgreSQL](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html) in the *Amazon RDS User Guide*.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         */
        public var enableIamDatabaseAuthentication: kotlin.Boolean? = null
        /**
         * Specifies whether to enable Performance Insights for the read replica.
         *
         * For more information, see [Using Amazon Performance Insights](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html) in the *Amazon RDS User Guide*.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         */
        public var enablePerformanceInsights: kotlin.Boolean? = null
        /**
         * The amount of Provisioned IOPS (input/output operations per second) to initially allocate for the DB instance.
         */
        public var iops: kotlin.Int? = null
        /**
         * The Amazon Web Services KMS key identifier for an encrypted read replica.
         *
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         *
         * If you create an encrypted read replica in the same Amazon Web Services Region as the source DB instance or Multi-AZ DB cluster, don't specify a value for this parameter. A read replica in the same Amazon Web Services Region is always encrypted with the same KMS key as the source DB instance or cluster.
         *
         * If you create an encrypted read replica in a different Amazon Web Services Region, then you must specify a KMS key identifier for the destination Amazon Web Services Region. KMS keys are specific to the Amazon Web Services Region that they are created in, and you can't use KMS keys from one Amazon Web Services Region in another Amazon Web Services Region.
         *
         * You can't create an encrypted read replica from an unencrypted DB instance or Multi-AZ DB cluster.
         *
         * This setting doesn't apply to RDS Custom, which uses the same KMS key as the primary replica.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.
         *
         * For more information about this setting, including limitations that apply to it, see [ Managing capacity automatically with Amazon RDS storage autoscaling](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling) in the *Amazon RDS User Guide*.
         */
        public var maxAllocatedStorage: kotlin.Int? = null
        /**
         * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the read replica. To disable collection of Enhanced Monitoring metrics, specify `0`. The default is `0`.
         *
         * If `MonitoringRoleArn` is specified, then you must set `MonitoringInterval` to a value other than `0`.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         *
         * Valid Values: `0, 1, 5, 10, 15, 30, 60`
         *
         * Default: `0`
         */
        public var monitoringInterval: kotlin.Int? = null
        /**
         * The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, `arn:aws:iam:123456789012:role/emaccess`. For information on creating a monitoring role, go to [To create an IAM role for Amazon RDS Enhanced Monitoring](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole) in the *Amazon RDS User Guide*.
         *
         * If `MonitoringInterval` is set to a value other than 0, then you must supply a `MonitoringRoleArn` value.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         */
        public var monitoringRoleArn: kotlin.String? = null
        /**
         * Specifies whether the read replica is in a Multi-AZ deployment.
         *
         * You can create a read replica as a Multi-AZ DB instance. RDS creates a standby of your replica in another Availability Zone for failover support for the replica. Creating your read replica as a Multi-AZ DB instance is independent of whether the source is a Multi-AZ DB instance or a Multi-AZ DB cluster.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         */
        public var multiAz: kotlin.Boolean? = null
        /**
         * The network type of the DB instance.
         *
         * Valid Values:
         * + `IPV4`
         * + `DUAL`
         *
         * The network type is determined by the `DBSubnetGroup` specified for read replica. A `DBSubnetGroup` can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (`DUAL`).
         *
         * For more information, see [ Working with a DB instance in a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html) in the *Amazon RDS User Guide.*
         */
        public var networkType: kotlin.String? = null
        /**
         * The option group to associate the DB instance with. If not specified, RDS uses the option group associated with the source DB instance or cluster.
         *
         * For SQL Server, you must use the option group associated with the source.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         */
        public var optionGroupName: kotlin.String? = null
        /**
         * The Amazon Web Services KMS key identifier for encryption of Performance Insights data.
         *
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         *
         * If you do not specify a value for `PerformanceInsightsKMSKeyId`, then Amazon RDS uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         */
        public var performanceInsightsKmsKeyId: kotlin.String? = null
        /**
         * The number of days to retain Performance Insights data.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         *
         * Valid Values:
         * + `7`
         * + *month* * 31, where *month* is a number of months from 1-23. Examples: `93` (3 months * 31), `341` (11 months * 31), `589` (19 months * 31)
         * + `731`
         *
         * Default: `7` days
         *
         * If you specify a retention period that isn't valid, such as `94`, Amazon RDS returns an error.
         */
        public var performanceInsightsRetentionPeriod: kotlin.Int? = null
        /**
         * The port number that the DB instance uses for connections.
         *
         * Valid Values: `1150-65535`
         *
         * Default: Inherits the value from the source DB instance.
         */
        public var port: kotlin.Int? = null
        /**
         * When you are creating a read replica from one Amazon Web Services GovCloud (US) Region to another or from one China Amazon Web Services Region to another, the URL that contains a Signature Version 4 signed request for the `CreateDBInstanceReadReplica` API operation in the source Amazon Web Services Region that contains the source DB instance.
         *
         * This setting applies only to Amazon Web Services GovCloud (US) Regions and China Amazon Web Services Regions. It's ignored in other Amazon Web Services Regions.
         *
         * This setting applies only when replicating from a source DB *instance*. Source DB clusters aren't supported in Amazon Web Services GovCloud (US) Regions and China Amazon Web Services Regions.
         *
         * You must specify this parameter when you create an encrypted read replica from another Amazon Web Services Region by using the Amazon RDS API. Don't specify `PreSignedUrl` when you are creating an encrypted read replica in the same Amazon Web Services Region.
         *
         * The presigned URL must be a valid request for the `CreateDBInstanceReadReplica` API operation that can run in the source Amazon Web Services Region that contains the encrypted source DB instance. The presigned URL request must contain the following parameter values:
         * + `DestinationRegion` - The Amazon Web Services Region that the encrypted read replica is created in. This Amazon Web Services Region is the same one where the `CreateDBInstanceReadReplica` operation is called that contains this presigned URL.For example, if you create an encrypted DB instance in the us-west-1 Amazon Web Services Region, from a source DB instance in the us-east-2 Amazon Web Services Region, then you call the `CreateDBInstanceReadReplica` operation in the us-east-1 Amazon Web Services Region and provide a presigned URL that contains a call to the `CreateDBInstanceReadReplica` operation in the us-west-2 Amazon Web Services Region. For this example, the `DestinationRegion` in the presigned URL must be set to the us-east-1 Amazon Web Services Region.
         * + `KmsKeyId` - The KMS key identifier for the key to use to encrypt the read replica in the destination Amazon Web Services Region. This is the same identifier for both the `CreateDBInstanceReadReplica` operation that is called in the destination Amazon Web Services Region, and the operation contained in the presigned URL.
         * + `SourceDBInstanceIdentifier` - The DB instance identifier for the encrypted DB instance to be replicated. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you are creating an encrypted read replica from a DB instance in the us-west-2 Amazon Web Services Region, then your `SourceDBInstanceIdentifier` looks like the following example: `arn:aws:rds:us-west-2:123456789012:instance:mysql-instance1-20161115`.
         *
         * To learn how to generate a Signature Version 4 signed request, see [Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)](https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html) and [Signature Version 4 Signing Process](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
         *
         * If you are using an Amazon Web Services SDK tool or the CLI, you can specify `SourceRegion` (or `--source-region` for the CLI) instead of specifying `PreSignedUrl` manually. Specifying `SourceRegion` autogenerates a presigned URL that is a valid request for the operation that can run in the source Amazon Web Services Region.
         *
         * `SourceRegion` isn't supported for SQL Server, because Amazon RDS for SQL Server doesn't support cross-Region read replicas.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         */
        public var preSignedUrl: kotlin.String? = null
        /**
         * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         */
        public var processorFeatures: List<ProcessorFeature>? = null
        /**
         * Specifies whether the DB instance is publicly accessible.
         *
         * When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.
         *
         * When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.
         *
         * For more information, see CreateDBInstance.
         */
        public var publiclyAccessible: kotlin.Boolean? = null
        /**
         * The open mode of the replica database: mounted or read-only.
         *
         * This parameter is only supported for Oracle DB instances.
         *
         * Mounted DB replicas are included in Oracle Database Enterprise Edition. The main use case for mounted replicas is cross-Region disaster recovery. The primary database doesn't use Active Data Guard to transmit information to the mounted replica. Because it doesn't accept user connections, a mounted replica can't serve a read-only workload.
         *
         * You can create a combination of mounted and read-only DB replicas for the same primary DB instance. For more information, see [Working with Oracle Read Replicas for Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html) in the *Amazon RDS User Guide*.
         *
         * For RDS Custom, you must specify this parameter and set it to `mounted`. The value won't be set by default. After replica creation, you can manage the open mode manually.
         */
        public var replicaMode: aws.sdk.kotlin.services.rds.model.ReplicaMode? = null
        /**
         * The identifier of the Multi-AZ DB cluster that will act as the source for the read replica. Each DB cluster can have up to 15 read replicas.
         *
         * Constraints:
         * + Must be the identifier of an existing Multi-AZ DB cluster.
         * + Can't be specified if the `SourceDBInstanceIdentifier` parameter is also specified.
         * + The specified DB cluster must have automatic backups enabled, that is, its backup retention period must be greater than 0.
         * + The source DB cluster must be in the same Amazon Web Services Region as the read replica. Cross-Region replication isn't supported.
         */
        public var sourceDbClusterIdentifier: kotlin.String? = null
        /**
         * The identifier of the DB instance that will act as the source for the read replica. Each DB instance can have up to 15 read replicas, with the exception of Oracle and SQL Server, which can have up to five.
         *
         * Constraints:
         * + Must be the identifier of an existing Db2, MariaDB, MySQL, Oracle, PostgreSQL, or SQL Server DB instance.
         * + Can't be specified if the `SourceDBClusterIdentifier` parameter is also specified.
         * + For the limitations of Oracle read replicas, see [Version and licensing considerations for RDS for Oracle replicas](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.limitations.html#oracle-read-replicas.limitations.versions-and-licenses) in the *Amazon RDS User Guide*.
         * + For the limitations of SQL Server read replicas, see [Read replica limitations with SQL Server](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/SQLServer.ReadReplicas.html#SQLServer.ReadReplicas.Limitations) in the *Amazon RDS User Guide*.
         * + The specified DB instance must have automatic backups enabled, that is, its backup retention period must be greater than 0.
         * + If the source DB instance is in the same Amazon Web Services Region as the read replica, specify a valid DB instance identifier.
         * + If the source DB instance is in a different Amazon Web Services Region from the read replica, specify a valid DB instance ARN. For more information, see [Constructing an ARN for Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing) in the *Amazon RDS User Guide*. This doesn't apply to SQL Server or RDS Custom, which don't support cross-Region replicas.
         */
        public var sourceDbInstanceIdentifier: kotlin.String? = null
        /**
         * Specifies the storage throughput value for the read replica.
         *
         * This setting doesn't apply to RDS Custom or Amazon Aurora DB instances.
         */
        public var storageThroughput: kotlin.Int? = null
        /**
         * The storage type to associate with the read replica.
         *
         * If you specify `io1`, `io2`, or `gp3`, you must also include a value for the `Iops` parameter.
         *
         * Valid Values: `gp2 | gp3 | io1 | io2 | standard`
         *
         * Default: `io1` if the `Iops` parameter is specified. Otherwise, `gp2`.
         */
        public var storageType: kotlin.String? = null
        /**
         * A list of tags. For more information, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide.*
         */
        public var tags: List<Tag>? = null
        /**
         * Whether to upgrade the storage file system configuration on the read replica. This option migrates the read replica from the old storage file system layout to the preferred layout.
         */
        public var upgradeStorageConfig: kotlin.Boolean? = null
        /**
         * Specifies whether the DB instance class of the DB instance uses its default processor features.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         */
        public var useDefaultProcessorFeatures: kotlin.Boolean? = null
        /**
         * A list of Amazon EC2 VPC security groups to associate with the read replica.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         *
         * Default: The default EC2 VPC security group for the DB subnet group's VPC.
         */
        public var vpcSecurityGroupIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.CreateDbInstanceReadReplicaRequest) : this() {
            this.allocatedStorage = x.allocatedStorage
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.availabilityZone = x.availabilityZone
            this.caCertificateIdentifier = x.caCertificateIdentifier
            this.copyTagsToSnapshot = x.copyTagsToSnapshot
            this.customIamInstanceProfile = x.customIamInstanceProfile
            this.dbInstanceClass = x.dbInstanceClass
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.dbParameterGroupName = x.dbParameterGroupName
            this.dbSubnetGroupName = x.dbSubnetGroupName
            this.dedicatedLogVolume = x.dedicatedLogVolume
            this.deletionProtection = x.deletionProtection
            this.domain = x.domain
            this.domainAuthSecretArn = x.domainAuthSecretArn
            this.domainDnsIps = x.domainDnsIps
            this.domainFqdn = x.domainFqdn
            this.domainIamRoleName = x.domainIamRoleName
            this.domainOu = x.domainOu
            this.enableCloudwatchLogsExports = x.enableCloudwatchLogsExports
            this.enableCustomerOwnedIp = x.enableCustomerOwnedIp
            this.enableIamDatabaseAuthentication = x.enableIamDatabaseAuthentication
            this.enablePerformanceInsights = x.enablePerformanceInsights
            this.iops = x.iops
            this.kmsKeyId = x.kmsKeyId
            this.maxAllocatedStorage = x.maxAllocatedStorage
            this.monitoringInterval = x.monitoringInterval
            this.monitoringRoleArn = x.monitoringRoleArn
            this.multiAz = x.multiAz
            this.networkType = x.networkType
            this.optionGroupName = x.optionGroupName
            this.performanceInsightsKmsKeyId = x.performanceInsightsKmsKeyId
            this.performanceInsightsRetentionPeriod = x.performanceInsightsRetentionPeriod
            this.port = x.port
            this.preSignedUrl = x.preSignedUrl
            this.processorFeatures = x.processorFeatures
            this.publiclyAccessible = x.publiclyAccessible
            this.replicaMode = x.replicaMode
            this.sourceDbClusterIdentifier = x.sourceDbClusterIdentifier
            this.sourceDbInstanceIdentifier = x.sourceDbInstanceIdentifier
            this.storageThroughput = x.storageThroughput
            this.storageType = x.storageType
            this.tags = x.tags
            this.upgradeStorageConfig = x.upgradeStorageConfig
            this.useDefaultProcessorFeatures = x.useDefaultProcessorFeatures
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.CreateDbInstanceReadReplicaRequest = CreateDbInstanceReadReplicaRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
