// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateCustomDbEngineVersionRequest private constructor(builder: Builder) {
    /**
     * The name of an Amazon S3 bucket that contains database installation files for your CEV. For example, a valid bucket name is `my-custom-installation-files`.
     */
    public val databaseInstallationFilesS3BucketName: kotlin.String? = builder.databaseInstallationFilesS3BucketName
    /**
     * The Amazon S3 directory that contains the database installation files for your CEV. For example, a valid bucket name is `123456789012/cev1`. If this setting isn't specified, no prefix is assumed.
     */
    public val databaseInstallationFilesS3Prefix: kotlin.String? = builder.databaseInstallationFilesS3Prefix
    /**
     * An optional description of your CEV.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The database engine. RDS Custom for Oracle supports the following values:
     * + `custom-oracle-ee`
     * + `custom-oracle-ee-cdb`
     * + `custom-oracle-se2`
     * + `custom-oracle-se2-cdb`
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The name of your CEV. The name format is 19.*customized_string*. For example, a valid CEV name is `19.my_cev1`. This setting is required for RDS Custom for Oracle, but optional for Amazon RDS. The combination of `Engine` and `EngineVersion` is unique per customer per Region.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The ID of the Amazon Machine Image (AMI). For RDS Custom for SQL Server, an AMI ID is required to create a CEV. For RDS Custom for Oracle, the default is the most recent AMI available, but you can specify an AMI ID that was used in a different Oracle CEV. Find the AMIs used by your CEVs by calling the [DescribeDBEngineVersions](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBEngineVersions.html) operation.
     */
    public val imageId: kotlin.String? = builder.imageId
    /**
     * The Amazon Web Services KMS key identifier for an encrypted CEV. A symmetric encryption KMS key is required for RDS Custom, but optional for Amazon RDS.
     *
     * If you have an existing symmetric encryption KMS key in your account, you can use it with RDS Custom. No further action is necessary. If you don't already have a symmetric encryption KMS key in your account, follow the instructions in [ Creating a symmetric encryption KMS key](https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html#create-symmetric-cmk) in the *Amazon Web Services Key Management Service Developer Guide*.
     *
     * You can choose the same symmetric encryption key when you create a CEV and a DB instance, or choose different keys.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The CEV manifest, which is a JSON document that describes the installation .zip files stored in Amazon S3. Specify the name/value pairs in a file or a quoted string. RDS Custom applies the patches in the order in which they are listed.
     *
     * The following JSON fields are valid:
     *
     * ## MediaImportTemplateVersion
     * Version of the CEV manifest. The date is in the format `YYYY-MM-DD`.
     *
     * ## databaseInstallationFileNames
     * Ordered list of installation files for the CEV.
     *
     * ## opatchFileNames
     * Ordered list of OPatch installers used for the Oracle DB engine.
     *
     * ## psuRuPatchFileNames
     * The PSU and RU patches for this CEV.
     *
     * ## OtherPatchFileNames
     * The patches that are not in the list of PSU and RU patches. Amazon RDS applies these patches after applying the PSU and RU patches.
     *
     * For more information, see [ Creating the CEV manifest](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.preparing.manifest) in the *Amazon RDS User Guide*.
     */
    public val manifest: kotlin.String? = builder.manifest
    /**
     * The ARN of a CEV to use as a source for creating a new CEV. You can specify a different Amazon Machine Imagine (AMI) by using either `Source` or `UseAwsProvidedLatestImage`. You can't specify a different JSON manifest when you specify `SourceCustomDbEngineVersionIdentifier`.
     */
    public val sourceCustomDbEngineVersionIdentifier: kotlin.String? = builder.sourceCustomDbEngineVersionIdentifier
    /**
     * A list of tags. For more information, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide.*
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Specifies whether to use the latest service-provided Amazon Machine Image (AMI) for the CEV. If you specify `UseAwsProvidedLatestImage`, you can't also specify `ImageId`.
     */
    public val useAwsProvidedLatestImage: kotlin.Boolean? = builder.useAwsProvidedLatestImage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.CreateCustomDbEngineVersionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateCustomDbEngineVersionRequest(")
        append("databaseInstallationFilesS3BucketName=$databaseInstallationFilesS3BucketName,")
        append("databaseInstallationFilesS3Prefix=$databaseInstallationFilesS3Prefix,")
        append("description=$description,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("imageId=$imageId,")
        append("kmsKeyId=$kmsKeyId,")
        append("manifest=$manifest,")
        append("sourceCustomDbEngineVersionIdentifier=$sourceCustomDbEngineVersionIdentifier,")
        append("tags=$tags,")
        append("useAwsProvidedLatestImage=$useAwsProvidedLatestImage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = databaseInstallationFilesS3BucketName?.hashCode() ?: 0
        result = 31 * result + (databaseInstallationFilesS3Prefix?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (imageId?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (manifest?.hashCode() ?: 0)
        result = 31 * result + (sourceCustomDbEngineVersionIdentifier?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (useAwsProvidedLatestImage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateCustomDbEngineVersionRequest

        if (databaseInstallationFilesS3BucketName != other.databaseInstallationFilesS3BucketName) return false
        if (databaseInstallationFilesS3Prefix != other.databaseInstallationFilesS3Prefix) return false
        if (description != other.description) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (imageId != other.imageId) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (manifest != other.manifest) return false
        if (sourceCustomDbEngineVersionIdentifier != other.sourceCustomDbEngineVersionIdentifier) return false
        if (tags != other.tags) return false
        if (useAwsProvidedLatestImage != other.useAwsProvidedLatestImage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.CreateCustomDbEngineVersionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of an Amazon S3 bucket that contains database installation files for your CEV. For example, a valid bucket name is `my-custom-installation-files`.
         */
        public var databaseInstallationFilesS3BucketName: kotlin.String? = null
        /**
         * The Amazon S3 directory that contains the database installation files for your CEV. For example, a valid bucket name is `123456789012/cev1`. If this setting isn't specified, no prefix is assumed.
         */
        public var databaseInstallationFilesS3Prefix: kotlin.String? = null
        /**
         * An optional description of your CEV.
         */
        public var description: kotlin.String? = null
        /**
         * The database engine. RDS Custom for Oracle supports the following values:
         * + `custom-oracle-ee`
         * + `custom-oracle-ee-cdb`
         * + `custom-oracle-se2`
         * + `custom-oracle-se2-cdb`
         */
        public var engine: kotlin.String? = null
        /**
         * The name of your CEV. The name format is 19.*customized_string*. For example, a valid CEV name is `19.my_cev1`. This setting is required for RDS Custom for Oracle, but optional for Amazon RDS. The combination of `Engine` and `EngineVersion` is unique per customer per Region.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The ID of the Amazon Machine Image (AMI). For RDS Custom for SQL Server, an AMI ID is required to create a CEV. For RDS Custom for Oracle, the default is the most recent AMI available, but you can specify an AMI ID that was used in a different Oracle CEV. Find the AMIs used by your CEVs by calling the [DescribeDBEngineVersions](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBEngineVersions.html) operation.
         */
        public var imageId: kotlin.String? = null
        /**
         * The Amazon Web Services KMS key identifier for an encrypted CEV. A symmetric encryption KMS key is required for RDS Custom, but optional for Amazon RDS.
         *
         * If you have an existing symmetric encryption KMS key in your account, you can use it with RDS Custom. No further action is necessary. If you don't already have a symmetric encryption KMS key in your account, follow the instructions in [ Creating a symmetric encryption KMS key](https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html#create-symmetric-cmk) in the *Amazon Web Services Key Management Service Developer Guide*.
         *
         * You can choose the same symmetric encryption key when you create a CEV and a DB instance, or choose different keys.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The CEV manifest, which is a JSON document that describes the installation .zip files stored in Amazon S3. Specify the name/value pairs in a file or a quoted string. RDS Custom applies the patches in the order in which they are listed.
         *
         * The following JSON fields are valid:
         *
         * ## MediaImportTemplateVersion
         * Version of the CEV manifest. The date is in the format `YYYY-MM-DD`.
         *
         * ## databaseInstallationFileNames
         * Ordered list of installation files for the CEV.
         *
         * ## opatchFileNames
         * Ordered list of OPatch installers used for the Oracle DB engine.
         *
         * ## psuRuPatchFileNames
         * The PSU and RU patches for this CEV.
         *
         * ## OtherPatchFileNames
         * The patches that are not in the list of PSU and RU patches. Amazon RDS applies these patches after applying the PSU and RU patches.
         *
         * For more information, see [ Creating the CEV manifest](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.preparing.manifest) in the *Amazon RDS User Guide*.
         */
        public var manifest: kotlin.String? = null
        /**
         * The ARN of a CEV to use as a source for creating a new CEV. You can specify a different Amazon Machine Imagine (AMI) by using either `Source` or `UseAwsProvidedLatestImage`. You can't specify a different JSON manifest when you specify `SourceCustomDbEngineVersionIdentifier`.
         */
        public var sourceCustomDbEngineVersionIdentifier: kotlin.String? = null
        /**
         * A list of tags. For more information, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide.*
         */
        public var tags: List<Tag>? = null
        /**
         * Specifies whether to use the latest service-provided Amazon Machine Image (AMI) for the CEV. If you specify `UseAwsProvidedLatestImage`, you can't also specify `ImageId`.
         */
        public var useAwsProvidedLatestImage: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.CreateCustomDbEngineVersionRequest) : this() {
            this.databaseInstallationFilesS3BucketName = x.databaseInstallationFilesS3BucketName
            this.databaseInstallationFilesS3Prefix = x.databaseInstallationFilesS3Prefix
            this.description = x.description
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.imageId = x.imageId
            this.kmsKeyId = x.kmsKeyId
            this.manifest = x.manifest
            this.sourceCustomDbEngineVersionIdentifier = x.sourceCustomDbEngineVersionIdentifier
            this.tags = x.tags
            this.useAwsProvidedLatestImage = x.useAwsProvidedLatestImage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.CreateCustomDbEngineVersionRequest = CreateCustomDbEngineVersionRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
