// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 *
 */
public class CopyOptionGroupRequest private constructor(builder: Builder) {
    /**
     * The identifier for the source option group.
     *
     * Constraints:
     * + Must specify a valid option group.
     */
    public val sourceOptionGroupIdentifier: kotlin.String? = builder.sourceOptionGroupIdentifier
    /**
     * A list of tags. For more information, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide.*
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The description for the copied option group.
     */
    public val targetOptionGroupDescription: kotlin.String? = builder.targetOptionGroupDescription
    /**
     * The identifier for the copied option group.
     *
     * Constraints:
     * + Can't be null, empty, or blank
     * + Must contain from 1 to 255 letters, numbers, or hyphens
     * + First character must be a letter
     * + Can't end with a hyphen or contain two consecutive hyphens
     *
     * Example: `my-option-group`
     */
    public val targetOptionGroupIdentifier: kotlin.String? = builder.targetOptionGroupIdentifier

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.CopyOptionGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CopyOptionGroupRequest(")
        append("sourceOptionGroupIdentifier=$sourceOptionGroupIdentifier,")
        append("tags=$tags,")
        append("targetOptionGroupDescription=$targetOptionGroupDescription,")
        append("targetOptionGroupIdentifier=$targetOptionGroupIdentifier")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = sourceOptionGroupIdentifier?.hashCode() ?: 0
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetOptionGroupDescription?.hashCode() ?: 0)
        result = 31 * result + (targetOptionGroupIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CopyOptionGroupRequest

        if (sourceOptionGroupIdentifier != other.sourceOptionGroupIdentifier) return false
        if (tags != other.tags) return false
        if (targetOptionGroupDescription != other.targetOptionGroupDescription) return false
        if (targetOptionGroupIdentifier != other.targetOptionGroupIdentifier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.CopyOptionGroupRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier for the source option group.
         *
         * Constraints:
         * + Must specify a valid option group.
         */
        public var sourceOptionGroupIdentifier: kotlin.String? = null
        /**
         * A list of tags. For more information, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide.*
         */
        public var tags: List<Tag>? = null
        /**
         * The description for the copied option group.
         */
        public var targetOptionGroupDescription: kotlin.String? = null
        /**
         * The identifier for the copied option group.
         *
         * Constraints:
         * + Can't be null, empty, or blank
         * + Must contain from 1 to 255 letters, numbers, or hyphens
         * + First character must be a letter
         * + Can't end with a hyphen or contain two consecutive hyphens
         *
         * Example: `my-option-group`
         */
        public var targetOptionGroupIdentifier: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.CopyOptionGroupRequest) : this() {
            this.sourceOptionGroupIdentifier = x.sourceOptionGroupIdentifier
            this.tags = x.tags
            this.targetOptionGroupDescription = x.targetOptionGroupDescription
            this.targetOptionGroupIdentifier = x.targetOptionGroupIdentifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.CopyOptionGroupRequest = CopyOptionGroupRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
