// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Returns the details of the DB instance’s server certificate.
 *
 * For more information, see [Using SSL/TLS to encrypt a connection to a DB instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html) in the *Amazon RDS User Guide* and [ Using SSL/TLS to encrypt a connection to a DB cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html) in the *Amazon Aurora User Guide*.
 */
public class CertificateDetails private constructor(builder: Builder) {
    /**
     * The CA identifier of the CA certificate used for the DB instance's server certificate.
     */
    public val caIdentifier: kotlin.String? = builder.caIdentifier
    /**
     * The expiration date of the DB instance’s server certificate.
     */
    public val validTill: aws.smithy.kotlin.runtime.time.Instant? = builder.validTill

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.CertificateDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CertificateDetails(")
        append("caIdentifier=$caIdentifier,")
        append("validTill=$validTill")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = caIdentifier?.hashCode() ?: 0
        result = 31 * result + (validTill?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CertificateDetails

        if (caIdentifier != other.caIdentifier) return false
        if (validTill != other.validTill) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.CertificateDetails = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The CA identifier of the CA certificate used for the DB instance's server certificate.
         */
        public var caIdentifier: kotlin.String? = null
        /**
         * The expiration date of the DB instance’s server certificate.
         */
        public var validTill: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.CertificateDetails) : this() {
            this.caIdentifier = x.caIdentifier
            this.validTill = x.validTill
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.CertificateDetails = CertificateDetails(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
