// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * This data type is used as a response element in the `DescribeDBClusterBacktracks` action.
 */
public class BacktrackDbClusterResponse private constructor(builder: Builder) {
    /**
     * Contains the backtrack identifier.
     */
    public val backtrackIdentifier: kotlin.String? = builder.backtrackIdentifier
    /**
     * The timestamp of the time at which the backtrack was requested.
     */
    public val backtrackRequestCreationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.backtrackRequestCreationTime
    /**
     * The timestamp of the time to which the DB cluster was backtracked.
     */
    public val backtrackTo: aws.smithy.kotlin.runtime.time.Instant? = builder.backtrackTo
    /**
     * The timestamp of the time from which the DB cluster was backtracked.
     */
    public val backtrackedFrom: aws.smithy.kotlin.runtime.time.Instant? = builder.backtrackedFrom
    /**
     * Contains a user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster.
     */
    public val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * The status of the backtrack. This property returns one of the following values:
     * + `applying` - The backtrack is currently being applied to or rolled back from the DB cluster.
     * + `completed` - The backtrack has successfully been applied to or rolled back from the DB cluster.
     * + `failed` - An error occurred while the backtrack was applied to or rolled back from the DB cluster.
     * + `pending` - The backtrack is currently pending application to or rollback from the DB cluster.
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.BacktrackDbClusterResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BacktrackDbClusterResponse(")
        append("backtrackIdentifier=$backtrackIdentifier,")
        append("backtrackRequestCreationTime=$backtrackRequestCreationTime,")
        append("backtrackTo=$backtrackTo,")
        append("backtrackedFrom=$backtrackedFrom,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = backtrackIdentifier?.hashCode() ?: 0
        result = 31 * result + (backtrackRequestCreationTime?.hashCode() ?: 0)
        result = 31 * result + (backtrackTo?.hashCode() ?: 0)
        result = 31 * result + (backtrackedFrom?.hashCode() ?: 0)
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BacktrackDbClusterResponse

        if (backtrackIdentifier != other.backtrackIdentifier) return false
        if (backtrackRequestCreationTime != other.backtrackRequestCreationTime) return false
        if (backtrackTo != other.backtrackTo) return false
        if (backtrackedFrom != other.backtrackedFrom) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.BacktrackDbClusterResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Contains the backtrack identifier.
         */
        public var backtrackIdentifier: kotlin.String? = null
        /**
         * The timestamp of the time at which the backtrack was requested.
         */
        public var backtrackRequestCreationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The timestamp of the time to which the DB cluster was backtracked.
         */
        public var backtrackTo: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The timestamp of the time from which the DB cluster was backtracked.
         */
        public var backtrackedFrom: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Contains a user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster.
         */
        public var dbClusterIdentifier: kotlin.String? = null
        /**
         * The status of the backtrack. This property returns one of the following values:
         * + `applying` - The backtrack is currently being applied to or rolled back from the DB cluster.
         * + `completed` - The backtrack has successfully been applied to or rolled back from the DB cluster.
         * + `failed` - An error occurred while the backtrack was applied to or rolled back from the DB cluster.
         * + `pending` - The backtrack is currently pending application to or rollback from the DB cluster.
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.BacktrackDbClusterResponse) : this() {
            this.backtrackIdentifier = x.backtrackIdentifier
            this.backtrackRequestCreationTime = x.backtrackRequestCreationTime
            this.backtrackTo = x.backtrackTo
            this.backtrackedFrom = x.backtrackedFrom
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.BacktrackDbClusterResponse = BacktrackDbClusterResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
