// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds

import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.rds.auth.RdsAuthSchemeProviderAdapter
import aws.sdk.kotlin.services.rds.auth.RdsIdentityProviderConfigAdapter
import aws.sdk.kotlin.services.rds.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.rds.model.*
import aws.sdk.kotlin.services.rds.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.awsprotocol.AwsAttributes
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.collections.putIfAbsent
import aws.smithy.kotlin.runtime.collections.putIfAbsentNotNull
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.middleware.MutateHeaders
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext

internal class DefaultRdsClient(override val config: RdsClient.Config) : RdsClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = RdsIdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "rds")
        }
        toMap()
    }
    private val authSchemeAdapter = RdsAuthSchemeProviderAdapter(config)
    private val telemetryScope = "aws.sdk.kotlin.services.rds"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * Associates an Identity and Access Management (IAM) role with a DB cluster.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.AddRoleToDBCluster.sample
     */
    override suspend fun addRoleToDbCluster(input: AddRoleToDbClusterRequest): AddRoleToDbClusterResponse {
        val op = SdkHttpOperation.build<AddRoleToDbClusterRequest, AddRoleToDbClusterResponse> {
            serializeWith = AddRoleToDBClusterOperationSerializer()
            deserializeWith = AddRoleToDBClusterOperationDeserializer()
            operationName = "AddRoleToDBCluster"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates an Amazon Web Services Identity and Access Management (IAM) role with a DB instance.
     *
     * To add a role to a DB instance, the status of the DB instance must be `available`.
     *
     * This command doesn't apply to RDS Custom.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.AddRoleToDBInstance.sample
     */
    override suspend fun addRoleToDbInstance(input: AddRoleToDbInstanceRequest): AddRoleToDbInstanceResponse {
        val op = SdkHttpOperation.build<AddRoleToDbInstanceRequest, AddRoleToDbInstanceResponse> {
            serializeWith = AddRoleToDBInstanceOperationSerializer()
            deserializeWith = AddRoleToDBInstanceOperationDeserializer()
            operationName = "AddRoleToDBInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds a source identifier to an existing RDS event notification subscription.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.AddSourceIdentifierToSubscription.sample
     */
    override suspend fun addSourceIdentifierToSubscription(input: AddSourceIdentifierToSubscriptionRequest): AddSourceIdentifierToSubscriptionResponse {
        val op = SdkHttpOperation.build<AddSourceIdentifierToSubscriptionRequest, AddSourceIdentifierToSubscriptionResponse> {
            serializeWith = AddSourceIdentifierToSubscriptionOperationSerializer()
            deserializeWith = AddSourceIdentifierToSubscriptionOperationDeserializer()
            operationName = "AddSourceIdentifierToSubscription"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds metadata tags to an Amazon RDS resource. These tags can also be used with cost allocation reporting to track cost associated with Amazon RDS resources, or used in a Condition statement in an IAM policy for Amazon RDS.
     *
     * For an overview on tagging Amazon RDS resources, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Tagging.html).
     *
     * @sample aws.sdk.kotlin.services.rds.samples.AddTagsToResource.sample
     */
    override suspend fun addTagsToResource(input: AddTagsToResourceRequest): AddTagsToResourceResponse {
        val op = SdkHttpOperation.build<AddTagsToResourceRequest, AddTagsToResourceResponse> {
            serializeWith = AddTagsToResourceOperationSerializer()
            deserializeWith = AddTagsToResourceOperationDeserializer()
            operationName = "AddTagsToResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Applies a pending maintenance action to a resource (for example, to a DB instance).
     *
     * @sample aws.sdk.kotlin.services.rds.samples.ApplyPendingMaintenanceAction.sample
     */
    override suspend fun applyPendingMaintenanceAction(input: ApplyPendingMaintenanceActionRequest): ApplyPendingMaintenanceActionResponse {
        val op = SdkHttpOperation.build<ApplyPendingMaintenanceActionRequest, ApplyPendingMaintenanceActionResponse> {
            serializeWith = ApplyPendingMaintenanceActionOperationSerializer()
            deserializeWith = ApplyPendingMaintenanceActionOperationDeserializer()
            operationName = "ApplyPendingMaintenanceAction"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Enables ingress to a DBSecurityGroup using one of two forms of authorization. First, EC2 or VPC security groups can be added to the DBSecurityGroup if the application using the database is running on EC2 or VPC instances. Second, IP ranges are available if the application accessing your database is running on the internet. Required parameters for this API are one of CIDR range, EC2SecurityGroupId for VPC, or (EC2SecurityGroupOwnerId and either EC2SecurityGroupName or EC2SecurityGroupId for non-VPC).
     *
     * You can't authorize ingress from an EC2 security group in one Amazon Web Services Region to an Amazon RDS DB instance in another. You can't authorize ingress from a VPC security group in one VPC to an Amazon RDS DB instance in another.
     *
     * For an overview of CIDR ranges, go to the [Wikipedia Tutorial](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
     *
     * EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we recommend that you migrate as soon as possible. For more information, see [Migrate from EC2-Classic to a VPC](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html) in the *Amazon EC2 User Guide*, the blog [EC2-Classic Networking is Retiring – Here’s How to Prepare](http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/), and [Moving a DB instance not in a VPC into a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html) in the *Amazon RDS User Guide*.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.AuthorizeDBSecurityGroupIngress.sample
     */
    override suspend fun authorizeDbSecurityGroupIngress(input: AuthorizeDbSecurityGroupIngressRequest): AuthorizeDbSecurityGroupIngressResponse {
        val op = SdkHttpOperation.build<AuthorizeDbSecurityGroupIngressRequest, AuthorizeDbSecurityGroupIngressResponse> {
            serializeWith = AuthorizeDBSecurityGroupIngressOperationSerializer()
            deserializeWith = AuthorizeDBSecurityGroupIngressOperationDeserializer()
            operationName = "AuthorizeDBSecurityGroupIngress"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Backtracks a DB cluster to a specific time, without creating a new DB cluster.
     *
     * For more information on backtracking, see [ Backtracking an Aurora DB Cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Managing.Backtrack.html) in the *Amazon Aurora User Guide*.
     *
     * This action applies only to Aurora MySQL DB clusters.
     */
    override suspend fun backtrackDbCluster(input: BacktrackDbClusterRequest): BacktrackDbClusterResponse {
        val op = SdkHttpOperation.build<BacktrackDbClusterRequest, BacktrackDbClusterResponse> {
            serializeWith = BacktrackDBClusterOperationSerializer()
            deserializeWith = BacktrackDBClusterOperationDeserializer()
            operationName = "BacktrackDBCluster"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Cancels an export task in progress that is exporting a snapshot or cluster to Amazon S3. Any data that has already been written to the S3 bucket isn't removed.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.CancelExportTask.sample
     */
    override suspend fun cancelExportTask(input: CancelExportTaskRequest): CancelExportTaskResponse {
        val op = SdkHttpOperation.build<CancelExportTaskRequest, CancelExportTaskResponse> {
            serializeWith = CancelExportTaskOperationSerializer()
            deserializeWith = CancelExportTaskOperationDeserializer()
            operationName = "CancelExportTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Copies the specified DB cluster parameter group.
     *
     * You can't copy a default DB cluster parameter group. Instead, create a new custom DB cluster parameter group, which copies the default parameters and values for the specified DB cluster parameter group family.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.CopyDBClusterParameterGroup.sample
     */
    override suspend fun copyDbClusterParameterGroup(input: CopyDbClusterParameterGroupRequest): CopyDbClusterParameterGroupResponse {
        val op = SdkHttpOperation.build<CopyDbClusterParameterGroupRequest, CopyDbClusterParameterGroupResponse> {
            serializeWith = CopyDBClusterParameterGroupOperationSerializer()
            deserializeWith = CopyDBClusterParameterGroupOperationDeserializer()
            operationName = "CopyDBClusterParameterGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Copies a snapshot of a DB cluster.
     *
     * To copy a DB cluster snapshot from a shared manual DB cluster snapshot, `SourceDBClusterSnapshotIdentifier` must be the Amazon Resource Name (ARN) of the shared DB cluster snapshot.
     *
     * You can copy an encrypted DB cluster snapshot from another Amazon Web Services Region. In that case, the Amazon Web Services Region where you call the `CopyDBClusterSnapshot` operation is the destination Amazon Web Services Region for the encrypted DB cluster snapshot to be copied to. To copy an encrypted DB cluster snapshot from another Amazon Web Services Region, you must provide the following values:
     * + `KmsKeyId` - The Amazon Web Services Key Management System (Amazon Web Services KMS) key identifier for the key to use to encrypt the copy of the DB cluster snapshot in the destination Amazon Web Services Region.
     * + `TargetDBClusterSnapshotIdentifier` - The identifier for the new copy of the DB cluster snapshot in the destination Amazon Web Services Region.
     * + `SourceDBClusterSnapshotIdentifier` - The DB cluster snapshot identifier for the encrypted DB cluster snapshot to be copied. This identifier must be in the ARN format for the source Amazon Web Services Region and is the same value as the `SourceDBClusterSnapshotIdentifier` in the presigned URL.
     *
     * To cancel the copy operation once it is in progress, delete the target DB cluster snapshot identified by `TargetDBClusterSnapshotIdentifier` while that DB cluster snapshot is in "copying" status.
     *
     * For more information on copying encrypted Amazon Aurora DB cluster snapshots from one Amazon Web Services Region to another, see [ Copying a Snapshot](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CopySnapshot.html) in the *Amazon Aurora User Guide*.
     *
     * For more information on Amazon Aurora DB clusters, see [ What is Amazon Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html) in the *Amazon Aurora User Guide*.
     *
     * For more information on Multi-AZ DB clusters, see [ Multi-AZ DB cluster deployments](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html) in the *Amazon RDS User Guide*.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.CopyDBClusterSnapshot.sample
     */
    override suspend fun copyDbClusterSnapshot(input: CopyDbClusterSnapshotRequest): CopyDbClusterSnapshotResponse {
        val op = SdkHttpOperation.build<CopyDbClusterSnapshotRequest, CopyDbClusterSnapshotResponse> {
            serializeWith = CopyDBClusterSnapshotOperationSerializer()
            deserializeWith = CopyDBClusterSnapshotOperationDeserializer()
            operationName = "CopyDBClusterSnapshot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Copies the specified DB parameter group.
     *
     * You can't copy a default DB parameter group. Instead, create a new custom DB parameter group, which copies the default parameters and values for the specified DB parameter group family.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.CopyDBParameterGroup.sample
     */
    override suspend fun copyDbParameterGroup(input: CopyDbParameterGroupRequest): CopyDbParameterGroupResponse {
        val op = SdkHttpOperation.build<CopyDbParameterGroupRequest, CopyDbParameterGroupResponse> {
            serializeWith = CopyDBParameterGroupOperationSerializer()
            deserializeWith = CopyDBParameterGroupOperationDeserializer()
            operationName = "CopyDBParameterGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Copies the specified DB snapshot. The source DB snapshot must be in the `available` state.
     *
     * You can copy a snapshot from one Amazon Web Services Region to another. In that case, the Amazon Web Services Region where you call the `CopyDBSnapshot` operation is the destination Amazon Web Services Region for the DB snapshot copy.
     *
     * This command doesn't apply to RDS Custom.
     *
     * For more information about copying snapshots, see [Copying a DB Snapshot](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopySnapshot.html#USER_CopyDBSnapshot) in the *Amazon RDS User Guide*.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.CopyDBSnapshot.sample
     */
    override suspend fun copyDbSnapshot(input: CopyDbSnapshotRequest): CopyDbSnapshotResponse {
        val op = SdkHttpOperation.build<CopyDbSnapshotRequest, CopyDbSnapshotResponse> {
            serializeWith = CopyDBSnapshotOperationSerializer()
            deserializeWith = CopyDBSnapshotOperationDeserializer()
            operationName = "CopyDBSnapshot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Copies the specified option group.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.CopyOptionGroup.sample
     */
    override suspend fun copyOptionGroup(input: CopyOptionGroupRequest): CopyOptionGroupResponse {
        val op = SdkHttpOperation.build<CopyOptionGroupRequest, CopyOptionGroupResponse> {
            serializeWith = CopyOptionGroupOperationSerializer()
            deserializeWith = CopyOptionGroupOperationDeserializer()
            operationName = "CopyOptionGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a blue/green deployment.
     *
     * A blue/green deployment creates a staging environment that copies the production environment. In a blue/green deployment, the blue environment is the current production environment. The green environment is the staging environment. The staging environment stays in sync with the current production environment using logical replication.
     *
     * You can make changes to the databases in the green environment without affecting production workloads. For example, you can upgrade the major or minor DB engine version, change database parameters, or make schema changes in the staging environment. You can thoroughly test changes in the green environment. When ready, you can switch over the environments to promote the green environment to be the new production environment. The switchover typically takes under a minute.
     *
     * For more information, see [Using Amazon RDS Blue/Green Deployments for database updates](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html) in the *Amazon RDS User Guide* and [ Using Amazon RDS Blue/Green Deployments for database updates](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html) in the *Amazon Aurora User Guide*.
     */
    override suspend fun createBlueGreenDeployment(input: CreateBlueGreenDeploymentRequest): CreateBlueGreenDeploymentResponse {
        val op = SdkHttpOperation.build<CreateBlueGreenDeploymentRequest, CreateBlueGreenDeploymentResponse> {
            serializeWith = CreateBlueGreenDeploymentOperationSerializer()
            deserializeWith = CreateBlueGreenDeploymentOperationDeserializer()
            operationName = "CreateBlueGreenDeployment"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a custom DB engine version (CEV).
     */
    override suspend fun createCustomDbEngineVersion(input: CreateCustomDbEngineVersionRequest): CreateCustomDbEngineVersionResponse {
        val op = SdkHttpOperation.build<CreateCustomDbEngineVersionRequest, CreateCustomDbEngineVersionResponse> {
            serializeWith = CreateCustomDBEngineVersionOperationSerializer()
            deserializeWith = CreateCustomDBEngineVersionOperationDeserializer()
            operationName = "CreateCustomDBEngineVersion"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new Amazon Aurora DB cluster or Multi-AZ DB cluster.
     *
     * If you create an Aurora DB cluster, the request creates an empty cluster. You must explicitly create the writer instance for your DB cluster using the [CreateDBInstance](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html) operation. If you create a Multi-AZ DB cluster, the request creates a writer and two reader DB instances for you, each in a different Availability Zone.
     *
     * You can use the `ReplicationSourceIdentifier` parameter to create an Amazon Aurora DB cluster as a read replica of another DB cluster or Amazon RDS for MySQL or PostgreSQL DB instance. For more information about Amazon Aurora, see [What is Amazon Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html) in the *Amazon Aurora User Guide*.
     *
     * You can also use the `ReplicationSourceIdentifier` parameter to create a Multi-AZ DB cluster read replica with an RDS for MySQL or PostgreSQL DB instance as the source. For more information about Multi-AZ DB clusters, see [Multi-AZ DB cluster deployments](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html) in the *Amazon RDS User Guide*.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.CreateDBCluster.sample
     * @sample aws.sdk.kotlin.services.rds.samples.CreateDBCluster.sample2
     */
    override suspend fun createDbCluster(input: CreateDbClusterRequest): CreateDbClusterResponse {
        val op = SdkHttpOperation.build<CreateDbClusterRequest, CreateDbClusterResponse> {
            serializeWith = CreateDBClusterOperationSerializer()
            deserializeWith = CreateDBClusterOperationDeserializer()
            operationName = "CreateDBCluster"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new custom endpoint and associates it with an Amazon Aurora DB cluster.
     *
     * This action applies only to Aurora DB clusters.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.CreateDBClusterEndpoint.sample
     */
    override suspend fun createDbClusterEndpoint(input: CreateDbClusterEndpointRequest): CreateDbClusterEndpointResponse {
        val op = SdkHttpOperation.build<CreateDbClusterEndpointRequest, CreateDbClusterEndpointResponse> {
            serializeWith = CreateDBClusterEndpointOperationSerializer()
            deserializeWith = CreateDBClusterEndpointOperationDeserializer()
            operationName = "CreateDBClusterEndpoint"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new DB cluster parameter group.
     *
     * Parameters in a DB cluster parameter group apply to all of the instances in a DB cluster.
     *
     * A DB cluster parameter group is initially created with the default parameters for the database engine used by instances in the DB cluster. To provide custom values for any of the parameters, you must modify the group after creating it using `ModifyDBClusterParameterGroup`. Once you've created a DB cluster parameter group, you need to associate it with your DB cluster using `ModifyDBCluster`.
     *
     * When you associate a new DB cluster parameter group with a running Aurora DB cluster, reboot the DB instances in the DB cluster without failover for the new DB cluster parameter group and associated settings to take effect.
     *
     * When you associate a new DB cluster parameter group with a running Multi-AZ DB cluster, reboot the DB cluster without failover for the new DB cluster parameter group and associated settings to take effect.
     *
     * After you create a DB cluster parameter group, you should wait at least 5 minutes before creating your first DB cluster that uses that DB cluster parameter group as the default parameter group. This allows Amazon RDS to fully complete the create action before the DB cluster parameter group is used as the default for a new DB cluster. This is especially important for parameters that are critical when creating the default database for a DB cluster, such as the character set for the default database defined by the `character_set_database` parameter. You can use the *Parameter Groups* option of the [Amazon RDS console](https://console.aws.amazon.com/rds/) or the `DescribeDBClusterParameters` operation to verify that your DB cluster parameter group has been created or modified.
     *
     * For more information on Amazon Aurora, see [ What is Amazon Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html) in the *Amazon Aurora User Guide*.
     *
     * For more information on Multi-AZ DB clusters, see [ Multi-AZ DB cluster deployments](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html) in the *Amazon RDS User Guide*.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.CreateDBClusterParameterGroup.sample
     */
    override suspend fun createDbClusterParameterGroup(input: CreateDbClusterParameterGroupRequest): CreateDbClusterParameterGroupResponse {
        val op = SdkHttpOperation.build<CreateDbClusterParameterGroupRequest, CreateDbClusterParameterGroupResponse> {
            serializeWith = CreateDBClusterParameterGroupOperationSerializer()
            deserializeWith = CreateDBClusterParameterGroupOperationDeserializer()
            operationName = "CreateDBClusterParameterGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a snapshot of a DB cluster.
     *
     * For more information on Amazon Aurora, see [ What is Amazon Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html) in the *Amazon Aurora User Guide*.
     *
     * For more information on Multi-AZ DB clusters, see [ Multi-AZ DB cluster deployments](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html) in the *Amazon RDS User Guide*.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.CreateDBClusterSnapshot.sample
     */
    override suspend fun createDbClusterSnapshot(input: CreateDbClusterSnapshotRequest): CreateDbClusterSnapshotResponse {
        val op = SdkHttpOperation.build<CreateDbClusterSnapshotRequest, CreateDbClusterSnapshotResponse> {
            serializeWith = CreateDBClusterSnapshotOperationSerializer()
            deserializeWith = CreateDBClusterSnapshotOperationDeserializer()
            operationName = "CreateDBClusterSnapshot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new DB instance.
     *
     * The new DB instance can be an RDS DB instance, or it can be a DB instance in an Aurora DB cluster. For an Aurora DB cluster, you can call this operation multiple times to add more than one DB instance to the cluster.
     *
     * For more information about creating an RDS DB instance, see [ Creating an Amazon RDS DB instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CreateDBInstance.html) in the *Amazon RDS User Guide*.
     *
     * For more information about creating a DB instance in an Aurora DB cluster, see [ Creating an Amazon Aurora DB cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.CreateInstance.html) in the *Amazon Aurora User Guide*.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.CreateDBInstance.sample
     */
    override suspend fun createDbInstance(input: CreateDbInstanceRequest): CreateDbInstanceResponse {
        val op = SdkHttpOperation.build<CreateDbInstanceRequest, CreateDbInstanceResponse> {
            serializeWith = CreateDBInstanceOperationSerializer()
            deserializeWith = CreateDBInstanceOperationDeserializer()
            operationName = "CreateDBInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new DB instance that acts as a read replica for an existing source DB instance or Multi-AZ DB cluster. You can create a read replica for a DB instance running Db2, MariaDB, MySQL, Oracle, PostgreSQL, or SQL Server. You can create a read replica for a Multi-AZ DB cluster running MySQL or PostgreSQL. For more information, see [Working with read replicas](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ReadRepl.html) and [Migrating from a Multi-AZ DB cluster to a DB instance using a read replica](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html#multi-az-db-clusters-migrating-to-instance-with-read-replica) in the *Amazon RDS User Guide*.
     *
     * Amazon Aurora doesn't support this operation. To create a DB instance for an Aurora DB cluster, use the `CreateDBInstance` operation.
     *
     * All read replica DB instances are created with backups disabled. All other attributes (including DB security groups and DB parameter groups) are inherited from the source DB instance or cluster, except as specified.
     *
     * Your source DB instance or cluster must have backup retention enabled.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.CreateDBInstanceReadReplica.sample
     */
    override suspend fun createDbInstanceReadReplica(input: CreateDbInstanceReadReplicaRequest): CreateDbInstanceReadReplicaResponse {
        val op = SdkHttpOperation.build<CreateDbInstanceReadReplicaRequest, CreateDbInstanceReadReplicaResponse> {
            serializeWith = CreateDBInstanceReadReplicaOperationSerializer()
            deserializeWith = CreateDBInstanceReadReplicaOperationDeserializer()
            operationName = "CreateDBInstanceReadReplica"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new DB parameter group.
     *
     * A DB parameter group is initially created with the default parameters for the database engine used by the DB instance. To provide custom values for any of the parameters, you must modify the group after creating it using `ModifyDBParameterGroup`. Once you've created a DB parameter group, you need to associate it with your DB instance using `ModifyDBInstance`. When you associate a new DB parameter group with a running DB instance, you need to reboot the DB instance without failover for the new DB parameter group and associated settings to take effect.
     *
     * This command doesn't apply to RDS Custom.
     *
     * After you create a DB parameter group, you should wait at least 5 minutes before creating your first DB instance that uses that DB parameter group as the default parameter group. This allows Amazon RDS to fully complete the create action before the parameter group is used as the default for a new DB instance. This is especially important for parameters that are critical when creating the default database for a DB instance, such as the character set for the default database defined by the `character_set_database` parameter. You can use the *Parameter Groups* option of the [Amazon RDS console](https://console.aws.amazon.com/rds/) or the *DescribeDBParameters* command to verify that your DB parameter group has been created or modified.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.CreateDBParameterGroup.sample
     */
    override suspend fun createDbParameterGroup(input: CreateDbParameterGroupRequest): CreateDbParameterGroupResponse {
        val op = SdkHttpOperation.build<CreateDbParameterGroupRequest, CreateDbParameterGroupResponse> {
            serializeWith = CreateDBParameterGroupOperationSerializer()
            deserializeWith = CreateDBParameterGroupOperationDeserializer()
            operationName = "CreateDBParameterGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new DB proxy.
     */
    override suspend fun createDbProxy(input: CreateDbProxyRequest): CreateDbProxyResponse {
        val op = SdkHttpOperation.build<CreateDbProxyRequest, CreateDbProxyResponse> {
            serializeWith = CreateDBProxyOperationSerializer()
            deserializeWith = CreateDBProxyOperationDeserializer()
            operationName = "CreateDBProxy"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a `DBProxyEndpoint`. Only applies to proxies that are associated with Aurora DB clusters. You can use DB proxy endpoints to specify read/write or read-only access to the DB cluster. You can also use DB proxy endpoints to access a DB proxy through a different VPC than the proxy's default VPC.
     */
    override suspend fun createDbProxyEndpoint(input: CreateDbProxyEndpointRequest): CreateDbProxyEndpointResponse {
        val op = SdkHttpOperation.build<CreateDbProxyEndpointRequest, CreateDbProxyEndpointResponse> {
            serializeWith = CreateDBProxyEndpointOperationSerializer()
            deserializeWith = CreateDBProxyEndpointOperationDeserializer()
            operationName = "CreateDBProxyEndpoint"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new DB security group. DB security groups control access to a DB instance.
     *
     * A DB security group controls access to EC2-Classic DB instances that are not in a VPC.
     *
     * EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we recommend that you migrate as soon as possible. For more information, see [Migrate from EC2-Classic to a VPC](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html) in the *Amazon EC2 User Guide*, the blog [EC2-Classic Networking is Retiring – Here’s How to Prepare](http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/), and [Moving a DB instance not in a VPC into a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html) in the *Amazon RDS User Guide*.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.CreateDBSecurityGroup.sample
     */
    override suspend fun createDbSecurityGroup(input: CreateDbSecurityGroupRequest): CreateDbSecurityGroupResponse {
        val op = SdkHttpOperation.build<CreateDbSecurityGroupRequest, CreateDbSecurityGroupResponse> {
            serializeWith = CreateDBSecurityGroupOperationSerializer()
            deserializeWith = CreateDBSecurityGroupOperationDeserializer()
            operationName = "CreateDBSecurityGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new DB shard group for Aurora Limitless Database. You must enable Aurora Limitless Database to create a DB shard group.
     *
     * Valid for: Aurora DB clusters only
     */
    override suspend fun createDbShardGroup(input: CreateDbShardGroupRequest): CreateDbShardGroupResponse {
        val op = SdkHttpOperation.build<CreateDbShardGroupRequest, CreateDbShardGroupResponse> {
            serializeWith = CreateDBShardGroupOperationSerializer()
            deserializeWith = CreateDBShardGroupOperationDeserializer()
            operationName = "CreateDBShardGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a snapshot of a DB instance. The source DB instance must be in the `available` or `storage-optimization` state.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.CreateDBSnapshot.sample
     */
    override suspend fun createDbSnapshot(input: CreateDbSnapshotRequest): CreateDbSnapshotResponse {
        val op = SdkHttpOperation.build<CreateDbSnapshotRequest, CreateDbSnapshotResponse> {
            serializeWith = CreateDBSnapshotOperationSerializer()
            deserializeWith = CreateDBSnapshotOperationDeserializer()
            operationName = "CreateDBSnapshot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in the Amazon Web Services Region.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.CreateDBSubnetGroup.sample
     */
    override suspend fun createDbSubnetGroup(input: CreateDbSubnetGroupRequest): CreateDbSubnetGroupResponse {
        val op = SdkHttpOperation.build<CreateDbSubnetGroupRequest, CreateDbSubnetGroupResponse> {
            serializeWith = CreateDBSubnetGroupOperationSerializer()
            deserializeWith = CreateDBSubnetGroupOperationDeserializer()
            operationName = "CreateDBSubnetGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an RDS event notification subscription. This operation requires a topic Amazon Resource Name (ARN) created by either the RDS console, the SNS console, or the SNS API. To obtain an ARN with SNS, you must create a topic in Amazon SNS and subscribe to the topic. The ARN is displayed in the SNS console.
     *
     * You can specify the type of source (`SourceType`) that you want to be notified of and provide a list of RDS sources (`SourceIds`) that triggers the events. You can also provide a list of event categories (`EventCategories`) for events that you want to be notified of. For example, you can specify `SourceType` = `db-instance`, `SourceIds` = `mydbinstance1`, `mydbinstance2` and `EventCategories` = `Availability`, `Backup`.
     *
     * If you specify both the `SourceType` and `SourceIds`, such as `SourceType` = `db-instance` and `SourceIds` = `myDBInstance1`, you are notified of all the `db-instance` events for the specified source. If you specify a `SourceType` but do not specify `SourceIds`, you receive notice of the events for that source type for all your RDS sources. If you don't specify either the SourceType or the `SourceIds`, you are notified of events generated from all RDS sources belonging to your customer account.
     *
     * For more information about subscribing to an event for RDS DB engines, see [ Subscribing to Amazon RDS event notification](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Subscribing.html) in the *Amazon RDS User Guide*.
     *
     * For more information about subscribing to an event for Aurora DB engines, see [ Subscribing to Amazon RDS event notification](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Subscribing.html) in the *Amazon Aurora User Guide*.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.CreateEventSubscription.sample
     */
    override suspend fun createEventSubscription(input: CreateEventSubscriptionRequest): CreateEventSubscriptionResponse {
        val op = SdkHttpOperation.build<CreateEventSubscriptionRequest, CreateEventSubscriptionResponse> {
            serializeWith = CreateEventSubscriptionOperationSerializer()
            deserializeWith = CreateEventSubscriptionOperationDeserializer()
            operationName = "CreateEventSubscription"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Aurora global database spread across multiple Amazon Web Services Regions. The global database contains a single primary cluster with read-write capability, and a read-only secondary cluster that receives data from the primary cluster through high-speed replication performed by the Aurora storage subsystem.
     *
     * You can create a global database that is initially empty, and then create the primary and secondary DB clusters in the global database. Or you can specify an existing Aurora cluster during the create operation, and this cluster becomes the primary cluster of the global database.
     *
     * This operation applies only to Aurora DB clusters.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.CreateGlobalCluster.sample
     */
    override suspend fun createGlobalCluster(input: CreateGlobalClusterRequest): CreateGlobalClusterResponse {
        val op = SdkHttpOperation.build<CreateGlobalClusterRequest, CreateGlobalClusterResponse> {
            serializeWith = CreateGlobalClusterOperationSerializer()
            deserializeWith = CreateGlobalClusterOperationDeserializer()
            operationName = "CreateGlobalCluster"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a zero-ETL integration with Amazon Redshift.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.CreateIntegration.sample
     */
    override suspend fun createIntegration(input: CreateIntegrationRequest): CreateIntegrationResponse {
        val op = SdkHttpOperation.build<CreateIntegrationRequest, CreateIntegrationResponse> {
            serializeWith = CreateIntegrationOperationSerializer()
            deserializeWith = CreateIntegrationOperationDeserializer()
            operationName = "CreateIntegration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new option group. You can create up to 20 option groups.
     *
     * This command doesn't apply to RDS Custom.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.CreateOptionGroup.sample
     */
    override suspend fun createOptionGroup(input: CreateOptionGroupRequest): CreateOptionGroupResponse {
        val op = SdkHttpOperation.build<CreateOptionGroupRequest, CreateOptionGroupResponse> {
            serializeWith = CreateOptionGroupOperationSerializer()
            deserializeWith = CreateOptionGroupOperationDeserializer()
            operationName = "CreateOptionGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a tenant database in a DB instance that uses the multi-tenant configuration. Only RDS for Oracle container database (CDB) instances are supported.
     */
    override suspend fun createTenantDatabase(input: CreateTenantDatabaseRequest): CreateTenantDatabaseResponse {
        val op = SdkHttpOperation.build<CreateTenantDatabaseRequest, CreateTenantDatabaseResponse> {
            serializeWith = CreateTenantDatabaseOperationSerializer()
            deserializeWith = CreateTenantDatabaseOperationDeserializer()
            operationName = "CreateTenantDatabase"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a blue/green deployment.
     *
     * For more information, see [Using Amazon RDS Blue/Green Deployments for database updates](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html) in the *Amazon RDS User Guide* and [Using Amazon RDS Blue/Green Deployments for database updates](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html) in the *Amazon Aurora User Guide*.
     */
    override suspend fun deleteBlueGreenDeployment(input: DeleteBlueGreenDeploymentRequest): DeleteBlueGreenDeploymentResponse {
        val op = SdkHttpOperation.build<DeleteBlueGreenDeploymentRequest, DeleteBlueGreenDeploymentResponse> {
            serializeWith = DeleteBlueGreenDeploymentOperationSerializer()
            deserializeWith = DeleteBlueGreenDeploymentOperationDeserializer()
            operationName = "DeleteBlueGreenDeployment"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a custom engine version. To run this command, make sure you meet the following prerequisites:
     * + The CEV must not be the default for RDS Custom. If it is, change the default before running this command.
     * + The CEV must not be associated with an RDS Custom DB instance, RDS Custom instance snapshot, or automated backup of your RDS Custom instance.
     *
     * Typically, deletion takes a few minutes.
     *
     * The MediaImport service that imports files from Amazon S3 to create CEVs isn't integrated with Amazon Web Services CloudTrail. If you turn on data logging for Amazon RDS in CloudTrail, calls to the `DeleteCustomDbEngineVersion` event aren't logged. However, you might see calls from the API gateway that accesses your Amazon S3 bucket. These calls originate from the MediaImport service for the `DeleteCustomDbEngineVersion` event.
     *
     * For more information, see [Deleting a CEV](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.delete) in the *Amazon RDS User Guide*.
     */
    override suspend fun deleteCustomDbEngineVersion(input: DeleteCustomDbEngineVersionRequest): DeleteCustomDbEngineVersionResponse {
        val op = SdkHttpOperation.build<DeleteCustomDbEngineVersionRequest, DeleteCustomDbEngineVersionResponse> {
            serializeWith = DeleteCustomDBEngineVersionOperationSerializer()
            deserializeWith = DeleteCustomDBEngineVersionOperationDeserializer()
            operationName = "DeleteCustomDBEngineVersion"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * The DeleteDBCluster action deletes a previously provisioned DB cluster. When you delete a DB cluster, all automated backups for that DB cluster are deleted and can't be recovered. Manual DB cluster snapshots of the specified DB cluster are not deleted.
     *
     * If you're deleting a Multi-AZ DB cluster with read replicas, all cluster members are terminated and read replicas are promoted to standalone instances.
     *
     * For more information on Amazon Aurora, see [ What is Amazon Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html) in the *Amazon Aurora User Guide*.
     *
     * For more information on Multi-AZ DB clusters, see [ Multi-AZ DB cluster deployments](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html) in the *Amazon RDS User Guide*.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DeleteDBCluster.sample
     */
    override suspend fun deleteDbCluster(input: DeleteDbClusterRequest): DeleteDbClusterResponse {
        val op = SdkHttpOperation.build<DeleteDbClusterRequest, DeleteDbClusterResponse> {
            serializeWith = DeleteDBClusterOperationSerializer()
            deserializeWith = DeleteDBClusterOperationDeserializer()
            operationName = "DeleteDBCluster"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes automated backups using the `DbClusterResourceId` value of the source DB cluster or the Amazon Resource Name (ARN) of the automated backups.
     */
    override suspend fun deleteDbClusterAutomatedBackup(input: DeleteDbClusterAutomatedBackupRequest): DeleteDbClusterAutomatedBackupResponse {
        val op = SdkHttpOperation.build<DeleteDbClusterAutomatedBackupRequest, DeleteDbClusterAutomatedBackupResponse> {
            serializeWith = DeleteDBClusterAutomatedBackupOperationSerializer()
            deserializeWith = DeleteDBClusterAutomatedBackupOperationDeserializer()
            operationName = "DeleteDBClusterAutomatedBackup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a custom endpoint and removes it from an Amazon Aurora DB cluster.
     *
     * This action only applies to Aurora DB clusters.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DeleteDBClusterEndpoint.sample
     */
    override suspend fun deleteDbClusterEndpoint(input: DeleteDbClusterEndpointRequest): DeleteDbClusterEndpointResponse {
        val op = SdkHttpOperation.build<DeleteDbClusterEndpointRequest, DeleteDbClusterEndpointResponse> {
            serializeWith = DeleteDBClusterEndpointOperationSerializer()
            deserializeWith = DeleteDBClusterEndpointOperationDeserializer()
            operationName = "DeleteDBClusterEndpoint"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a specified DB cluster parameter group. The DB cluster parameter group to be deleted can't be associated with any DB clusters.
     *
     * For more information on Amazon Aurora, see [ What is Amazon Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html) in the *Amazon Aurora User Guide*.
     *
     * For more information on Multi-AZ DB clusters, see [ Multi-AZ DB cluster deployments](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html) in the *Amazon RDS User Guide*.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DeleteDBClusterParameterGroup.sample
     */
    override suspend fun deleteDbClusterParameterGroup(input: DeleteDbClusterParameterGroupRequest): DeleteDbClusterParameterGroupResponse {
        val op = SdkHttpOperation.build<DeleteDbClusterParameterGroupRequest, DeleteDbClusterParameterGroupResponse> {
            serializeWith = DeleteDBClusterParameterGroupOperationSerializer()
            deserializeWith = DeleteDBClusterParameterGroupOperationDeserializer()
            operationName = "DeleteDBClusterParameterGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a DB cluster snapshot. If the snapshot is being copied, the copy operation is terminated.
     *
     * The DB cluster snapshot must be in the `available` state to be deleted.
     *
     * For more information on Amazon Aurora, see [ What is Amazon Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html) in the *Amazon Aurora User Guide*.
     *
     * For more information on Multi-AZ DB clusters, see [ Multi-AZ DB cluster deployments](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html) in the *Amazon RDS User Guide*.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DeleteDBClusterSnapshot.sample
     */
    override suspend fun deleteDbClusterSnapshot(input: DeleteDbClusterSnapshotRequest): DeleteDbClusterSnapshotResponse {
        val op = SdkHttpOperation.build<DeleteDbClusterSnapshotRequest, DeleteDbClusterSnapshotResponse> {
            serializeWith = DeleteDBClusterSnapshotOperationSerializer()
            deserializeWith = DeleteDBClusterSnapshotOperationDeserializer()
            operationName = "DeleteDBClusterSnapshot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a previously provisioned DB instance. When you delete a DB instance, all automated backups for that instance are deleted and can't be recovered. However, manual DB snapshots of the DB instance aren't deleted.
     *
     * If you request a final DB snapshot, the status of the Amazon RDS DB instance is `deleting` until the DB snapshot is created. This operation can't be canceled or reverted after it begins. To monitor the status of this operation, use `DescribeDBInstance`.
     *
     * When a DB instance is in a failure state and has a status of `failed`, `incompatible-restore`, or `incompatible-network`, you can only delete it when you skip creation of the final snapshot with the `SkipFinalSnapshot` parameter.
     *
     * If the specified DB instance is part of an Amazon Aurora DB cluster, you can't delete the DB instance if both of the following conditions are true:
     * + The DB cluster is a read replica of another Amazon Aurora DB cluster.
     * + The DB instance is the only instance in the DB cluster.
     *
     * To delete a DB instance in this case, first use the `PromoteReadReplicaDBCluster` operation to promote the DB cluster so that it's no longer a read replica. After the promotion completes, use the `DeleteDBInstance` operation to delete the final instance in the DB cluster.
     *
     * For RDS Custom DB instances, deleting the DB instance permanently deletes the EC2 instance and the associated EBS volumes. Make sure that you don't terminate or delete these resources before you delete the DB instance. Otherwise, deleting the DB instance and creation of the final snapshot might fail.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DeleteDBInstance.sample
     */
    override suspend fun deleteDbInstance(input: DeleteDbInstanceRequest): DeleteDbInstanceResponse {
        val op = SdkHttpOperation.build<DeleteDbInstanceRequest, DeleteDbInstanceResponse> {
            serializeWith = DeleteDBInstanceOperationSerializer()
            deserializeWith = DeleteDBInstanceOperationDeserializer()
            operationName = "DeleteDBInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes automated backups using the `DbiResourceId` value of the source DB instance or the Amazon Resource Name (ARN) of the automated backups.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DeleteDBInstanceAutomatedBackup.sample
     */
    override suspend fun deleteDbInstanceAutomatedBackup(input: DeleteDbInstanceAutomatedBackupRequest): DeleteDbInstanceAutomatedBackupResponse {
        val op = SdkHttpOperation.build<DeleteDbInstanceAutomatedBackupRequest, DeleteDbInstanceAutomatedBackupResponse> {
            serializeWith = DeleteDBInstanceAutomatedBackupOperationSerializer()
            deserializeWith = DeleteDBInstanceAutomatedBackupOperationDeserializer()
            operationName = "DeleteDBInstanceAutomatedBackup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a specified DB parameter group. The DB parameter group to be deleted can't be associated with any DB instances.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DeleteDBParameterGroup.sample
     */
    override suspend fun deleteDbParameterGroup(input: DeleteDbParameterGroupRequest): DeleteDbParameterGroupResponse {
        val op = SdkHttpOperation.build<DeleteDbParameterGroupRequest, DeleteDbParameterGroupResponse> {
            serializeWith = DeleteDBParameterGroupOperationSerializer()
            deserializeWith = DeleteDBParameterGroupOperationDeserializer()
            operationName = "DeleteDBParameterGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing DB proxy.
     */
    override suspend fun deleteDbProxy(input: DeleteDbProxyRequest): DeleteDbProxyResponse {
        val op = SdkHttpOperation.build<DeleteDbProxyRequest, DeleteDbProxyResponse> {
            serializeWith = DeleteDBProxyOperationSerializer()
            deserializeWith = DeleteDBProxyOperationDeserializer()
            operationName = "DeleteDBProxy"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a `DBProxyEndpoint`. Doing so removes the ability to access the DB proxy using the endpoint that you defined. The endpoint that you delete might have provided capabilities such as read/write or read-only operations, or using a different VPC than the DB proxy's default VPC.
     */
    override suspend fun deleteDbProxyEndpoint(input: DeleteDbProxyEndpointRequest): DeleteDbProxyEndpointResponse {
        val op = SdkHttpOperation.build<DeleteDbProxyEndpointRequest, DeleteDbProxyEndpointResponse> {
            serializeWith = DeleteDBProxyEndpointOperationSerializer()
            deserializeWith = DeleteDBProxyEndpointOperationDeserializer()
            operationName = "DeleteDBProxyEndpoint"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a DB security group.
     *
     * The specified DB security group must not be associated with any DB instances.
     *
     * EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we recommend that you migrate as soon as possible. For more information, see [Migrate from EC2-Classic to a VPC](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html) in the *Amazon EC2 User Guide*, the blog [EC2-Classic Networking is Retiring – Here’s How to Prepare](http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/), and [Moving a DB instance not in a VPC into a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html) in the *Amazon RDS User Guide*.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DeleteDBSecurityGroup.sample
     */
    override suspend fun deleteDbSecurityGroup(input: DeleteDbSecurityGroupRequest): DeleteDbSecurityGroupResponse {
        val op = SdkHttpOperation.build<DeleteDbSecurityGroupRequest, DeleteDbSecurityGroupResponse> {
            serializeWith = DeleteDBSecurityGroupOperationSerializer()
            deserializeWith = DeleteDBSecurityGroupOperationDeserializer()
            operationName = "DeleteDBSecurityGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an Aurora Limitless Database DB shard group.
     */
    override suspend fun deleteDbShardGroup(input: DeleteDbShardGroupRequest): DeleteDbShardGroupResponse {
        val op = SdkHttpOperation.build<DeleteDbShardGroupRequest, DeleteDbShardGroupResponse> {
            serializeWith = DeleteDBShardGroupOperationSerializer()
            deserializeWith = DeleteDBShardGroupOperationDeserializer()
            operationName = "DeleteDBShardGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a DB snapshot. If the snapshot is being copied, the copy operation is terminated.
     *
     * The DB snapshot must be in the `available` state to be deleted.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DeleteDBSnapshot.sample
     */
    override suspend fun deleteDbSnapshot(input: DeleteDbSnapshotRequest): DeleteDbSnapshotResponse {
        val op = SdkHttpOperation.build<DeleteDbSnapshotRequest, DeleteDbSnapshotResponse> {
            serializeWith = DeleteDBSnapshotOperationSerializer()
            deserializeWith = DeleteDBSnapshotOperationDeserializer()
            operationName = "DeleteDBSnapshot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a DB subnet group.
     *
     * The specified database subnet group must not be associated with any DB instances.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DeleteDBSubnetGroup.sample
     */
    override suspend fun deleteDbSubnetGroup(input: DeleteDbSubnetGroupRequest): DeleteDbSubnetGroupResponse {
        val op = SdkHttpOperation.build<DeleteDbSubnetGroupRequest, DeleteDbSubnetGroupResponse> {
            serializeWith = DeleteDBSubnetGroupOperationSerializer()
            deserializeWith = DeleteDBSubnetGroupOperationDeserializer()
            operationName = "DeleteDBSubnetGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an RDS event notification subscription.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DeleteEventSubscription.sample
     */
    override suspend fun deleteEventSubscription(input: DeleteEventSubscriptionRequest): DeleteEventSubscriptionResponse {
        val op = SdkHttpOperation.build<DeleteEventSubscriptionRequest, DeleteEventSubscriptionResponse> {
            serializeWith = DeleteEventSubscriptionOperationSerializer()
            deserializeWith = DeleteEventSubscriptionOperationDeserializer()
            operationName = "DeleteEventSubscription"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a global database cluster. The primary and secondary clusters must already be detached or destroyed first.
     *
     * This action only applies to Aurora DB clusters.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DeleteGlobalCluster.sample
     */
    override suspend fun deleteGlobalCluster(input: DeleteGlobalClusterRequest): DeleteGlobalClusterResponse {
        val op = SdkHttpOperation.build<DeleteGlobalClusterRequest, DeleteGlobalClusterResponse> {
            serializeWith = DeleteGlobalClusterOperationSerializer()
            deserializeWith = DeleteGlobalClusterOperationDeserializer()
            operationName = "DeleteGlobalCluster"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a zero-ETL integration with Amazon Redshift.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DeleteIntegration.sample
     */
    override suspend fun deleteIntegration(input: DeleteIntegrationRequest): DeleteIntegrationResponse {
        val op = SdkHttpOperation.build<DeleteIntegrationRequest, DeleteIntegrationResponse> {
            serializeWith = DeleteIntegrationOperationSerializer()
            deserializeWith = DeleteIntegrationOperationDeserializer()
            operationName = "DeleteIntegration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing option group.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DeleteOptionGroup.sample
     */
    override suspend fun deleteOptionGroup(input: DeleteOptionGroupRequest): DeleteOptionGroupResponse {
        val op = SdkHttpOperation.build<DeleteOptionGroupRequest, DeleteOptionGroupResponse> {
            serializeWith = DeleteOptionGroupOperationSerializer()
            deserializeWith = DeleteOptionGroupOperationDeserializer()
            operationName = "DeleteOptionGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a tenant database from your DB instance. This command only applies to RDS for Oracle container database (CDB) instances.
     *
     * You can't delete a tenant database when it is the only tenant in the DB instance.
     */
    override suspend fun deleteTenantDatabase(input: DeleteTenantDatabaseRequest): DeleteTenantDatabaseResponse {
        val op = SdkHttpOperation.build<DeleteTenantDatabaseRequest, DeleteTenantDatabaseResponse> {
            serializeWith = DeleteTenantDatabaseOperationSerializer()
            deserializeWith = DeleteTenantDatabaseOperationDeserializer()
            operationName = "DeleteTenantDatabase"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Remove the association between one or more `DBProxyTarget` data structures and a `DBProxyTargetGroup`.
     */
    override suspend fun deregisterDbProxyTargets(input: DeregisterDbProxyTargetsRequest): DeregisterDbProxyTargetsResponse {
        val op = SdkHttpOperation.build<DeregisterDbProxyTargetsRequest, DeregisterDbProxyTargetsResponse> {
            serializeWith = DeregisterDBProxyTargetsOperationSerializer()
            deserializeWith = DeregisterDBProxyTargetsOperationDeserializer()
            operationName = "DeregisterDBProxyTargets"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all of the attributes for a customer account. The attributes include Amazon RDS quotas for the account, such as the number of DB instances allowed. The description for a quota includes the quota name, current usage toward that quota, and the quota's maximum value.
     *
     * This command doesn't take any parameters.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DescribeAccountAttributes.sample
     */
    override suspend fun describeAccountAttributes(input: DescribeAccountAttributesRequest): DescribeAccountAttributesResponse {
        val op = SdkHttpOperation.build<DescribeAccountAttributesRequest, DescribeAccountAttributesResponse> {
            serializeWith = DescribeAccountAttributesOperationSerializer()
            deserializeWith = DescribeAccountAttributesOperationDeserializer()
            operationName = "DescribeAccountAttributes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more blue/green deployments.
     *
     * For more information, see [Using Amazon RDS Blue/Green Deployments for database updates](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html) in the *Amazon RDS User Guide* and [ Using Amazon RDS Blue/Green Deployments for database updates](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html) in the *Amazon Aurora User Guide*.
     */
    override suspend fun describeBlueGreenDeployments(input: DescribeBlueGreenDeploymentsRequest): DescribeBlueGreenDeploymentsResponse {
        val op = SdkHttpOperation.build<DescribeBlueGreenDeploymentsRequest, DescribeBlueGreenDeploymentsResponse> {
            serializeWith = DescribeBlueGreenDeploymentsOperationSerializer()
            deserializeWith = DescribeBlueGreenDeploymentsOperationDeserializer()
            operationName = "DescribeBlueGreenDeployments"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the set of certificate authority (CA) certificates provided by Amazon RDS for this Amazon Web Services account.
     *
     * For more information, see [Using SSL/TLS to encrypt a connection to a DB instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html) in the *Amazon RDS User Guide* and [ Using SSL/TLS to encrypt a connection to a DB cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html) in the *Amazon Aurora User Guide*.
     */
    override suspend fun describeCertificates(input: DescribeCertificatesRequest): DescribeCertificatesResponse {
        val op = SdkHttpOperation.build<DescribeCertificatesRequest, DescribeCertificatesResponse> {
            serializeWith = DescribeCertificatesOperationSerializer()
            deserializeWith = DescribeCertificatesOperationDeserializer()
            operationName = "DescribeCertificates"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Displays backups for both current and deleted DB clusters. For example, use this operation to find details about automated backups for previously deleted clusters. Current clusters are returned for both the `DescribeDBClusterAutomatedBackups` and `DescribeDBClusters` operations.
     *
     * All parameters are optional.
     */
    override suspend fun describeDbClusterAutomatedBackups(input: DescribeDbClusterAutomatedBackupsRequest): DescribeDbClusterAutomatedBackupsResponse {
        val op = SdkHttpOperation.build<DescribeDbClusterAutomatedBackupsRequest, DescribeDbClusterAutomatedBackupsResponse> {
            serializeWith = DescribeDBClusterAutomatedBackupsOperationSerializer()
            deserializeWith = DescribeDBClusterAutomatedBackupsOperationDeserializer()
            operationName = "DescribeDBClusterAutomatedBackups"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about backtracks for a DB cluster.
     *
     * For more information on Amazon Aurora, see [ What is Amazon Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html) in the *Amazon Aurora User Guide*.
     *
     * This action only applies to Aurora MySQL DB clusters.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DescribeDBClusterBacktracks.sample
     */
    override suspend fun describeDbClusterBacktracks(input: DescribeDbClusterBacktracksRequest): DescribeDbClusterBacktracksResponse {
        val op = SdkHttpOperation.build<DescribeDbClusterBacktracksRequest, DescribeDbClusterBacktracksResponse> {
            serializeWith = DescribeDBClusterBacktracksOperationSerializer()
            deserializeWith = DescribeDBClusterBacktracksOperationDeserializer()
            operationName = "DescribeDBClusterBacktracks"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about endpoints for an Amazon Aurora DB cluster.
     *
     * This action only applies to Aurora DB clusters.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DescribeDBClusterEndpoints.sample
     * @sample aws.sdk.kotlin.services.rds.samples.DescribeDBClusterEndpoints.sample2
     */
    override suspend fun describeDbClusterEndpoints(input: DescribeDbClusterEndpointsRequest): DescribeDbClusterEndpointsResponse {
        val op = SdkHttpOperation.build<DescribeDbClusterEndpointsRequest, DescribeDbClusterEndpointsResponse> {
            serializeWith = DescribeDBClusterEndpointsOperationSerializer()
            deserializeWith = DescribeDBClusterEndpointsOperationDeserializer()
            operationName = "DescribeDBClusterEndpoints"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of `DBClusterParameterGroup` descriptions. If a `DBClusterParameterGroupName` parameter is specified, the list will contain only the description of the specified DB cluster parameter group.
     *
     * For more information on Amazon Aurora, see [ What is Amazon Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html) in the *Amazon Aurora User Guide*.
     *
     * For more information on Multi-AZ DB clusters, see [ Multi-AZ DB cluster deployments](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html) in the *Amazon RDS User Guide*.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DescribeDBClusterParameterGroups.sample
     */
    override suspend fun describeDbClusterParameterGroups(input: DescribeDbClusterParameterGroupsRequest): DescribeDbClusterParameterGroupsResponse {
        val op = SdkHttpOperation.build<DescribeDbClusterParameterGroupsRequest, DescribeDbClusterParameterGroupsResponse> {
            serializeWith = DescribeDBClusterParameterGroupsOperationSerializer()
            deserializeWith = DescribeDBClusterParameterGroupsOperationDeserializer()
            operationName = "DescribeDBClusterParameterGroups"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the detailed parameter list for a particular DB cluster parameter group.
     *
     * For more information on Amazon Aurora, see [ What is Amazon Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html) in the *Amazon Aurora User Guide*.
     *
     * For more information on Multi-AZ DB clusters, see [ Multi-AZ DB cluster deployments](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html) in the *Amazon RDS User Guide*.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DescribeDBClusterParameters.sample
     */
    override suspend fun describeDbClusterParameters(input: DescribeDbClusterParametersRequest): DescribeDbClusterParametersResponse {
        val op = SdkHttpOperation.build<DescribeDbClusterParametersRequest, DescribeDbClusterParametersResponse> {
            serializeWith = DescribeDBClusterParametersOperationSerializer()
            deserializeWith = DescribeDBClusterParametersOperationDeserializer()
            operationName = "DescribeDBClusterParameters"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of DB cluster snapshot attribute names and values for a manual DB cluster snapshot.
     *
     * When sharing snapshots with other Amazon Web Services accounts, `DescribeDBClusterSnapshotAttributes` returns the `restore` attribute and a list of IDs for the Amazon Web Services accounts that are authorized to copy or restore the manual DB cluster snapshot. If `all` is included in the list of values for the `restore` attribute, then the manual DB cluster snapshot is public and can be copied or restored by all Amazon Web Services accounts.
     *
     * To add or remove access for an Amazon Web Services account to copy or restore a manual DB cluster snapshot, or to make the manual DB cluster snapshot public or private, use the `ModifyDBClusterSnapshotAttribute` API action.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DescribeDBClusterSnapshotAttributes.sample
     */
    override suspend fun describeDbClusterSnapshotAttributes(input: DescribeDbClusterSnapshotAttributesRequest): DescribeDbClusterSnapshotAttributesResponse {
        val op = SdkHttpOperation.build<DescribeDbClusterSnapshotAttributesRequest, DescribeDbClusterSnapshotAttributesResponse> {
            serializeWith = DescribeDBClusterSnapshotAttributesOperationSerializer()
            deserializeWith = DescribeDBClusterSnapshotAttributesOperationDeserializer()
            operationName = "DescribeDBClusterSnapshotAttributes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about DB cluster snapshots. This API action supports pagination.
     *
     * For more information on Amazon Aurora DB clusters, see [ What is Amazon Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html) in the *Amazon Aurora User Guide*.
     *
     * For more information on Multi-AZ DB clusters, see [ Multi-AZ DB cluster deployments](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html) in the *Amazon RDS User Guide*.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DescribeDBClusterSnapshots.sample
     */
    override suspend fun describeDbClusterSnapshots(input: DescribeDbClusterSnapshotsRequest): DescribeDbClusterSnapshotsResponse {
        val op = SdkHttpOperation.build<DescribeDbClusterSnapshotsRequest, DescribeDbClusterSnapshotsResponse> {
            serializeWith = DescribeDBClusterSnapshotsOperationSerializer()
            deserializeWith = DescribeDBClusterSnapshotsOperationDeserializer()
            operationName = "DescribeDBClusterSnapshots"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes existing Amazon Aurora DB clusters and Multi-AZ DB clusters. This API supports pagination.
     *
     * For more information on Amazon Aurora DB clusters, see [ What is Amazon Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html) in the *Amazon Aurora User Guide*.
     *
     * For more information on Multi-AZ DB clusters, see [ Multi-AZ DB cluster deployments](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html) in the *Amazon RDS User Guide*.
     *
     * This operation can also return information for Amazon Neptune DB instances and Amazon DocumentDB instances.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DescribeDBClusters.sample
     */
    override suspend fun describeDbClusters(input: DescribeDbClustersRequest): DescribeDbClustersResponse {
        val op = SdkHttpOperation.build<DescribeDbClustersRequest, DescribeDbClustersResponse> {
            serializeWith = DescribeDBClustersOperationSerializer()
            deserializeWith = DescribeDBClustersOperationDeserializer()
            operationName = "DescribeDBClusters"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the properties of specific versions of DB engines.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DescribeDBEngineVersions.sample
     */
    override suspend fun describeDbEngineVersions(input: DescribeDbEngineVersionsRequest): DescribeDbEngineVersionsResponse {
        val op = SdkHttpOperation.build<DescribeDbEngineVersionsRequest, DescribeDbEngineVersionsResponse> {
            serializeWith = DescribeDBEngineVersionsOperationSerializer()
            deserializeWith = DescribeDBEngineVersionsOperationDeserializer()
            operationName = "DescribeDBEngineVersions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Displays backups for both current and deleted instances. For example, use this operation to find details about automated backups for previously deleted instances. Current instances with retention periods greater than zero (0) are returned for both the `DescribeDBInstanceAutomatedBackups` and `DescribeDBInstances` operations.
     *
     * All parameters are optional.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DescribeDBInstanceAutomatedBackups.sample
     */
    override suspend fun describeDbInstanceAutomatedBackups(input: DescribeDbInstanceAutomatedBackupsRequest): DescribeDbInstanceAutomatedBackupsResponse {
        val op = SdkHttpOperation.build<DescribeDbInstanceAutomatedBackupsRequest, DescribeDbInstanceAutomatedBackupsResponse> {
            serializeWith = DescribeDBInstanceAutomatedBackupsOperationSerializer()
            deserializeWith = DescribeDBInstanceAutomatedBackupsOperationDeserializer()
            operationName = "DescribeDBInstanceAutomatedBackups"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes provisioned RDS instances. This API supports pagination.
     *
     * This operation can also return information for Amazon Neptune DB instances and Amazon DocumentDB instances.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DescribeDBInstances.sample
     */
    override suspend fun describeDbInstances(input: DescribeDbInstancesRequest): DescribeDbInstancesResponse {
        val op = SdkHttpOperation.build<DescribeDbInstancesRequest, DescribeDbInstancesResponse> {
            serializeWith = DescribeDBInstancesOperationSerializer()
            deserializeWith = DescribeDBInstancesOperationDeserializer()
            operationName = "DescribeDBInstances"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of DB log files for the DB instance.
     *
     * This command doesn't apply to RDS Custom.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DescribeDBLogFiles.sample
     */
    override suspend fun describeDbLogFiles(input: DescribeDbLogFilesRequest): DescribeDbLogFilesResponse {
        val op = SdkHttpOperation.build<DescribeDbLogFilesRequest, DescribeDbLogFilesResponse> {
            serializeWith = DescribeDBLogFilesOperationSerializer()
            deserializeWith = DescribeDBLogFilesOperationDeserializer()
            operationName = "DescribeDBLogFiles"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of `DBParameterGroup` descriptions. If a `DBParameterGroupName` is specified, the list will contain only the description of the specified DB parameter group.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DescribeDBParameterGroups.sample
     */
    override suspend fun describeDbParameterGroups(input: DescribeDbParameterGroupsRequest): DescribeDbParameterGroupsResponse {
        val op = SdkHttpOperation.build<DescribeDbParameterGroupsRequest, DescribeDbParameterGroupsResponse> {
            serializeWith = DescribeDBParameterGroupsOperationSerializer()
            deserializeWith = DescribeDBParameterGroupsOperationDeserializer()
            operationName = "DescribeDBParameterGroups"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the detailed parameter list for a particular DB parameter group.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DescribeDBParameters.sample
     */
    override suspend fun describeDbParameters(input: DescribeDbParametersRequest): DescribeDbParametersResponse {
        val op = SdkHttpOperation.build<DescribeDbParametersRequest, DescribeDbParametersResponse> {
            serializeWith = DescribeDBParametersOperationSerializer()
            deserializeWith = DescribeDBParametersOperationDeserializer()
            operationName = "DescribeDBParameters"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about DB proxies.
     */
    override suspend fun describeDbProxies(input: DescribeDbProxiesRequest): DescribeDbProxiesResponse {
        val op = SdkHttpOperation.build<DescribeDbProxiesRequest, DescribeDbProxiesResponse> {
            serializeWith = DescribeDBProxiesOperationSerializer()
            deserializeWith = DescribeDBProxiesOperationDeserializer()
            operationName = "DescribeDBProxies"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about DB proxy endpoints.
     */
    override suspend fun describeDbProxyEndpoints(input: DescribeDbProxyEndpointsRequest): DescribeDbProxyEndpointsResponse {
        val op = SdkHttpOperation.build<DescribeDbProxyEndpointsRequest, DescribeDbProxyEndpointsResponse> {
            serializeWith = DescribeDBProxyEndpointsOperationSerializer()
            deserializeWith = DescribeDBProxyEndpointsOperationDeserializer()
            operationName = "DescribeDBProxyEndpoints"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about DB proxy target groups, represented by `DBProxyTargetGroup` data structures.
     */
    override suspend fun describeDbProxyTargetGroups(input: DescribeDbProxyTargetGroupsRequest): DescribeDbProxyTargetGroupsResponse {
        val op = SdkHttpOperation.build<DescribeDbProxyTargetGroupsRequest, DescribeDbProxyTargetGroupsResponse> {
            serializeWith = DescribeDBProxyTargetGroupsOperationSerializer()
            deserializeWith = DescribeDBProxyTargetGroupsOperationDeserializer()
            operationName = "DescribeDBProxyTargetGroups"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about `DBProxyTarget` objects. This API supports pagination.
     */
    override suspend fun describeDbProxyTargets(input: DescribeDbProxyTargetsRequest): DescribeDbProxyTargetsResponse {
        val op = SdkHttpOperation.build<DescribeDbProxyTargetsRequest, DescribeDbProxyTargetsResponse> {
            serializeWith = DescribeDBProxyTargetsOperationSerializer()
            deserializeWith = DescribeDBProxyTargetsOperationDeserializer()
            operationName = "DescribeDBProxyTargets"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the recommendations to resolve the issues for your DB instances, DB clusters, and DB parameter groups.
     */
    override suspend fun describeDbRecommendations(input: DescribeDbRecommendationsRequest): DescribeDbRecommendationsResponse {
        val op = SdkHttpOperation.build<DescribeDbRecommendationsRequest, DescribeDbRecommendationsResponse> {
            serializeWith = DescribeDBRecommendationsOperationSerializer()
            deserializeWith = DescribeDBRecommendationsOperationDeserializer()
            operationName = "DescribeDBRecommendations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of `DBSecurityGroup` descriptions. If a `DBSecurityGroupName` is specified, the list will contain only the descriptions of the specified DB security group.
     *
     * EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we recommend that you migrate as soon as possible. For more information, see [Migrate from EC2-Classic to a VPC](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html) in the *Amazon EC2 User Guide*, the blog [EC2-Classic Networking is Retiring – Here’s How to Prepare](http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/), and [Moving a DB instance not in a VPC into a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html) in the *Amazon RDS User Guide*.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DescribeDBSecurityGroups.sample
     */
    override suspend fun describeDbSecurityGroups(input: DescribeDbSecurityGroupsRequest): DescribeDbSecurityGroupsResponse {
        val op = SdkHttpOperation.build<DescribeDbSecurityGroupsRequest, DescribeDbSecurityGroupsResponse> {
            serializeWith = DescribeDBSecurityGroupsOperationSerializer()
            deserializeWith = DescribeDBSecurityGroupsOperationDeserializer()
            operationName = "DescribeDBSecurityGroups"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes existing Aurora Limitless Database DB shard groups.
     */
    override suspend fun describeDbShardGroups(input: DescribeDbShardGroupsRequest): DescribeDbShardGroupsResponse {
        val op = SdkHttpOperation.build<DescribeDbShardGroupsRequest, DescribeDbShardGroupsResponse> {
            serializeWith = DescribeDBShardGroupsOperationSerializer()
            deserializeWith = DescribeDBShardGroupsOperationDeserializer()
            operationName = "DescribeDBShardGroups"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of DB snapshot attribute names and values for a manual DB snapshot.
     *
     * When sharing snapshots with other Amazon Web Services accounts, `DescribeDBSnapshotAttributes` returns the `restore` attribute and a list of IDs for the Amazon Web Services accounts that are authorized to copy or restore the manual DB snapshot. If `all` is included in the list of values for the `restore` attribute, then the manual DB snapshot is public and can be copied or restored by all Amazon Web Services accounts.
     *
     * To add or remove access for an Amazon Web Services account to copy or restore a manual DB snapshot, or to make the manual DB snapshot public or private, use the `ModifyDBSnapshotAttribute` API action.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DescribeDBSnapshotAttributes.sample
     */
    override suspend fun describeDbSnapshotAttributes(input: DescribeDbSnapshotAttributesRequest): DescribeDbSnapshotAttributesResponse {
        val op = SdkHttpOperation.build<DescribeDbSnapshotAttributesRequest, DescribeDbSnapshotAttributesResponse> {
            serializeWith = DescribeDBSnapshotAttributesOperationSerializer()
            deserializeWith = DescribeDBSnapshotAttributesOperationDeserializer()
            operationName = "DescribeDBSnapshotAttributes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the tenant databases that exist in a DB snapshot. This command only applies to RDS for Oracle DB instances in the multi-tenant configuration.
     *
     * You can use this command to inspect the tenant databases within a snapshot before restoring it. You can't directly interact with the tenant databases in a DB snapshot. If you restore a snapshot that was taken from DB instance using the multi-tenant configuration, you restore all its tenant databases.
     */
    override suspend fun describeDbSnapshotTenantDatabases(input: DescribeDbSnapshotTenantDatabasesRequest): DescribeDbSnapshotTenantDatabasesResponse {
        val op = SdkHttpOperation.build<DescribeDbSnapshotTenantDatabasesRequest, DescribeDbSnapshotTenantDatabasesResponse> {
            serializeWith = DescribeDBSnapshotTenantDatabasesOperationSerializer()
            deserializeWith = DescribeDBSnapshotTenantDatabasesOperationDeserializer()
            operationName = "DescribeDBSnapshotTenantDatabases"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about DB snapshots. This API action supports pagination.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DescribeDBSnapshots.sample
     */
    override suspend fun describeDbSnapshots(input: DescribeDbSnapshotsRequest): DescribeDbSnapshotsResponse {
        val op = SdkHttpOperation.build<DescribeDbSnapshotsRequest, DescribeDbSnapshotsResponse> {
            serializeWith = DescribeDBSnapshotsOperationSerializer()
            deserializeWith = DescribeDBSnapshotsOperationDeserializer()
            operationName = "DescribeDBSnapshots"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified, the list will contain only the descriptions of the specified DBSubnetGroup.
     *
     * For an overview of CIDR ranges, go to the [Wikipedia Tutorial](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DescribeDBSubnetGroups.sample
     */
    override suspend fun describeDbSubnetGroups(input: DescribeDbSubnetGroupsRequest): DescribeDbSubnetGroupsResponse {
        val op = SdkHttpOperation.build<DescribeDbSubnetGroupsRequest, DescribeDbSubnetGroupsResponse> {
            serializeWith = DescribeDBSubnetGroupsOperationSerializer()
            deserializeWith = DescribeDBSubnetGroupsOperationDeserializer()
            operationName = "DescribeDBSubnetGroups"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the default engine and system parameter information for the cluster database engine.
     *
     * For more information on Amazon Aurora, see [ What is Amazon Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html) in the *Amazon Aurora User Guide*.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DescribeEngineDefaultClusterParameters.sample
     */
    override suspend fun describeEngineDefaultClusterParameters(input: DescribeEngineDefaultClusterParametersRequest): DescribeEngineDefaultClusterParametersResponse {
        val op = SdkHttpOperation.build<DescribeEngineDefaultClusterParametersRequest, DescribeEngineDefaultClusterParametersResponse> {
            serializeWith = DescribeEngineDefaultClusterParametersOperationSerializer()
            deserializeWith = DescribeEngineDefaultClusterParametersOperationDeserializer()
            operationName = "DescribeEngineDefaultClusterParameters"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the default engine and system parameter information for the specified database engine.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DescribeEngineDefaultParameters.sample
     */
    override suspend fun describeEngineDefaultParameters(input: DescribeEngineDefaultParametersRequest): DescribeEngineDefaultParametersResponse {
        val op = SdkHttpOperation.build<DescribeEngineDefaultParametersRequest, DescribeEngineDefaultParametersResponse> {
            serializeWith = DescribeEngineDefaultParametersOperationSerializer()
            deserializeWith = DescribeEngineDefaultParametersOperationDeserializer()
            operationName = "DescribeEngineDefaultParameters"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Displays a list of categories for all event source types, or, if specified, for a specified source type. You can also see this list in the "Amazon RDS event categories and event messages" section of the *Amazon RDS User Guide*[](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Messages.html) or the *Amazon Aurora User Guide*[](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Messages.html).
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DescribeEventCategories.sample
     */
    override suspend fun describeEventCategories(input: DescribeEventCategoriesRequest): DescribeEventCategoriesResponse {
        val op = SdkHttpOperation.build<DescribeEventCategoriesRequest, DescribeEventCategoriesResponse> {
            serializeWith = DescribeEventCategoriesOperationSerializer()
            deserializeWith = DescribeEventCategoriesOperationDeserializer()
            operationName = "DescribeEventCategories"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the subscription descriptions for a customer account. The description for a subscription includes `SubscriptionName`, `SNSTopicARN`, `CustomerID`, `SourceType`, `SourceID`, `CreationTime`, and `Status`.
     *
     * If you specify a `SubscriptionName`, lists the description for that subscription.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DescribeEventSubscriptions.sample
     */
    override suspend fun describeEventSubscriptions(input: DescribeEventSubscriptionsRequest): DescribeEventSubscriptionsResponse {
        val op = SdkHttpOperation.build<DescribeEventSubscriptionsRequest, DescribeEventSubscriptionsResponse> {
            serializeWith = DescribeEventSubscriptionsOperationSerializer()
            deserializeWith = DescribeEventSubscriptionsOperationDeserializer()
            operationName = "DescribeEventSubscriptions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns events related to DB instances, DB clusters, DB parameter groups, DB security groups, DB snapshots, DB cluster snapshots, and RDS Proxies for the past 14 days. Events specific to a particular DB instance, DB cluster, DB parameter group, DB security group, DB snapshot, DB cluster snapshot group, or RDS Proxy can be obtained by providing the name as a parameter.
     *
     * For more information on working with events, see [Monitoring Amazon RDS events](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/working-with-events.html) in the *Amazon RDS User Guide* and [Monitoring Amazon Aurora events](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/working-with-events.html) in the *Amazon Aurora User Guide*.
     *
     * By default, RDS returns events that were generated in the past hour.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DescribeEvents.sample
     */
    override suspend fun describeEvents(input: DescribeEventsRequest): DescribeEventsResponse {
        val op = SdkHttpOperation.build<DescribeEventsRequest, DescribeEventsResponse> {
            serializeWith = DescribeEventsOperationSerializer()
            deserializeWith = DescribeEventsOperationDeserializer()
            operationName = "DescribeEvents"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a snapshot or cluster export to Amazon S3. This API operation supports pagination.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DescribeExportTasks.sample
     */
    override suspend fun describeExportTasks(input: DescribeExportTasksRequest): DescribeExportTasksResponse {
        val op = SdkHttpOperation.build<DescribeExportTasksRequest, DescribeExportTasksResponse> {
            serializeWith = DescribeExportTasksOperationSerializer()
            deserializeWith = DescribeExportTasksOperationDeserializer()
            operationName = "DescribeExportTasks"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about Aurora global database clusters. This API supports pagination.
     *
     * For more information on Amazon Aurora, see [ What is Amazon Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html) in the *Amazon Aurora User Guide*.
     *
     * This action only applies to Aurora DB clusters.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DescribeGlobalClusters.sample
     */
    override suspend fun describeGlobalClusters(input: DescribeGlobalClustersRequest): DescribeGlobalClustersResponse {
        val op = SdkHttpOperation.build<DescribeGlobalClustersRequest, DescribeGlobalClustersResponse> {
            serializeWith = DescribeGlobalClustersOperationSerializer()
            deserializeWith = DescribeGlobalClustersOperationDeserializer()
            operationName = "DescribeGlobalClusters"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describe one or more zero-ETL integrations with Amazon Redshift.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DescribeIntegrations.sample
     */
    override suspend fun describeIntegrations(input: DescribeIntegrationsRequest): DescribeIntegrationsResponse {
        val op = SdkHttpOperation.build<DescribeIntegrationsRequest, DescribeIntegrationsResponse> {
            serializeWith = DescribeIntegrationsOperationSerializer()
            deserializeWith = DescribeIntegrationsOperationDeserializer()
            operationName = "DescribeIntegrations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes all available options for the specified engine.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DescribeOptionGroupOptions.sample
     */
    override suspend fun describeOptionGroupOptions(input: DescribeOptionGroupOptionsRequest): DescribeOptionGroupOptionsResponse {
        val op = SdkHttpOperation.build<DescribeOptionGroupOptionsRequest, DescribeOptionGroupOptionsResponse> {
            serializeWith = DescribeOptionGroupOptionsOperationSerializer()
            deserializeWith = DescribeOptionGroupOptionsOperationDeserializer()
            operationName = "DescribeOptionGroupOptions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the available option groups.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DescribeOptionGroups.sample
     */
    override suspend fun describeOptionGroups(input: DescribeOptionGroupsRequest): DescribeOptionGroupsResponse {
        val op = SdkHttpOperation.build<DescribeOptionGroupsRequest, DescribeOptionGroupsResponse> {
            serializeWith = DescribeOptionGroupsOperationSerializer()
            deserializeWith = DescribeOptionGroupsOperationDeserializer()
            operationName = "DescribeOptionGroups"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the orderable DB instance options for a specified DB engine.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DescribeOrderableDBInstanceOptions.sample
     */
    override suspend fun describeOrderableDbInstanceOptions(input: DescribeOrderableDbInstanceOptionsRequest): DescribeOrderableDbInstanceOptionsResponse {
        val op = SdkHttpOperation.build<DescribeOrderableDbInstanceOptionsRequest, DescribeOrderableDbInstanceOptionsResponse> {
            serializeWith = DescribeOrderableDBInstanceOptionsOperationSerializer()
            deserializeWith = DescribeOrderableDBInstanceOptionsOperationDeserializer()
            operationName = "DescribeOrderableDBInstanceOptions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of resources (for example, DB instances) that have at least one pending maintenance action.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DescribePendingMaintenanceActions.sample
     */
    override suspend fun describePendingMaintenanceActions(input: DescribePendingMaintenanceActionsRequest): DescribePendingMaintenanceActionsResponse {
        val op = SdkHttpOperation.build<DescribePendingMaintenanceActionsRequest, DescribePendingMaintenanceActionsResponse> {
            serializeWith = DescribePendingMaintenanceActionsOperationSerializer()
            deserializeWith = DescribePendingMaintenanceActionsOperationDeserializer()
            operationName = "DescribePendingMaintenanceActions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about reserved DB instances for this account, or about a specified reserved DB instance.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DescribeReservedDBInstances.sample
     */
    override suspend fun describeReservedDbInstances(input: DescribeReservedDbInstancesRequest): DescribeReservedDbInstancesResponse {
        val op = SdkHttpOperation.build<DescribeReservedDbInstancesRequest, DescribeReservedDbInstancesResponse> {
            serializeWith = DescribeReservedDBInstancesOperationSerializer()
            deserializeWith = DescribeReservedDBInstancesOperationDeserializer()
            operationName = "DescribeReservedDBInstances"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists available reserved DB instance offerings.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DescribeReservedDBInstancesOfferings.sample
     */
    override suspend fun describeReservedDbInstancesOfferings(input: DescribeReservedDbInstancesOfferingsRequest): DescribeReservedDbInstancesOfferingsResponse {
        val op = SdkHttpOperation.build<DescribeReservedDbInstancesOfferingsRequest, DescribeReservedDbInstancesOfferingsResponse> {
            serializeWith = DescribeReservedDBInstancesOfferingsOperationSerializer()
            deserializeWith = DescribeReservedDBInstancesOfferingsOperationDeserializer()
            operationName = "DescribeReservedDBInstancesOfferings"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of the source Amazon Web Services Regions where the current Amazon Web Services Region can create a read replica, copy a DB snapshot from, or replicate automated backups from.
     *
     * Use this operation to determine whether cross-Region features are supported between other Regions and your current Region. This operation supports pagination.
     *
     * To return information about the Regions that are enabled for your account, or all Regions, use the EC2 operation `DescribeRegions`. For more information, see [ DescribeRegions](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeRegions.html) in the *Amazon EC2 API Reference*.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DescribeSourceRegions.sample
     */
    override suspend fun describeSourceRegions(input: DescribeSourceRegionsRequest): DescribeSourceRegionsResponse {
        val op = SdkHttpOperation.build<DescribeSourceRegionsRequest, DescribeSourceRegionsResponse> {
            serializeWith = DescribeSourceRegionsOperationSerializer()
            deserializeWith = DescribeSourceRegionsOperationDeserializer()
            operationName = "DescribeSourceRegions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the tenant databases in a DB instance that uses the multi-tenant configuration. Only RDS for Oracle CDB instances are supported.
     */
    override suspend fun describeTenantDatabases(input: DescribeTenantDatabasesRequest): DescribeTenantDatabasesResponse {
        val op = SdkHttpOperation.build<DescribeTenantDatabasesRequest, DescribeTenantDatabasesResponse> {
            serializeWith = DescribeTenantDatabasesOperationSerializer()
            deserializeWith = DescribeTenantDatabasesOperationDeserializer()
            operationName = "DescribeTenantDatabases"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * You can call `DescribeValidDBInstanceModifications` to learn what modifications you can make to your DB instance. You can use this information when you call `ModifyDBInstance`.
     *
     * This command doesn't apply to RDS Custom.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DescribeValidDBInstanceModifications.sample
     */
    override suspend fun describeValidDbInstanceModifications(input: DescribeValidDbInstanceModificationsRequest): DescribeValidDbInstanceModificationsResponse {
        val op = SdkHttpOperation.build<DescribeValidDbInstanceModificationsRequest, DescribeValidDbInstanceModificationsResponse> {
            serializeWith = DescribeValidDBInstanceModificationsOperationSerializer()
            deserializeWith = DescribeValidDBInstanceModificationsOperationDeserializer()
            operationName = "DescribeValidDBInstanceModifications"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disables the HTTP endpoint for the specified DB cluster. Disabling this endpoint disables RDS Data API.
     *
     * For more information, see [Using RDS Data API](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html) in the *Amazon Aurora User Guide*.
     *
     * This operation applies only to Aurora PostgreSQL Serverless v2 and provisioned DB clusters. To disable the HTTP endpoint for Aurora Serverless v1 DB clusters, use the `EnableHttpEndpoint` parameter of the `ModifyDBCluster` operation.
     */
    override suspend fun disableHttpEndpoint(input: DisableHttpEndpointRequest): DisableHttpEndpointResponse {
        val op = SdkHttpOperation.build<DisableHttpEndpointRequest, DisableHttpEndpointResponse> {
            serializeWith = DisableHttpEndpointOperationSerializer()
            deserializeWith = DisableHttpEndpointOperationDeserializer()
            operationName = "DisableHttpEndpoint"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Downloads all or a portion of the specified log file, up to 1 MB in size.
     *
     * This command doesn't apply to RDS Custom.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.DownloadDBLogFilePortion.sample
     */
    override suspend fun downloadDbLogFilePortion(input: DownloadDbLogFilePortionRequest): DownloadDbLogFilePortionResponse {
        val op = SdkHttpOperation.build<DownloadDbLogFilePortionRequest, DownloadDbLogFilePortionResponse> {
            serializeWith = DownloadDBLogFilePortionOperationSerializer()
            deserializeWith = DownloadDBLogFilePortionOperationDeserializer()
            operationName = "DownloadDBLogFilePortion"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Enables the HTTP endpoint for the DB cluster. By default, the HTTP endpoint isn't enabled.
     *
     * When enabled, this endpoint provides a connectionless web service API (RDS Data API) for running SQL queries on the Aurora DB cluster. You can also query your database from inside the RDS console with the RDS query editor.
     *
     * For more information, see [Using RDS Data API](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html) in the *Amazon Aurora User Guide*.
     *
     * This operation applies only to Aurora PostgreSQL Serverless v2 and provisioned DB clusters. To enable the HTTP endpoint for Aurora Serverless v1 DB clusters, use the `EnableHttpEndpoint` parameter of the `ModifyDBCluster` operation.
     */
    override suspend fun enableHttpEndpoint(input: EnableHttpEndpointRequest): EnableHttpEndpointResponse {
        val op = SdkHttpOperation.build<EnableHttpEndpointRequest, EnableHttpEndpointResponse> {
            serializeWith = EnableHttpEndpointOperationSerializer()
            deserializeWith = EnableHttpEndpointOperationDeserializer()
            operationName = "EnableHttpEndpoint"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Forces a failover for a DB cluster.
     *
     * For an Aurora DB cluster, failover for a DB cluster promotes one of the Aurora Replicas (read-only instances) in the DB cluster to be the primary DB instance (the cluster writer).
     *
     * For a Multi-AZ DB cluster, after RDS terminates the primary DB instance, the internal monitoring system detects that the primary DB instance is unhealthy and promotes a readable standby (read-only instances) in the DB cluster to be the primary DB instance (the cluster writer). Failover times are typically less than 35 seconds.
     *
     * An Amazon Aurora DB cluster automatically fails over to an Aurora Replica, if one exists, when the primary DB instance fails. A Multi-AZ DB cluster automatically fails over to a readable standby DB instance when the primary DB instance fails.
     *
     * To simulate a failure of a primary instance for testing, you can force a failover. Because each instance in a DB cluster has its own endpoint address, make sure to clean up and re-establish any existing connections that use those endpoint addresses when the failover is complete.
     *
     * For more information on Amazon Aurora DB clusters, see [ What is Amazon Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html) in the *Amazon Aurora User Guide*.
     *
     * For more information on Multi-AZ DB clusters, see [ Multi-AZ DB cluster deployments](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html) in the *Amazon RDS User Guide*.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.FailoverDBCluster.sample
     */
    override suspend fun failoverDbCluster(input: FailoverDbClusterRequest): FailoverDbClusterResponse {
        val op = SdkHttpOperation.build<FailoverDbClusterRequest, FailoverDbClusterResponse> {
            serializeWith = FailoverDBClusterOperationSerializer()
            deserializeWith = FailoverDBClusterOperationDeserializer()
            operationName = "FailoverDBCluster"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Promotes the specified secondary DB cluster to be the primary DB cluster in the global database cluster to fail over or switch over a global database. Switchover operations were previously called "managed planned failovers."
     *
     * Although this operation can be used either to fail over or to switch over a global database cluster, its intended use is for global database failover. To switch over a global database cluster, we recommend that you use the SwitchoverGlobalCluster operation instead.
     *
     * How you use this operation depends on whether you are failing over or switching over your global database cluster:
     * + Failing over - Specify the `AllowDataLoss` parameter and don't specify the `Switchover` parameter.
     * + Switching over - Specify the `Switchover` parameter or omit it, but don't specify the `AllowDataLoss` parameter.
     *
     * **About failing over and switching over**
     *
     * While failing over and switching over a global database cluster both change the primary DB cluster, you use these operations for different reasons:
     * + *Failing over* - Use this operation to respond to an unplanned event, such as a Regional disaster in the primary Region. Failing over can result in a loss of write transaction data that wasn't replicated to the chosen secondary before the failover event occurred. However, the recovery process that promotes a DB instance on the chosen seconday DB cluster to be the primary writer DB instance guarantees that the data is in a transactionally consistent state.For more information about failing over an Amazon Aurora global database, see [Performing managed failovers for Aurora global databases](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database-disaster-recovery.html#aurora-global-database-failover.managed-unplanned) in the *Amazon Aurora User Guide*.
     * + *Switching over* - Use this operation on a healthy global database cluster for planned events, such as Regional rotation or to fail back to the original primary DB cluster after a failover operation. With this operation, there is no data loss.For more information about switching over an Amazon Aurora global database, see [Performing switchovers for Aurora global databases](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database-disaster-recovery.html#aurora-global-database-disaster-recovery.managed-failover) in the *Amazon Aurora User Guide*.
     */
    override suspend fun failoverGlobalCluster(input: FailoverGlobalClusterRequest): FailoverGlobalClusterResponse {
        val op = SdkHttpOperation.build<FailoverGlobalClusterRequest, FailoverGlobalClusterResponse> {
            serializeWith = FailoverGlobalClusterOperationSerializer()
            deserializeWith = FailoverGlobalClusterOperationDeserializer()
            operationName = "FailoverGlobalCluster"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all tags on an Amazon RDS resource.
     *
     * For an overview on tagging an Amazon RDS resource, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Tagging.html) in the *Amazon RDS User Guide*.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.ListTagsForResource.sample
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializeWith = ListTagsForResourceOperationSerializer()
            deserializeWith = ListTagsForResourceOperationDeserializer()
            operationName = "ListTagsForResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Changes the audit policy state of a database activity stream to either locked (default) or unlocked. A locked policy is read-only, whereas an unlocked policy is read/write. If your activity stream is started and locked, you can unlock it, customize your audit policy, and then lock your activity stream. Restarting the activity stream isn't required. For more information, see [ Modifying a database activity stream](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/DBActivityStreams.Modifying.html) in the *Amazon RDS User Guide*.
     *
     * This operation is supported for RDS for Oracle and Microsoft SQL Server.
     */
    override suspend fun modifyActivityStream(input: ModifyActivityStreamRequest): ModifyActivityStreamResponse {
        val op = SdkHttpOperation.build<ModifyActivityStreamRequest, ModifyActivityStreamResponse> {
            serializeWith = ModifyActivityStreamOperationSerializer()
            deserializeWith = ModifyActivityStreamOperationDeserializer()
            operationName = "ModifyActivityStream"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Override the system-default Secure Sockets Layer/Transport Layer Security (SSL/TLS) certificate for Amazon RDS for new DB instances, or remove the override.
     *
     * By using this operation, you can specify an RDS-approved SSL/TLS certificate for new DB instances that is different from the default certificate provided by RDS. You can also use this operation to remove the override, so that new DB instances use the default certificate provided by RDS.
     *
     * You might need to override the default certificate in the following situations:
     * + You already migrated your applications to support the latest certificate authority (CA) certificate, but the new CA certificate is not yet the RDS default CA certificate for the specified Amazon Web Services Region.
     * + RDS has already moved to a new default CA certificate for the specified Amazon Web Services Region, but you are still in the process of supporting the new CA certificate. In this case, you temporarily need additional time to finish your application changes.
     *
     * For more information about rotating your SSL/TLS certificate for RDS DB engines, see [ Rotating Your SSL/TLS Certificate](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL-certificate-rotation.html) in the *Amazon RDS User Guide*.
     *
     * For more information about rotating your SSL/TLS certificate for Aurora DB engines, see [ Rotating Your SSL/TLS Certificate](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html) in the *Amazon Aurora User Guide*.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.ModifyCertificates.sample
     */
    override suspend fun modifyCertificates(input: ModifyCertificatesRequest): ModifyCertificatesResponse {
        val op = SdkHttpOperation.build<ModifyCertificatesRequest, ModifyCertificatesResponse> {
            serializeWith = ModifyCertificatesOperationSerializer()
            deserializeWith = ModifyCertificatesOperationDeserializer()
            operationName = "ModifyCertificates"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Set the capacity of an Aurora Serverless v1 DB cluster to a specific value.
     *
     * Aurora Serverless v1 scales seamlessly based on the workload on the DB cluster. In some cases, the capacity might not scale fast enough to meet a sudden change in workload, such as a large number of new transactions. Call `ModifyCurrentDBClusterCapacity` to set the capacity explicitly.
     *
     * After this call sets the DB cluster capacity, Aurora Serverless v1 can automatically scale the DB cluster based on the cooldown period for scaling up and the cooldown period for scaling down.
     *
     * For more information about Aurora Serverless v1, see [Using Amazon Aurora Serverless v1](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html) in the *Amazon Aurora User Guide*.
     *
     * If you call `ModifyCurrentDBClusterCapacity` with the default `TimeoutAction`, connections that prevent Aurora Serverless v1 from finding a scaling point might be dropped. For more information about scaling points, see [ Autoscaling for Aurora Serverless v1](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.auto-scaling) in the *Amazon Aurora User Guide*.
     *
     * This operation only applies to Aurora Serverless v1 DB clusters.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.ModifyCurrentDBClusterCapacity.sample
     */
    override suspend fun modifyCurrentDbClusterCapacity(input: ModifyCurrentDbClusterCapacityRequest): ModifyCurrentDbClusterCapacityResponse {
        val op = SdkHttpOperation.build<ModifyCurrentDbClusterCapacityRequest, ModifyCurrentDbClusterCapacityResponse> {
            serializeWith = ModifyCurrentDBClusterCapacityOperationSerializer()
            deserializeWith = ModifyCurrentDBClusterCapacityOperationDeserializer()
            operationName = "ModifyCurrentDBClusterCapacity"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the status of a custom engine version (CEV). You can find CEVs to modify by calling `DescribeDBEngineVersions`.
     *
     * The MediaImport service that imports files from Amazon S3 to create CEVs isn't integrated with Amazon Web Services CloudTrail. If you turn on data logging for Amazon RDS in CloudTrail, calls to the `ModifyCustomDbEngineVersion` event aren't logged. However, you might see calls from the API gateway that accesses your Amazon S3 bucket. These calls originate from the MediaImport service for the `ModifyCustomDbEngineVersion` event.
     *
     * For more information, see [Modifying CEV status](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.modify) in the *Amazon RDS User Guide*.
     */
    override suspend fun modifyCustomDbEngineVersion(input: ModifyCustomDbEngineVersionRequest): ModifyCustomDbEngineVersionResponse {
        val op = SdkHttpOperation.build<ModifyCustomDbEngineVersionRequest, ModifyCustomDbEngineVersionResponse> {
            serializeWith = ModifyCustomDBEngineVersionOperationSerializer()
            deserializeWith = ModifyCustomDBEngineVersionOperationDeserializer()
            operationName = "ModifyCustomDBEngineVersion"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the settings of an Amazon Aurora DB cluster or a Multi-AZ DB cluster. You can change one or more settings by specifying these parameters and the new values in the request.
     *
     * For more information on Amazon Aurora DB clusters, see [ What is Amazon Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html) in the *Amazon Aurora User Guide*.
     *
     * For more information on Multi-AZ DB clusters, see [ Multi-AZ DB cluster deployments](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html) in the *Amazon RDS User Guide*.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.ModifyDBCluster.sample
     */
    override suspend fun modifyDbCluster(input: ModifyDbClusterRequest): ModifyDbClusterResponse {
        val op = SdkHttpOperation.build<ModifyDbClusterRequest, ModifyDbClusterResponse> {
            serializeWith = ModifyDBClusterOperationSerializer()
            deserializeWith = ModifyDBClusterOperationDeserializer()
            operationName = "ModifyDBCluster"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the properties of an endpoint in an Amazon Aurora DB cluster.
     *
     * This operation only applies to Aurora DB clusters.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.ModifyDBClusterEndpoint.sample
     */
    override suspend fun modifyDbClusterEndpoint(input: ModifyDbClusterEndpointRequest): ModifyDbClusterEndpointResponse {
        val op = SdkHttpOperation.build<ModifyDbClusterEndpointRequest, ModifyDbClusterEndpointResponse> {
            serializeWith = ModifyDBClusterEndpointOperationSerializer()
            deserializeWith = ModifyDBClusterEndpointOperationDeserializer()
            operationName = "ModifyDBClusterEndpoint"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the parameters of a DB cluster parameter group. To modify more than one parameter, submit a list of the following: `ParameterName`, `ParameterValue`, and `ApplyMethod`. A maximum of 20 parameters can be modified in a single request.
     *
     * After you create a DB cluster parameter group, you should wait at least 5 minutes before creating your first DB cluster that uses that DB cluster parameter group as the default parameter group. This allows Amazon RDS to fully complete the create operation before the parameter group is used as the default for a new DB cluster. This is especially important for parameters that are critical when creating the default database for a DB cluster, such as the character set for the default database defined by the `character_set_database` parameter. You can use the *Parameter Groups* option of the [Amazon RDS console](https://console.aws.amazon.com/rds/) or the `DescribeDBClusterParameters` operation to verify that your DB cluster parameter group has been created or modified.
     *
     * If the modified DB cluster parameter group is used by an Aurora Serverless v1 cluster, Aurora applies the update immediately. The cluster restart might interrupt your workload. In that case, your application must reopen any connections and retry any transactions that were active when the parameter changes took effect.
     *
     * For more information on Amazon Aurora DB clusters, see [ What is Amazon Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html) in the *Amazon Aurora User Guide*.
     *
     * For more information on Multi-AZ DB clusters, see [ Multi-AZ DB cluster deployments](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html) in the *Amazon RDS User Guide.*
     *
     * @sample aws.sdk.kotlin.services.rds.samples.ModifyDBClusterParameterGroup.sample
     */
    override suspend fun modifyDbClusterParameterGroup(input: ModifyDbClusterParameterGroupRequest): ModifyDbClusterParameterGroupResponse {
        val op = SdkHttpOperation.build<ModifyDbClusterParameterGroupRequest, ModifyDbClusterParameterGroupResponse> {
            serializeWith = ModifyDBClusterParameterGroupOperationSerializer()
            deserializeWith = ModifyDBClusterParameterGroupOperationDeserializer()
            operationName = "ModifyDBClusterParameterGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds an attribute and values to, or removes an attribute and values from, a manual DB cluster snapshot.
     *
     * To share a manual DB cluster snapshot with other Amazon Web Services accounts, specify `restore` as the `AttributeName` and use the `ValuesToAdd` parameter to add a list of IDs of the Amazon Web Services accounts that are authorized to restore the manual DB cluster snapshot. Use the value `all` to make the manual DB cluster snapshot public, which means that it can be copied or restored by all Amazon Web Services accounts.
     *
     * Don't add the `all` value for any manual DB cluster snapshots that contain private information that you don't want available to all Amazon Web Services accounts.
     *
     * If a manual DB cluster snapshot is encrypted, it can be shared, but only by specifying a list of authorized Amazon Web Services account IDs for the `ValuesToAdd` parameter. You can't use `all` as a value for that parameter in this case.
     *
     * To view which Amazon Web Services accounts have access to copy or restore a manual DB cluster snapshot, or whether a manual DB cluster snapshot is public or private, use the DescribeDBClusterSnapshotAttributes API operation. The accounts are returned as values for the `restore` attribute.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.ModifyDBClusterSnapshotAttribute.sample
     */
    override suspend fun modifyDbClusterSnapshotAttribute(input: ModifyDbClusterSnapshotAttributeRequest): ModifyDbClusterSnapshotAttributeResponse {
        val op = SdkHttpOperation.build<ModifyDbClusterSnapshotAttributeRequest, ModifyDbClusterSnapshotAttributeResponse> {
            serializeWith = ModifyDBClusterSnapshotAttributeOperationSerializer()
            deserializeWith = ModifyDBClusterSnapshotAttributeOperationDeserializer()
            operationName = "ModifyDBClusterSnapshotAttribute"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies settings for a DB instance. You can change one or more database configuration parameters by specifying these parameters and the new values in the request. To learn what modifications you can make to your DB instance, call `DescribeValidDBInstanceModifications` before you call `ModifyDBInstance`.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.ModifyDBInstance.sample
     */
    override suspend fun modifyDbInstance(input: ModifyDbInstanceRequest): ModifyDbInstanceResponse {
        val op = SdkHttpOperation.build<ModifyDbInstanceRequest, ModifyDbInstanceResponse> {
            serializeWith = ModifyDBInstanceOperationSerializer()
            deserializeWith = ModifyDBInstanceOperationDeserializer()
            operationName = "ModifyDBInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the parameters of a DB parameter group. To modify more than one parameter, submit a list of the following: `ParameterName`, `ParameterValue`, and `ApplyMethod`. A maximum of 20 parameters can be modified in a single request.
     *
     * After you modify a DB parameter group, you should wait at least 5 minutes before creating your first DB instance that uses that DB parameter group as the default parameter group. This allows Amazon RDS to fully complete the modify operation before the parameter group is used as the default for a new DB instance. This is especially important for parameters that are critical when creating the default database for a DB instance, such as the character set for the default database defined by the `character_set_database` parameter. You can use the *Parameter Groups* option of the [Amazon RDS console](https://console.aws.amazon.com/rds/) or the *DescribeDBParameters* command to verify that your DB parameter group has been created or modified.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.ModifyDBParameterGroup.sample
     */
    override suspend fun modifyDbParameterGroup(input: ModifyDbParameterGroupRequest): ModifyDbParameterGroupResponse {
        val op = SdkHttpOperation.build<ModifyDbParameterGroupRequest, ModifyDbParameterGroupResponse> {
            serializeWith = ModifyDBParameterGroupOperationSerializer()
            deserializeWith = ModifyDBParameterGroupOperationDeserializer()
            operationName = "ModifyDBParameterGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Changes the settings for an existing DB proxy.
     */
    override suspend fun modifyDbProxy(input: ModifyDbProxyRequest): ModifyDbProxyResponse {
        val op = SdkHttpOperation.build<ModifyDbProxyRequest, ModifyDbProxyResponse> {
            serializeWith = ModifyDBProxyOperationSerializer()
            deserializeWith = ModifyDBProxyOperationDeserializer()
            operationName = "ModifyDBProxy"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Changes the settings for an existing DB proxy endpoint.
     */
    override suspend fun modifyDbProxyEndpoint(input: ModifyDbProxyEndpointRequest): ModifyDbProxyEndpointResponse {
        val op = SdkHttpOperation.build<ModifyDbProxyEndpointRequest, ModifyDbProxyEndpointResponse> {
            serializeWith = ModifyDBProxyEndpointOperationSerializer()
            deserializeWith = ModifyDBProxyEndpointOperationDeserializer()
            operationName = "ModifyDBProxyEndpoint"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the properties of a `DBProxyTargetGroup`.
     */
    override suspend fun modifyDbProxyTargetGroup(input: ModifyDbProxyTargetGroupRequest): ModifyDbProxyTargetGroupResponse {
        val op = SdkHttpOperation.build<ModifyDbProxyTargetGroupRequest, ModifyDbProxyTargetGroupResponse> {
            serializeWith = ModifyDBProxyTargetGroupOperationSerializer()
            deserializeWith = ModifyDBProxyTargetGroupOperationDeserializer()
            operationName = "ModifyDBProxyTargetGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the recommendation status and recommended action status for the specified recommendation.
     */
    override suspend fun modifyDbRecommendation(input: ModifyDbRecommendationRequest): ModifyDbRecommendationResponse {
        val op = SdkHttpOperation.build<ModifyDbRecommendationRequest, ModifyDbRecommendationResponse> {
            serializeWith = ModifyDBRecommendationOperationSerializer()
            deserializeWith = ModifyDBRecommendationOperationDeserializer()
            operationName = "ModifyDBRecommendation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the settings of an Aurora Limitless Database DB shard group. You can change one or more settings by specifying these parameters and the new values in the request.
     */
    override suspend fun modifyDbShardGroup(input: ModifyDbShardGroupRequest): ModifyDbShardGroupResponse {
        val op = SdkHttpOperation.build<ModifyDbShardGroupRequest, ModifyDbShardGroupResponse> {
            serializeWith = ModifyDBShardGroupOperationSerializer()
            deserializeWith = ModifyDBShardGroupOperationDeserializer()
            operationName = "ModifyDBShardGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a manual DB snapshot with a new engine version. The snapshot can be encrypted or unencrypted, but not shared or public.
     *
     * Amazon RDS supports upgrading DB snapshots for MySQL, PostgreSQL, and Oracle. This operation doesn't apply to RDS Custom or RDS for Db2.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.ModifyDBSnapshot.sample
     */
    override suspend fun modifyDbSnapshot(input: ModifyDbSnapshotRequest): ModifyDbSnapshotResponse {
        val op = SdkHttpOperation.build<ModifyDbSnapshotRequest, ModifyDbSnapshotResponse> {
            serializeWith = ModifyDBSnapshotOperationSerializer()
            deserializeWith = ModifyDBSnapshotOperationDeserializer()
            operationName = "ModifyDBSnapshot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds an attribute and values to, or removes an attribute and values from, a manual DB snapshot.
     *
     * To share a manual DB snapshot with other Amazon Web Services accounts, specify `restore` as the `AttributeName` and use the `ValuesToAdd` parameter to add a list of IDs of the Amazon Web Services accounts that are authorized to restore the manual DB snapshot. Uses the value `all` to make the manual DB snapshot public, which means it can be copied or restored by all Amazon Web Services accounts.
     *
     * Don't add the `all` value for any manual DB snapshots that contain private information that you don't want available to all Amazon Web Services accounts.
     *
     * If the manual DB snapshot is encrypted, it can be shared, but only by specifying a list of authorized Amazon Web Services account IDs for the `ValuesToAdd` parameter. You can't use `all` as a value for that parameter in this case.
     *
     * To view which Amazon Web Services accounts have access to copy or restore a manual DB snapshot, or whether a manual DB snapshot public or private, use the DescribeDBSnapshotAttributes API operation. The accounts are returned as values for the `restore` attribute.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.ModifyDBSnapshotAttribute.sample
     * @sample aws.sdk.kotlin.services.rds.samples.ModifyDBSnapshotAttribute.sample2
     */
    override suspend fun modifyDbSnapshotAttribute(input: ModifyDbSnapshotAttributeRequest): ModifyDbSnapshotAttributeResponse {
        val op = SdkHttpOperation.build<ModifyDbSnapshotAttributeRequest, ModifyDbSnapshotAttributeResponse> {
            serializeWith = ModifyDBSnapshotAttributeOperationSerializer()
            deserializeWith = ModifyDBSnapshotAttributeOperationDeserializer()
            operationName = "ModifyDBSnapshotAttribute"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies an existing DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in the Amazon Web Services Region.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.ModifyDBSubnetGroup.sample
     */
    override suspend fun modifyDbSubnetGroup(input: ModifyDbSubnetGroupRequest): ModifyDbSubnetGroupResponse {
        val op = SdkHttpOperation.build<ModifyDbSubnetGroupRequest, ModifyDbSubnetGroupResponse> {
            serializeWith = ModifyDBSubnetGroupOperationSerializer()
            deserializeWith = ModifyDBSubnetGroupOperationDeserializer()
            operationName = "ModifyDBSubnetGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies an existing RDS event notification subscription. You can't modify the source identifiers using this call. To change source identifiers for a subscription, use the `AddSourceIdentifierToSubscription` and `RemoveSourceIdentifierFromSubscription` calls.
     *
     * You can see a list of the event categories for a given source type (`SourceType`) in [Events](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html) in the *Amazon RDS User Guide* or by using the `DescribeEventCategories` operation.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.ModifyEventSubscription.sample
     */
    override suspend fun modifyEventSubscription(input: ModifyEventSubscriptionRequest): ModifyEventSubscriptionResponse {
        val op = SdkHttpOperation.build<ModifyEventSubscriptionRequest, ModifyEventSubscriptionResponse> {
            serializeWith = ModifyEventSubscriptionOperationSerializer()
            deserializeWith = ModifyEventSubscriptionOperationDeserializer()
            operationName = "ModifyEventSubscription"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies a setting for an Amazon Aurora global database cluster. You can change one or more database configuration parameters by specifying these parameters and the new values in the request. For more information on Amazon Aurora, see [ What is Amazon Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html) in the *Amazon Aurora User Guide*.
     *
     * This operation only applies to Aurora global database clusters.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.ModifyGlobalCluster.sample
     */
    override suspend fun modifyGlobalCluster(input: ModifyGlobalClusterRequest): ModifyGlobalClusterResponse {
        val op = SdkHttpOperation.build<ModifyGlobalClusterRequest, ModifyGlobalClusterResponse> {
            serializeWith = ModifyGlobalClusterOperationSerializer()
            deserializeWith = ModifyGlobalClusterOperationDeserializer()
            operationName = "ModifyGlobalCluster"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies a zero-ETL integration with Amazon Redshift.
     *
     * Currently, you can only modify integrations that have Aurora MySQL source DB clusters. Integrations with Aurora PostgreSQL and RDS sources currently don't support modifying the integration.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.ModifyIntegration.sample
     */
    override suspend fun modifyIntegration(input: ModifyIntegrationRequest): ModifyIntegrationResponse {
        val op = SdkHttpOperation.build<ModifyIntegrationRequest, ModifyIntegrationResponse> {
            serializeWith = ModifyIntegrationOperationSerializer()
            deserializeWith = ModifyIntegrationOperationDeserializer()
            operationName = "ModifyIntegration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies an existing option group.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.ModifyOptionGroup.sample
     */
    override suspend fun modifyOptionGroup(input: ModifyOptionGroupRequest): ModifyOptionGroupResponse {
        val op = SdkHttpOperation.build<ModifyOptionGroupRequest, ModifyOptionGroupResponse> {
            serializeWith = ModifyOptionGroupOperationSerializer()
            deserializeWith = ModifyOptionGroupOperationDeserializer()
            operationName = "ModifyOptionGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies an existing tenant database in a DB instance. You can change the tenant database name or the master user password. This operation is supported only for RDS for Oracle CDB instances using the multi-tenant configuration.
     */
    override suspend fun modifyTenantDatabase(input: ModifyTenantDatabaseRequest): ModifyTenantDatabaseResponse {
        val op = SdkHttpOperation.build<ModifyTenantDatabaseRequest, ModifyTenantDatabaseResponse> {
            serializeWith = ModifyTenantDatabaseOperationSerializer()
            deserializeWith = ModifyTenantDatabaseOperationDeserializer()
            operationName = "ModifyTenantDatabase"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Promotes a read replica DB instance to a standalone DB instance.
     *
     * + Backup duration is a function of the amount of changes to the database since the previous backup. If you plan to promote a read replica to a standalone instance, we recommend that you enable backups and complete at least one backup prior to promotion. In addition, a read replica cannot be promoted to a standalone instance when it is in the `backing-up` status. If you have enabled backups on your read replica, configure the automated backup window so that daily backups do not interfere with read replica promotion.
     * + This command doesn't apply to Aurora MySQL, Aurora PostgreSQL, or RDS Custom.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.PromoteReadReplica.sample
     */
    override suspend fun promoteReadReplica(input: PromoteReadReplicaRequest): PromoteReadReplicaResponse {
        val op = SdkHttpOperation.build<PromoteReadReplicaRequest, PromoteReadReplicaResponse> {
            serializeWith = PromoteReadReplicaOperationSerializer()
            deserializeWith = PromoteReadReplicaOperationDeserializer()
            operationName = "PromoteReadReplica"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Promotes a read replica DB cluster to a standalone DB cluster.
     */
    override suspend fun promoteReadReplicaDbCluster(input: PromoteReadReplicaDbClusterRequest): PromoteReadReplicaDbClusterResponse {
        val op = SdkHttpOperation.build<PromoteReadReplicaDbClusterRequest, PromoteReadReplicaDbClusterResponse> {
            serializeWith = PromoteReadReplicaDBClusterOperationSerializer()
            deserializeWith = PromoteReadReplicaDBClusterOperationDeserializer()
            operationName = "PromoteReadReplicaDBCluster"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Purchases a reserved DB instance offering.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.PurchaseReservedDBInstancesOffering.sample
     */
    override suspend fun purchaseReservedDbInstancesOffering(input: PurchaseReservedDbInstancesOfferingRequest): PurchaseReservedDbInstancesOfferingResponse {
        val op = SdkHttpOperation.build<PurchaseReservedDbInstancesOfferingRequest, PurchaseReservedDbInstancesOfferingResponse> {
            serializeWith = PurchaseReservedDBInstancesOfferingOperationSerializer()
            deserializeWith = PurchaseReservedDBInstancesOfferingOperationDeserializer()
            operationName = "PurchaseReservedDBInstancesOffering"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * You might need to reboot your DB cluster, usually for maintenance reasons. For example, if you make certain modifications, or if you change the DB cluster parameter group associated with the DB cluster, reboot the DB cluster for the changes to take effect.
     *
     * Rebooting a DB cluster restarts the database engine service. Rebooting a DB cluster results in a momentary outage, during which the DB cluster status is set to rebooting.
     *
     * Use this operation only for a non-Aurora Multi-AZ DB cluster.
     *
     * For more information on Multi-AZ DB clusters, see [ Multi-AZ DB cluster deployments](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html) in the *Amazon RDS User Guide.*
     */
    override suspend fun rebootDbCluster(input: RebootDbClusterRequest): RebootDbClusterResponse {
        val op = SdkHttpOperation.build<RebootDbClusterRequest, RebootDbClusterResponse> {
            serializeWith = RebootDBClusterOperationSerializer()
            deserializeWith = RebootDBClusterOperationDeserializer()
            operationName = "RebootDBCluster"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * You might need to reboot your DB instance, usually for maintenance reasons. For example, if you make certain modifications, or if you change the DB parameter group associated with the DB instance, you must reboot the instance for the changes to take effect.
     *
     * Rebooting a DB instance restarts the database engine service. Rebooting a DB instance results in a momentary outage, during which the DB instance status is set to rebooting.
     *
     * For more information about rebooting, see [Rebooting a DB Instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_RebootInstance.html) in the *Amazon RDS User Guide.*
     *
     * This command doesn't apply to RDS Custom.
     *
     * If your DB instance is part of a Multi-AZ DB cluster, you can reboot the DB cluster with the `RebootDBCluster` operation.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.RebootDBInstance.sample
     */
    override suspend fun rebootDbInstance(input: RebootDbInstanceRequest): RebootDbInstanceResponse {
        val op = SdkHttpOperation.build<RebootDbInstanceRequest, RebootDbInstanceResponse> {
            serializeWith = RebootDBInstanceOperationSerializer()
            deserializeWith = RebootDBInstanceOperationDeserializer()
            operationName = "RebootDBInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * You might need to reboot your DB shard group, usually for maintenance reasons. For example, if you make certain modifications, reboot the DB shard group for the changes to take effect.
     *
     * This operation applies only to Aurora Limitless Database DBb shard groups.
     */
    override suspend fun rebootDbShardGroup(input: RebootDbShardGroupRequest): RebootDbShardGroupResponse {
        val op = SdkHttpOperation.build<RebootDbShardGroupRequest, RebootDbShardGroupResponse> {
            serializeWith = RebootDBShardGroupOperationSerializer()
            deserializeWith = RebootDBShardGroupOperationDeserializer()
            operationName = "RebootDBShardGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associate one or more `DBProxyTarget` data structures with a `DBProxyTargetGroup`.
     */
    override suspend fun registerDbProxyTargets(input: RegisterDbProxyTargetsRequest): RegisterDbProxyTargetsResponse {
        val op = SdkHttpOperation.build<RegisterDbProxyTargetsRequest, RegisterDbProxyTargetsResponse> {
            serializeWith = RegisterDBProxyTargetsOperationSerializer()
            deserializeWith = RegisterDBProxyTargetsOperationDeserializer()
            operationName = "RegisterDBProxyTargets"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Detaches an Aurora secondary cluster from an Aurora global database cluster. The cluster becomes a standalone cluster with read-write capability instead of being read-only and receiving data from a primary cluster in a different Region.
     *
     * This operation only applies to Aurora DB clusters.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.RemoveFromGlobalCluster.sample
     */
    override suspend fun removeFromGlobalCluster(input: RemoveFromGlobalClusterRequest): RemoveFromGlobalClusterResponse {
        val op = SdkHttpOperation.build<RemoveFromGlobalClusterRequest, RemoveFromGlobalClusterResponse> {
            serializeWith = RemoveFromGlobalClusterOperationSerializer()
            deserializeWith = RemoveFromGlobalClusterOperationDeserializer()
            operationName = "RemoveFromGlobalCluster"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes the asssociation of an Amazon Web Services Identity and Access Management (IAM) role from a DB cluster.
     *
     * For more information on Amazon Aurora DB clusters, see [ What is Amazon Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html) in the *Amazon Aurora User Guide*.
     *
     * For more information on Multi-AZ DB clusters, see [ Multi-AZ DB cluster deployments](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html) in the *Amazon RDS User Guide.*
     *
     * @sample aws.sdk.kotlin.services.rds.samples.RemoveRoleFromDBCluster.sample
     */
    override suspend fun removeRoleFromDbCluster(input: RemoveRoleFromDbClusterRequest): RemoveRoleFromDbClusterResponse {
        val op = SdkHttpOperation.build<RemoveRoleFromDbClusterRequest, RemoveRoleFromDbClusterResponse> {
            serializeWith = RemoveRoleFromDBClusterOperationSerializer()
            deserializeWith = RemoveRoleFromDBClusterOperationDeserializer()
            operationName = "RemoveRoleFromDBCluster"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates an Amazon Web Services Identity and Access Management (IAM) role from a DB instance.
     */
    override suspend fun removeRoleFromDbInstance(input: RemoveRoleFromDbInstanceRequest): RemoveRoleFromDbInstanceResponse {
        val op = SdkHttpOperation.build<RemoveRoleFromDbInstanceRequest, RemoveRoleFromDbInstanceResponse> {
            serializeWith = RemoveRoleFromDBInstanceOperationSerializer()
            deserializeWith = RemoveRoleFromDBInstanceOperationDeserializer()
            operationName = "RemoveRoleFromDBInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes a source identifier from an existing RDS event notification subscription.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.RemoveSourceIdentifierFromSubscription.sample
     */
    override suspend fun removeSourceIdentifierFromSubscription(input: RemoveSourceIdentifierFromSubscriptionRequest): RemoveSourceIdentifierFromSubscriptionResponse {
        val op = SdkHttpOperation.build<RemoveSourceIdentifierFromSubscriptionRequest, RemoveSourceIdentifierFromSubscriptionResponse> {
            serializeWith = RemoveSourceIdentifierFromSubscriptionOperationSerializer()
            deserializeWith = RemoveSourceIdentifierFromSubscriptionOperationDeserializer()
            operationName = "RemoveSourceIdentifierFromSubscription"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes metadata tags from an Amazon RDS resource.
     *
     * For an overview on tagging an Amazon RDS resource, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Tagging.html) in the *Amazon RDS User Guide.*
     *
     * @sample aws.sdk.kotlin.services.rds.samples.RemoveTagsFromResource.sample
     */
    override suspend fun removeTagsFromResource(input: RemoveTagsFromResourceRequest): RemoveTagsFromResourceResponse {
        val op = SdkHttpOperation.build<RemoveTagsFromResourceRequest, RemoveTagsFromResourceResponse> {
            serializeWith = RemoveTagsFromResourceOperationSerializer()
            deserializeWith = RemoveTagsFromResourceOperationDeserializer()
            operationName = "RemoveTagsFromResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the parameters of a DB cluster parameter group to the default value. To reset specific parameters submit a list of the following: `ParameterName` and `ApplyMethod`. To reset the entire DB cluster parameter group, specify the `DBClusterParameterGroupName` and `ResetAllParameters` parameters.
     *
     * When resetting the entire group, dynamic parameters are updated immediately and static parameters are set to `pending-reboot` to take effect on the next DB instance restart or `RebootDBInstance` request. You must call `RebootDBInstance` for every DB instance in your DB cluster that you want the updated static parameter to apply to.
     *
     * For more information on Amazon Aurora DB clusters, see [ What is Amazon Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html) in the *Amazon Aurora User Guide*.
     *
     * For more information on Multi-AZ DB clusters, see [ Multi-AZ DB cluster deployments](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html) in the *Amazon RDS User Guide.*
     *
     * @sample aws.sdk.kotlin.services.rds.samples.ResetDBClusterParameterGroup.sample
     */
    override suspend fun resetDbClusterParameterGroup(input: ResetDbClusterParameterGroupRequest): ResetDbClusterParameterGroupResponse {
        val op = SdkHttpOperation.build<ResetDbClusterParameterGroupRequest, ResetDbClusterParameterGroupResponse> {
            serializeWith = ResetDBClusterParameterGroupOperationSerializer()
            deserializeWith = ResetDBClusterParameterGroupOperationDeserializer()
            operationName = "ResetDBClusterParameterGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the parameters of a DB parameter group to the engine/system default value. To reset specific parameters, provide a list of the following: `ParameterName` and `ApplyMethod`. To reset the entire DB parameter group, specify the `DBParameterGroup` name and `ResetAllParameters` parameters. When resetting the entire group, dynamic parameters are updated immediately and static parameters are set to `pending-reboot` to take effect on the next DB instance restart or `RebootDBInstance` request.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.ResetDBParameterGroup.sample
     */
    override suspend fun resetDbParameterGroup(input: ResetDbParameterGroupRequest): ResetDbParameterGroupResponse {
        val op = SdkHttpOperation.build<ResetDbParameterGroupRequest, ResetDbParameterGroupResponse> {
            serializeWith = ResetDBParameterGroupOperationSerializer()
            deserializeWith = ResetDBParameterGroupOperationDeserializer()
            operationName = "ResetDBParameterGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Amazon Aurora DB cluster from MySQL data stored in an Amazon S3 bucket. Amazon RDS must be authorized to access the Amazon S3 bucket and the data must be created using the Percona XtraBackup utility as described in [ Migrating Data from MySQL by Using an Amazon S3 Bucket](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Migrating.ExtMySQL.html#AuroraMySQL.Migrating.ExtMySQL.S3) in the *Amazon Aurora User Guide*.
     *
     * This operation only restores the DB cluster, not the DB instances for that DB cluster. You must invoke the `CreateDBInstance` operation to create DB instances for the restored DB cluster, specifying the identifier of the restored DB cluster in `DBClusterIdentifier`. You can create DB instances only after the `RestoreDBClusterFromS3` operation has completed and the DB cluster is available.
     *
     * For more information on Amazon Aurora, see [ What is Amazon Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html) in the *Amazon Aurora User Guide*.
     *
     * This operation only applies to Aurora DB clusters. The source DB engine must be MySQL.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.RestoreDBClusterFromS3.sample
     */
    override suspend fun restoreDbClusterFromS3(input: RestoreDbClusterFromS3Request): RestoreDbClusterFromS3Response {
        val op = SdkHttpOperation.build<RestoreDbClusterFromS3Request, RestoreDbClusterFromS3Response> {
            serializeWith = RestoreDBClusterFromS3OperationSerializer()
            deserializeWith = RestoreDBClusterFromS3OperationDeserializer()
            operationName = "RestoreDBClusterFromS3"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new DB cluster from a DB snapshot or DB cluster snapshot.
     *
     * The target DB cluster is created from the source snapshot with a default configuration. If you don't specify a security group, the new DB cluster is associated with the default security group.
     *
     * This operation only restores the DB cluster, not the DB instances for that DB cluster. You must invoke the `CreateDBInstance` operation to create DB instances for the restored DB cluster, specifying the identifier of the restored DB cluster in `DBClusterIdentifier`. You can create DB instances only after the `RestoreDBClusterFromSnapshot` operation has completed and the DB cluster is available.
     *
     * For more information on Amazon Aurora DB clusters, see [ What is Amazon Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html) in the *Amazon Aurora User Guide*.
     *
     * For more information on Multi-AZ DB clusters, see [ Multi-AZ DB cluster deployments](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html) in the *Amazon RDS User Guide.*
     *
     * @sample aws.sdk.kotlin.services.rds.samples.RestoreDBClusterFromSnapshot.sample
     */
    override suspend fun restoreDbClusterFromSnapshot(input: RestoreDbClusterFromSnapshotRequest): RestoreDbClusterFromSnapshotResponse {
        val op = SdkHttpOperation.build<RestoreDbClusterFromSnapshotRequest, RestoreDbClusterFromSnapshotResponse> {
            serializeWith = RestoreDBClusterFromSnapshotOperationSerializer()
            deserializeWith = RestoreDBClusterFromSnapshotOperationDeserializer()
            operationName = "RestoreDBClusterFromSnapshot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Restores a DB cluster to an arbitrary point in time. Users can restore to any point in time before `LatestRestorableTime` for up to `BackupRetentionPeriod` days. The target DB cluster is created from the source DB cluster with the same configuration as the original DB cluster, except that the new DB cluster is created with the default DB security group.
     *
     * For Aurora, this operation only restores the DB cluster, not the DB instances for that DB cluster. You must invoke the `CreateDBInstance` operation to create DB instances for the restored DB cluster, specifying the identifier of the restored DB cluster in `DBClusterIdentifier`. You can create DB instances only after the `RestoreDBClusterToPointInTime` operation has completed and the DB cluster is available.
     *
     * For more information on Amazon Aurora DB clusters, see [ What is Amazon Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html) in the *Amazon Aurora User Guide*.
     *
     * For more information on Multi-AZ DB clusters, see [ Multi-AZ DB cluster deployments](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html) in the *Amazon RDS User Guide.*
     *
     * @sample aws.sdk.kotlin.services.rds.samples.RestoreDBClusterToPointInTime.sample
     */
    override suspend fun restoreDbClusterToPointInTime(input: RestoreDbClusterToPointInTimeRequest): RestoreDbClusterToPointInTimeResponse {
        val op = SdkHttpOperation.build<RestoreDbClusterToPointInTimeRequest, RestoreDbClusterToPointInTimeResponse> {
            serializeWith = RestoreDBClusterToPointInTimeOperationSerializer()
            deserializeWith = RestoreDBClusterToPointInTimeOperationDeserializer()
            operationName = "RestoreDBClusterToPointInTime"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new DB instance from a DB snapshot. The target database is created from the source database restore point with most of the source's original configuration, including the default security group and DB parameter group. By default, the new DB instance is created as a Single-AZ deployment, except when the instance is a SQL Server instance that has an option group associated with mirroring. In this case, the instance becomes a Multi-AZ deployment, not a Single-AZ deployment.
     *
     * If you want to replace your original DB instance with the new, restored DB instance, then rename your original DB instance before you call the `RestoreDBInstanceFromDBSnapshot` operation. RDS doesn't allow two DB instances with the same name. After you have renamed your original DB instance with a different identifier, then you can pass the original name of the DB instance as the `DBInstanceIdentifier` in the call to the `RestoreDBInstanceFromDBSnapshot` operation. The result is that you replace the original DB instance with the DB instance created from the snapshot.
     *
     * If you are restoring from a shared manual DB snapshot, the `DBSnapshotIdentifier` must be the ARN of the shared DB snapshot.
     *
     * This command doesn't apply to Aurora MySQL and Aurora PostgreSQL. For Aurora, use `RestoreDBClusterFromSnapshot`.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.RestoreDBInstanceFromDBSnapshot.sample
     */
    override suspend fun restoreDbInstanceFromDbSnapshot(input: RestoreDbInstanceFromDbSnapshotRequest): RestoreDbInstanceFromDbSnapshotResponse {
        val op = SdkHttpOperation.build<RestoreDbInstanceFromDbSnapshotRequest, RestoreDbInstanceFromDbSnapshotResponse> {
            serializeWith = RestoreDBInstanceFromDBSnapshotOperationSerializer()
            deserializeWith = RestoreDBInstanceFromDBSnapshotOperationDeserializer()
            operationName = "RestoreDBInstanceFromDBSnapshot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Amazon Relational Database Service (Amazon RDS) supports importing MySQL databases by using backup files. You can create a backup of your on-premises database, store it on Amazon Simple Storage Service (Amazon S3), and then restore the backup file onto a new Amazon RDS DB instance running MySQL. For more information, see [Importing Data into an Amazon RDS MySQL DB Instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/MySQL.Procedural.Importing.html) in the *Amazon RDS User Guide.*
     *
     * This operation doesn't apply to RDS Custom.
     */
    override suspend fun restoreDbInstanceFromS3(input: RestoreDbInstanceFromS3Request): RestoreDbInstanceFromS3Response {
        val op = SdkHttpOperation.build<RestoreDbInstanceFromS3Request, RestoreDbInstanceFromS3Response> {
            serializeWith = RestoreDBInstanceFromS3OperationSerializer()
            deserializeWith = RestoreDBInstanceFromS3OperationDeserializer()
            operationName = "RestoreDBInstanceFromS3"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Restores a DB instance to an arbitrary point in time. You can restore to any point in time before the time identified by the `LatestRestorableTime` property. You can restore to a point up to the number of days specified by the `BackupRetentionPeriod` property.
     *
     * The target database is created with most of the original configuration, but in a system-selected Availability Zone, with the default security group, the default subnet group, and the default DB parameter group. By default, the new DB instance is created as a single-AZ deployment except when the instance is a SQL Server instance that has an option group that is associated with mirroring; in this case, the instance becomes a mirrored deployment and not a single-AZ deployment.
     *
     * This operation doesn't apply to Aurora MySQL and Aurora PostgreSQL. For Aurora, use `RestoreDBClusterToPointInTime`.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.RestoreDBInstanceToPointInTime.sample
     */
    override suspend fun restoreDbInstanceToPointInTime(input: RestoreDbInstanceToPointInTimeRequest): RestoreDbInstanceToPointInTimeResponse {
        val op = SdkHttpOperation.build<RestoreDbInstanceToPointInTimeRequest, RestoreDbInstanceToPointInTimeResponse> {
            serializeWith = RestoreDBInstanceToPointInTimeOperationSerializer()
            deserializeWith = RestoreDBInstanceToPointInTimeOperationDeserializer()
            operationName = "RestoreDBInstanceToPointInTime"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Revokes ingress from a DBSecurityGroup for previously authorized IP ranges or EC2 or VPC security groups. Required parameters for this API are one of CIDRIP, EC2SecurityGroupId for VPC, or (EC2SecurityGroupOwnerId and either EC2SecurityGroupName or EC2SecurityGroupId).
     *
     * EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we recommend that you migrate as soon as possible. For more information, see [Migrate from EC2-Classic to a VPC](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html) in the *Amazon EC2 User Guide*, the blog [EC2-Classic Networking is Retiring – Here’s How to Prepare](http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/), and [Moving a DB instance not in a VPC into a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html) in the *Amazon RDS User Guide*.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.RevokeDBSecurityGroupIngress.sample
     */
    override suspend fun revokeDbSecurityGroupIngress(input: RevokeDbSecurityGroupIngressRequest): RevokeDbSecurityGroupIngressResponse {
        val op = SdkHttpOperation.build<RevokeDbSecurityGroupIngressRequest, RevokeDbSecurityGroupIngressResponse> {
            serializeWith = RevokeDBSecurityGroupIngressOperationSerializer()
            deserializeWith = RevokeDBSecurityGroupIngressOperationDeserializer()
            operationName = "RevokeDBSecurityGroupIngress"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Starts a database activity stream to monitor activity on the database. For more information, see [ Monitoring Amazon Aurora with Database Activity Streams](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/DBActivityStreams.html) in the *Amazon Aurora User Guide* or [ Monitoring Amazon RDS with Database Activity Streams](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/DBActivityStreams.html) in the *Amazon RDS User Guide*.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.StartActivityStream.sample
     */
    override suspend fun startActivityStream(input: StartActivityStreamRequest): StartActivityStreamResponse {
        val op = SdkHttpOperation.build<StartActivityStreamRequest, StartActivityStreamResponse> {
            serializeWith = StartActivityStreamOperationSerializer()
            deserializeWith = StartActivityStreamOperationDeserializer()
            operationName = "StartActivityStream"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Starts an Amazon Aurora DB cluster that was stopped using the Amazon Web Services console, the stop-db-cluster CLI command, or the `StopDBCluster` operation.
     *
     * For more information, see [ Stopping and Starting an Aurora Cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-cluster-stop-start.html) in the *Amazon Aurora User Guide*.
     *
     * This operation only applies to Aurora DB clusters.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.StartDBCluster.sample
     */
    override suspend fun startDbCluster(input: StartDbClusterRequest): StartDbClusterResponse {
        val op = SdkHttpOperation.build<StartDbClusterRequest, StartDbClusterResponse> {
            serializeWith = StartDBClusterOperationSerializer()
            deserializeWith = StartDBClusterOperationDeserializer()
            operationName = "StartDBCluster"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Starts an Amazon RDS DB instance that was stopped using the Amazon Web Services console, the stop-db-instance CLI command, or the `StopDBInstance` operation.
     *
     * For more information, see [ Starting an Amazon RDS DB instance That Was Previously Stopped](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_StartInstance.html) in the *Amazon RDS User Guide.*
     *
     * This command doesn't apply to RDS Custom, Aurora MySQL, and Aurora PostgreSQL. For Aurora DB clusters, use `StartDBCluster` instead.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.StartDBInstance.sample
     */
    override suspend fun startDbInstance(input: StartDbInstanceRequest): StartDbInstanceResponse {
        val op = SdkHttpOperation.build<StartDbInstanceRequest, StartDbInstanceResponse> {
            serializeWith = StartDBInstanceOperationSerializer()
            deserializeWith = StartDBInstanceOperationDeserializer()
            operationName = "StartDBInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Enables replication of automated backups to a different Amazon Web Services Region.
     *
     * This command doesn't apply to RDS Custom.
     *
     * For more information, see [ Replicating Automated Backups to Another Amazon Web Services Region](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ReplicateBackups.html) in the *Amazon RDS User Guide.*
     *
     * @sample aws.sdk.kotlin.services.rds.samples.StartDBInstanceAutomatedBackupsReplication.sample
     */
    override suspend fun startDbInstanceAutomatedBackupsReplication(input: StartDbInstanceAutomatedBackupsReplicationRequest): StartDbInstanceAutomatedBackupsReplicationResponse {
        val op = SdkHttpOperation.build<StartDbInstanceAutomatedBackupsReplicationRequest, StartDbInstanceAutomatedBackupsReplicationResponse> {
            serializeWith = StartDBInstanceAutomatedBackupsReplicationOperationSerializer()
            deserializeWith = StartDBInstanceAutomatedBackupsReplicationOperationDeserializer()
            operationName = "StartDBInstanceAutomatedBackupsReplication"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Starts an export of DB snapshot or DB cluster data to Amazon S3. The provided IAM role must have access to the S3 bucket.
     *
     * You can't export snapshot data from Db2 or RDS Custom DB instances.
     *
     * You can't export cluster data from Multi-AZ DB clusters.
     *
     * For more information on exporting DB snapshot data, see [Exporting DB snapshot data to Amazon S3](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ExportSnapshot.html) in the *Amazon RDS User Guide* or [Exporting DB cluster snapshot data to Amazon S3](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-export-snapshot.html) in the *Amazon Aurora User Guide*.
     *
     * For more information on exporting DB cluster data, see [Exporting DB cluster data to Amazon S3](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/export-cluster-data.html) in the *Amazon Aurora User Guide*.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.StartExportTask.sample
     */
    override suspend fun startExportTask(input: StartExportTaskRequest): StartExportTaskResponse {
        val op = SdkHttpOperation.build<StartExportTaskRequest, StartExportTaskResponse> {
            serializeWith = StartExportTaskOperationSerializer()
            deserializeWith = StartExportTaskOperationDeserializer()
            operationName = "StartExportTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Stops a database activity stream that was started using the Amazon Web Services console, the `start-activity-stream` CLI command, or the `StartActivityStream` operation.
     *
     * For more information, see [ Monitoring Amazon Aurora with Database Activity Streams](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/DBActivityStreams.html) in the *Amazon Aurora User Guide* or [ Monitoring Amazon RDS with Database Activity Streams](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/DBActivityStreams.html) in the *Amazon RDS User Guide*.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.StopActivityStream.sample
     */
    override suspend fun stopActivityStream(input: StopActivityStreamRequest): StopActivityStreamResponse {
        val op = SdkHttpOperation.build<StopActivityStreamRequest, StopActivityStreamResponse> {
            serializeWith = StopActivityStreamOperationSerializer()
            deserializeWith = StopActivityStreamOperationDeserializer()
            operationName = "StopActivityStream"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Stops an Amazon Aurora DB cluster. When you stop a DB cluster, Aurora retains the DB cluster's metadata, including its endpoints and DB parameter groups. Aurora also retains the transaction logs so you can do a point-in-time restore if necessary.
     *
     * For more information, see [ Stopping and Starting an Aurora Cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-cluster-stop-start.html) in the *Amazon Aurora User Guide*.
     *
     * This operation only applies to Aurora DB clusters.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.StopDBCluster.sample
     */
    override suspend fun stopDbCluster(input: StopDbClusterRequest): StopDbClusterResponse {
        val op = SdkHttpOperation.build<StopDbClusterRequest, StopDbClusterResponse> {
            serializeWith = StopDBClusterOperationSerializer()
            deserializeWith = StopDBClusterOperationDeserializer()
            operationName = "StopDBCluster"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Stops an Amazon RDS DB instance. When you stop a DB instance, Amazon RDS retains the DB instance's metadata, including its endpoint, DB parameter group, and option group membership. Amazon RDS also retains the transaction logs so you can do a point-in-time restore if necessary.
     *
     * For more information, see [ Stopping an Amazon RDS DB Instance Temporarily](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_StopInstance.html) in the *Amazon RDS User Guide.*
     *
     * This command doesn't apply to RDS Custom, Aurora MySQL, and Aurora PostgreSQL. For Aurora clusters, use `StopDBCluster` instead.
     *
     * @sample aws.sdk.kotlin.services.rds.samples.StopDBInstance.sample
     */
    override suspend fun stopDbInstance(input: StopDbInstanceRequest): StopDbInstanceResponse {
        val op = SdkHttpOperation.build<StopDbInstanceRequest, StopDbInstanceResponse> {
            serializeWith = StopDBInstanceOperationSerializer()
            deserializeWith = StopDBInstanceOperationDeserializer()
            operationName = "StopDBInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Stops automated backup replication for a DB instance.
     *
     * This command doesn't apply to RDS Custom, Aurora MySQL, and Aurora PostgreSQL.
     *
     * For more information, see [ Replicating Automated Backups to Another Amazon Web Services Region](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ReplicateBackups.html) in the *Amazon RDS User Guide.*
     *
     * @sample aws.sdk.kotlin.services.rds.samples.StopDBInstanceAutomatedBackupsReplication.sample
     */
    override suspend fun stopDbInstanceAutomatedBackupsReplication(input: StopDbInstanceAutomatedBackupsReplicationRequest): StopDbInstanceAutomatedBackupsReplicationResponse {
        val op = SdkHttpOperation.build<StopDbInstanceAutomatedBackupsReplicationRequest, StopDbInstanceAutomatedBackupsReplicationResponse> {
            serializeWith = StopDBInstanceAutomatedBackupsReplicationOperationSerializer()
            deserializeWith = StopDBInstanceAutomatedBackupsReplicationOperationDeserializer()
            operationName = "StopDBInstanceAutomatedBackupsReplication"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Switches over a blue/green deployment.
     *
     * Before you switch over, production traffic is routed to the databases in the blue environment. After you switch over, production traffic is routed to the databases in the green environment.
     *
     * For more information, see [Using Amazon RDS Blue/Green Deployments for database updates](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html) in the *Amazon RDS User Guide* and [Using Amazon RDS Blue/Green Deployments for database updates](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html) in the *Amazon Aurora User Guide*.
     */
    override suspend fun switchoverBlueGreenDeployment(input: SwitchoverBlueGreenDeploymentRequest): SwitchoverBlueGreenDeploymentResponse {
        val op = SdkHttpOperation.build<SwitchoverBlueGreenDeploymentRequest, SwitchoverBlueGreenDeploymentResponse> {
            serializeWith = SwitchoverBlueGreenDeploymentOperationSerializer()
            deserializeWith = SwitchoverBlueGreenDeploymentOperationDeserializer()
            operationName = "SwitchoverBlueGreenDeployment"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Switches over the specified secondary DB cluster to be the new primary DB cluster in the global database cluster. Switchover operations were previously called "managed planned failovers."
     *
     * Aurora promotes the specified secondary cluster to assume full read/write capabilities and demotes the current primary cluster to a secondary (read-only) cluster, maintaining the orginal replication topology. All secondary clusters are synchronized with the primary at the beginning of the process so the new primary continues operations for the Aurora global database without losing any data. Your database is unavailable for a short time while the primary and selected secondary clusters are assuming their new roles. For more information about switching over an Aurora global database, see [Performing switchovers for Amazon Aurora global databases](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database-disaster-recovery.html#aurora-global-database-disaster-recovery.managed-failover) in the *Amazon Aurora User Guide*.
     *
     * This operation is intended for controlled environments, for operations such as "regional rotation" or to fall back to the original primary after a global database failover.
     */
    override suspend fun switchoverGlobalCluster(input: SwitchoverGlobalClusterRequest): SwitchoverGlobalClusterResponse {
        val op = SdkHttpOperation.build<SwitchoverGlobalClusterRequest, SwitchoverGlobalClusterResponse> {
            serializeWith = SwitchoverGlobalClusterOperationSerializer()
            deserializeWith = SwitchoverGlobalClusterOperationDeserializer()
            operationName = "SwitchoverGlobalCluster"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Switches over an Oracle standby database in an Oracle Data Guard environment, making it the new primary database. Issue this command in the Region that hosts the current standby database.
     */
    override suspend fun switchoverReadReplica(input: SwitchoverReadReplicaRequest): SwitchoverReadReplicaResponse {
        val op = SdkHttpOperation.build<SwitchoverReadReplicaRequest, SwitchoverReadReplicaResponse> {
            serializeWith = SwitchoverReadReplicaOperationSerializer()
            deserializeWith = SwitchoverReadReplicaOperationDeserializer()
            operationName = "SwitchoverReadReplica"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsentNotNull(AwsAttributes.Region, config.region)
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "rds")
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }

}
