// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.BlueGreenDeployment
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.sdk.kotlin.services.rds.model.SwitchoverBlueGreenDeploymentResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class SwitchoverBlueGreenDeploymentOperationDeserializer: HttpDeserialize<SwitchoverBlueGreenDeploymentResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): SwitchoverBlueGreenDeploymentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwSwitchoverBlueGreenDeploymentError(context, call)
        }
        val builder = SwitchoverBlueGreenDeploymentResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeSwitchoverBlueGreenDeploymentOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwSwitchoverBlueGreenDeploymentError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BlueGreenDeploymentNotFoundFault" -> BlueGreenDeploymentNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidBlueGreenDeploymentStateFault" -> InvalidBlueGreenDeploymentStateFaultDeserializer().deserialize(context, wrappedCall)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeSwitchoverBlueGreenDeploymentOperationBody(builder: SwitchoverBlueGreenDeploymentResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "SwitchoverBlueGreenDeployment")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // BlueGreenDeployment com.amazonaws.rds#SwitchoverBlueGreenDeploymentResponse$BlueGreenDeployment
            "BlueGreenDeployment" -> builder.blueGreenDeployment = deserializeBlueGreenDeploymentDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
