// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.ExportSourceType
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.sdk.kotlin.services.rds.model.StartExportTaskResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class StartExportTaskOperationDeserializer: HttpDeserialize<StartExportTaskResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): StartExportTaskResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwStartExportTaskError(context, call)
        }
        val builder = StartExportTaskResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeStartExportTaskOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwStartExportTaskError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBClusterNotFoundFault" -> DbClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidExportSourceState" -> InvalidExportSourceStateFaultDeserializer().deserialize(context, wrappedCall)
        "KMSKeyNotAccessibleFault" -> KmsKeyNotAccessibleFaultDeserializer().deserialize(context, wrappedCall)
        "IamRoleNotFound" -> IamRoleNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "DBClusterSnapshotNotFoundFault" -> DbClusterSnapshotNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidS3BucketFault" -> InvalidS3BucketFaultDeserializer().deserialize(context, wrappedCall)
        "ExportTaskAlreadyExists" -> ExportTaskAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall)
        "DBSnapshotNotFound" -> DbSnapshotNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "IamRoleMissingPermissions" -> IamRoleMissingPermissionsFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidExportOnly" -> InvalidExportOnlyFaultDeserializer().deserialize(context, wrappedCall)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeStartExportTaskOperationBody(builder: StartExportTaskResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "StartExportTask")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // ExportOnly com.amazonaws.rds#ExportTask$ExportOnly
            "ExportOnly" -> builder.exportOnly = deserializeStringListShape(curr)
            // ExportTaskIdentifier com.amazonaws.rds#ExportTask$ExportTaskIdentifier
            "ExportTaskIdentifier" -> builder.exportTaskIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // FailureCause com.amazonaws.rds#ExportTask$FailureCause
            "FailureCause" -> builder.failureCause = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // IamRoleArn com.amazonaws.rds#ExportTask$IamRoleArn
            "IamRoleArn" -> builder.iamRoleArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // KmsKeyId com.amazonaws.rds#ExportTask$KmsKeyId
            "KmsKeyId" -> builder.kmsKeyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // PercentProgress com.amazonaws.rds#ExportTask$PercentProgress
            "PercentProgress" -> builder.percentProgress = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#Integer`)" }
            // S3Bucket com.amazonaws.rds#ExportTask$S3Bucket
            "S3Bucket" -> builder.s3Bucket = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // S3Prefix com.amazonaws.rds#ExportTask$S3Prefix
            "S3Prefix" -> builder.s3Prefix = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // SnapshotTime com.amazonaws.rds#ExportTask$SnapshotTime
            "SnapshotTime" -> builder.snapshotTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // SourceArn com.amazonaws.rds#ExportTask$SourceArn
            "SourceArn" -> builder.sourceArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // SourceType com.amazonaws.rds#ExportTask$SourceType
            "SourceType" -> builder.sourceType = curr.tryData()
                .parse { ExportSourceType.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.rds#ExportSourceType`)" }
            // Status com.amazonaws.rds#ExportTask$Status
            "Status" -> builder.status = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // TaskEndTime com.amazonaws.rds#ExportTask$TaskEndTime
            "TaskEndTime" -> builder.taskEndTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // TaskStartTime com.amazonaws.rds#ExportTask$TaskStartTime
            "TaskStartTime" -> builder.taskStartTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // TotalExtractedDataInGB com.amazonaws.rds#ExportTask$TotalExtractedDataInGB
            "TotalExtractedDataInGB" -> builder.totalExtractedDataInGb = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#Integer`)" }
            // WarningMessage com.amazonaws.rds#ExportTask$WarningMessage
            "WarningMessage" -> builder.warningMessage = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            else -> {}
        }
        curr.drop()
    }
}
