// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.DbInstance
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.sdk.kotlin.services.rds.model.RestoreDbInstanceToPointInTimeResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class RestoreDBInstanceToPointInTimeOperationDeserializer: HttpDeserialize<RestoreDbInstanceToPointInTimeResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): RestoreDbInstanceToPointInTimeResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwRestoreDbInstanceToPointInTimeError(context, call)
        }
        val builder = RestoreDbInstanceToPointInTimeResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeRestoreDBInstanceToPointInTimeOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwRestoreDbInstanceToPointInTimeError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBSubnetGroupDoesNotCoverEnoughAZs" -> DbSubnetGroupDoesNotCoverEnoughAzsDeserializer().deserialize(context, wrappedCall)
        "DBSubnetGroupNotFoundFault" -> DbSubnetGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "DBInstanceAutomatedBackupNotFound" -> DbInstanceAutomatedBackupNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "InstanceQuotaExceeded" -> InstanceQuotaExceededFaultDeserializer().deserialize(context, wrappedCall)
        "OptionGroupNotFoundFault" -> OptionGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidVPCNetworkStateFault" -> InvalidVpcNetworkStateFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidSubnet" -> InvalidSubnetDeserializer().deserialize(context, wrappedCall)
        "TenantDatabaseQuotaExceeded" -> TenantDatabaseQuotaExceededFaultDeserializer().deserialize(context, wrappedCall)
        "InsufficientDBInstanceCapacity" -> InsufficientDbInstanceCapacityFaultDeserializer().deserialize(context, wrappedCall)
        "DBSecurityGroupNotFound" -> DbSecurityGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "AuthorizationNotFound" -> AuthorizationNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "BackupPolicyNotFoundFault" -> BackupPolicyNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidRestoreFault" -> InvalidRestoreFaultDeserializer().deserialize(context, wrappedCall)
        "PointInTimeRestoreNotEnabled" -> PointInTimeRestoreNotEnabledFaultDeserializer().deserialize(context, wrappedCall)
        "KMSKeyNotAccessibleFault" -> KmsKeyNotAccessibleFaultDeserializer().deserialize(context, wrappedCall)
        "StorageQuotaExceeded" -> StorageQuotaExceededFaultDeserializer().deserialize(context, wrappedCall)
        "DBInstanceAlreadyExists" -> DbInstanceAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidDBInstanceState" -> InvalidDbInstanceStateFaultDeserializer().deserialize(context, wrappedCall)
        "NetworkTypeNotSupported" -> NetworkTypeNotSupportedDeserializer().deserialize(context, wrappedCall)
        "DBInstanceNotFound" -> DbInstanceNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "DomainNotFoundFault" -> DomainNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "ProvisionedIopsNotAvailableInAZFault" -> ProvisionedIopsNotAvailableInAzFaultDeserializer().deserialize(context, wrappedCall)
        "StorageTypeNotSupported" -> StorageTypeNotSupportedFaultDeserializer().deserialize(context, wrappedCall)
        "DBParameterGroupNotFound" -> DbParameterGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRestoreDBInstanceToPointInTimeOperationBody(builder: RestoreDbInstanceToPointInTimeResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "RestoreDBInstanceToPointInTime")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBInstance com.amazonaws.rds#RestoreDBInstanceToPointInTimeResult$DBInstance
            "DBInstance" -> builder.dbInstance = deserializeDbInstanceDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
