// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.EventSubscription
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.sdk.kotlin.services.rds.model.RemoveSourceIdentifierFromSubscriptionResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class RemoveSourceIdentifierFromSubscriptionOperationDeserializer: HttpDeserialize<RemoveSourceIdentifierFromSubscriptionResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): RemoveSourceIdentifierFromSubscriptionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwRemoveSourceIdentifierFromSubscriptionError(context, call)
        }
        val builder = RemoveSourceIdentifierFromSubscriptionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeRemoveSourceIdentifierFromSubscriptionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwRemoveSourceIdentifierFromSubscriptionError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "SubscriptionNotFound" -> SubscriptionNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "SourceNotFound" -> SourceNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRemoveSourceIdentifierFromSubscriptionOperationBody(builder: RemoveSourceIdentifierFromSubscriptionResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "RemoveSourceIdentifierFromSubscription")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // EventSubscription com.amazonaws.rds#RemoveSourceIdentifierFromSubscriptionResult$EventSubscription
            "EventSubscription" -> builder.eventSubscription = deserializeEventSubscriptionDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
