// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.PurchaseReservedDbInstancesOfferingResponse
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.sdk.kotlin.services.rds.model.ReservedDbInstance
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class PurchaseReservedDBInstancesOfferingOperationDeserializer: HttpDeserialize<PurchaseReservedDbInstancesOfferingResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): PurchaseReservedDbInstancesOfferingResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPurchaseReservedDbInstancesOfferingError(context, call)
        }
        val builder = PurchaseReservedDbInstancesOfferingResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePurchaseReservedDBInstancesOfferingOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwPurchaseReservedDbInstancesOfferingError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ReservedDBInstanceAlreadyExists" -> ReservedDbInstanceAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall)
        "ReservedDBInstancesOfferingNotFound" -> ReservedDbInstancesOfferingNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "ReservedDBInstanceQuotaExceeded" -> ReservedDbInstanceQuotaExceededFaultDeserializer().deserialize(context, wrappedCall)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePurchaseReservedDBInstancesOfferingOperationBody(builder: PurchaseReservedDbInstancesOfferingResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "PurchaseReservedDBInstancesOffering")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // ReservedDBInstance com.amazonaws.rds#PurchaseReservedDBInstancesOfferingResult$ReservedDBInstance
            "ReservedDBInstance" -> builder.reservedDbInstance = deserializeReservedDbInstanceDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
