// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.EventSubscription
import aws.sdk.kotlin.services.rds.model.ModifyEventSubscriptionResponse
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class ModifyEventSubscriptionOperationDeserializer: HttpDeserialize<ModifyEventSubscriptionResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ModifyEventSubscriptionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwModifyEventSubscriptionError(context, call)
        }
        val builder = ModifyEventSubscriptionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeModifyEventSubscriptionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwModifyEventSubscriptionError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "SubscriptionNotFound" -> SubscriptionNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "SNSInvalidTopic" -> SnsInvalidTopicFaultDeserializer().deserialize(context, wrappedCall)
        "SubscriptionCategoryNotFound" -> SubscriptionCategoryNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "SNSNoAuthorization" -> SnsNoAuthorizationFaultDeserializer().deserialize(context, wrappedCall)
        "SNSTopicArnNotFound" -> SnsTopicArnNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "EventSubscriptionQuotaExceeded" -> EventSubscriptionQuotaExceededFaultDeserializer().deserialize(context, wrappedCall)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeModifyEventSubscriptionOperationBody(builder: ModifyEventSubscriptionResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "ModifyEventSubscription")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // EventSubscription com.amazonaws.rds#ModifyEventSubscriptionResult$EventSubscription
            "EventSubscription" -> builder.eventSubscription = deserializeEventSubscriptionDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
