// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.DbSnapshotAttributesResult
import aws.sdk.kotlin.services.rds.model.ModifyDbSnapshotAttributeResponse
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class ModifyDBSnapshotAttributeOperationDeserializer: HttpDeserialize<ModifyDbSnapshotAttributeResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ModifyDbSnapshotAttributeResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwModifyDbSnapshotAttributeError(context, call)
        }
        val builder = ModifyDbSnapshotAttributeResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeModifyDBSnapshotAttributeOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwModifyDbSnapshotAttributeError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "SharedSnapshotQuotaExceeded" -> SharedSnapshotQuotaExceededFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidDBSnapshotState" -> InvalidDbSnapshotStateFaultDeserializer().deserialize(context, wrappedCall)
        "DBSnapshotNotFound" -> DbSnapshotNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeModifyDBSnapshotAttributeOperationBody(builder: ModifyDbSnapshotAttributeResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "ModifyDBSnapshotAttribute")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBSnapshotAttributesResult com.amazonaws.rds#ModifyDBSnapshotAttributeResult$DBSnapshotAttributesResult
            "DBSnapshotAttributesResult" -> builder.dbSnapshotAttributesResult = deserializeDbSnapshotAttributesResultDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
