// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.DbProxyTargetGroup
import aws.sdk.kotlin.services.rds.model.ModifyDbProxyTargetGroupResponse
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class ModifyDBProxyTargetGroupOperationDeserializer: HttpDeserialize<ModifyDbProxyTargetGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ModifyDbProxyTargetGroupResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwModifyDbProxyTargetGroupError(context, call)
        }
        val builder = ModifyDbProxyTargetGroupResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeModifyDBProxyTargetGroupOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwModifyDbProxyTargetGroupError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBProxyTargetGroupNotFoundFault" -> DbProxyTargetGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "DBProxyNotFoundFault" -> DbProxyNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidDBProxyStateFault" -> InvalidDbProxyStateFaultDeserializer().deserialize(context, wrappedCall)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeModifyDBProxyTargetGroupOperationBody(builder: ModifyDbProxyTargetGroupResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "ModifyDBProxyTargetGroup")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBProxyTargetGroup com.amazonaws.rds#ModifyDBProxyTargetGroupResponse$DBProxyTargetGroup
            "DBProxyTargetGroup" -> builder.dbProxyTargetGroup = deserializeDbProxyTargetGroupDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
