// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.ModifyCurrentDbClusterCapacityResponse
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class ModifyCurrentDBClusterCapacityOperationDeserializer: HttpDeserialize<ModifyCurrentDbClusterCapacityResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ModifyCurrentDbClusterCapacityResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwModifyCurrentDbClusterCapacityError(context, call)
        }
        val builder = ModifyCurrentDbClusterCapacityResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeModifyCurrentDBClusterCapacityOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwModifyCurrentDbClusterCapacityError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBClusterNotFoundFault" -> DbClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidDBClusterCapacityFault" -> InvalidDbClusterCapacityFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidDBClusterStateFault" -> InvalidDbClusterStateFaultDeserializer().deserialize(context, wrappedCall)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeModifyCurrentDBClusterCapacityOperationBody(builder: ModifyCurrentDbClusterCapacityResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "ModifyCurrentDBClusterCapacity")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // CurrentCapacity com.amazonaws.rds#DBClusterCapacityInfo$CurrentCapacity
            "CurrentCapacity" -> builder.currentCapacity = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#IntegerOptional`)" }
            // DBClusterIdentifier com.amazonaws.rds#DBClusterCapacityInfo$DBClusterIdentifier
            "DBClusterIdentifier" -> builder.dbClusterIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // PendingCapacity com.amazonaws.rds#DBClusterCapacityInfo$PendingCapacity
            "PendingCapacity" -> builder.pendingCapacity = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#IntegerOptional`)" }
            // SecondsBeforeTimeout com.amazonaws.rds#DBClusterCapacityInfo$SecondsBeforeTimeout
            "SecondsBeforeTimeout" -> builder.secondsBeforeTimeout = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#IntegerOptional`)" }
            // TimeoutAction com.amazonaws.rds#DBClusterCapacityInfo$TimeoutAction
            "TimeoutAction" -> builder.timeoutAction = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            else -> {}
        }
        curr.drop()
    }
}
