// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.ActivityStreamMode
import aws.sdk.kotlin.services.rds.model.ActivityStreamPolicyStatus
import aws.sdk.kotlin.services.rds.model.ActivityStreamStatus
import aws.sdk.kotlin.services.rds.model.ModifyActivityStreamResponse
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class ModifyActivityStreamOperationDeserializer: HttpDeserialize<ModifyActivityStreamResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ModifyActivityStreamResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwModifyActivityStreamError(context, call)
        }
        val builder = ModifyActivityStreamResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeModifyActivityStreamOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwModifyActivityStreamError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBInstanceNotFound" -> DbInstanceNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidDBInstanceState" -> InvalidDbInstanceStateFaultDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundFault" -> ResourceNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeModifyActivityStreamOperationBody(builder: ModifyActivityStreamResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "ModifyActivityStream")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // EngineNativeAuditFieldsIncluded com.amazonaws.rds#ModifyActivityStreamResponse$EngineNativeAuditFieldsIncluded
            "EngineNativeAuditFieldsIncluded" -> builder.engineNativeAuditFieldsIncluded = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#BooleanOptional`)" }
            // KinesisStreamName com.amazonaws.rds#ModifyActivityStreamResponse$KinesisStreamName
            "KinesisStreamName" -> builder.kinesisStreamName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // KmsKeyId com.amazonaws.rds#ModifyActivityStreamResponse$KmsKeyId
            "KmsKeyId" -> builder.kmsKeyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // Mode com.amazonaws.rds#ModifyActivityStreamResponse$Mode
            "Mode" -> builder.mode = curr.tryData()
                .parse { ActivityStreamMode.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.rds#ActivityStreamMode`)" }
            // PolicyStatus com.amazonaws.rds#ModifyActivityStreamResponse$PolicyStatus
            "PolicyStatus" -> builder.policyStatus = curr.tryData()
                .parse { ActivityStreamPolicyStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.rds#ActivityStreamPolicyStatus`)" }
            // Status com.amazonaws.rds#ModifyActivityStreamResponse$Status
            "Status" -> builder.status = curr.tryData()
                .parse { ActivityStreamStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.rds#ActivityStreamStatus`)" }
            else -> {}
        }
        curr.drop()
    }
}
