// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.ExportSourceType
import aws.sdk.kotlin.services.rds.model.ExportTask
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeExportTaskDocument(reader: XmlTagReader): ExportTask {
    val builder = ExportTask.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // ExportTaskIdentifier com.amazonaws.rds#ExportTask$ExportTaskIdentifier
            "ExportTaskIdentifier" -> builder.exportTaskIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // SourceArn com.amazonaws.rds#ExportTask$SourceArn
            "SourceArn" -> builder.sourceArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // ExportOnly com.amazonaws.rds#ExportTask$ExportOnly
            "ExportOnly" -> builder.exportOnly = deserializeStringListShape(curr)
            // SnapshotTime com.amazonaws.rds#ExportTask$SnapshotTime
            "SnapshotTime" -> builder.snapshotTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // TaskStartTime com.amazonaws.rds#ExportTask$TaskStartTime
            "TaskStartTime" -> builder.taskStartTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // TaskEndTime com.amazonaws.rds#ExportTask$TaskEndTime
            "TaskEndTime" -> builder.taskEndTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // S3Bucket com.amazonaws.rds#ExportTask$S3Bucket
            "S3Bucket" -> builder.s3Bucket = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // S3Prefix com.amazonaws.rds#ExportTask$S3Prefix
            "S3Prefix" -> builder.s3Prefix = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // IamRoleArn com.amazonaws.rds#ExportTask$IamRoleArn
            "IamRoleArn" -> builder.iamRoleArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // KmsKeyId com.amazonaws.rds#ExportTask$KmsKeyId
            "KmsKeyId" -> builder.kmsKeyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // Status com.amazonaws.rds#ExportTask$Status
            "Status" -> builder.status = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // PercentProgress com.amazonaws.rds#ExportTask$PercentProgress
            "PercentProgress" -> builder.percentProgress = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#Integer`)" }
            // TotalExtractedDataInGB com.amazonaws.rds#ExportTask$TotalExtractedDataInGB
            "TotalExtractedDataInGB" -> builder.totalExtractedDataInGb = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#Integer`)" }
            // FailureCause com.amazonaws.rds#ExportTask$FailureCause
            "FailureCause" -> builder.failureCause = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // WarningMessage com.amazonaws.rds#ExportTask$WarningMessage
            "WarningMessage" -> builder.warningMessage = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // SourceType com.amazonaws.rds#ExportTask$SourceType
            "SourceType" -> builder.sourceType = curr.tryData()
                .parse { ExportSourceType.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.rds#ExportSourceType`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
