// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.DbProxyEndpoint
import aws.sdk.kotlin.services.rds.model.DescribeDbProxyEndpointsResponse
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class DescribeDBProxyEndpointsOperationDeserializer: HttpDeserialize<DescribeDbProxyEndpointsResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeDbProxyEndpointsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeDbProxyEndpointsError(context, call)
        }
        val builder = DescribeDbProxyEndpointsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeDBProxyEndpointsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeDbProxyEndpointsError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBProxyNotFoundFault" -> DbProxyNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "DBProxyEndpointNotFoundFault" -> DbProxyEndpointNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeDBProxyEndpointsOperationBody(builder: DescribeDbProxyEndpointsResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "DescribeDBProxyEndpoints")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBProxyEndpoints com.amazonaws.rds#DescribeDBProxyEndpointsResponse$DBProxyEndpoints
            "DBProxyEndpoints" -> builder.dbProxyEndpoints = deserializeDBProxyEndpointListShape(curr)
            // Marker com.amazonaws.rds#DescribeDBProxyEndpointsResponse$Marker
            "Marker" -> builder.marker = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            else -> {}
        }
        curr.drop()
    }
}
