// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.DbClusterEndpoint
import aws.sdk.kotlin.services.rds.model.DescribeDbClusterEndpointsResponse
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class DescribeDBClusterEndpointsOperationDeserializer: HttpDeserialize<DescribeDbClusterEndpointsResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeDbClusterEndpointsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeDbClusterEndpointsError(context, call)
        }
        val builder = DescribeDbClusterEndpointsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeDBClusterEndpointsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeDbClusterEndpointsError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBClusterNotFoundFault" -> DbClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeDBClusterEndpointsOperationBody(builder: DescribeDbClusterEndpointsResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "DescribeDBClusterEndpoints")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBClusterEndpoints com.amazonaws.rds#DBClusterEndpointMessage$DBClusterEndpoints
            "DBClusterEndpoints" -> builder.dbClusterEndpoints = deserializeDBClusterEndpointListShape(curr)
            // Marker com.amazonaws.rds#DBClusterEndpointMessage$Marker
            "Marker" -> builder.marker = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            else -> {}
        }
        curr.drop()
    }
}
