// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.CharacterSet
import aws.sdk.kotlin.services.rds.model.CustomDbEngineVersionAmi
import aws.sdk.kotlin.services.rds.model.DeleteCustomDbEngineVersionResponse
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.sdk.kotlin.services.rds.model.Tag
import aws.sdk.kotlin.services.rds.model.Timezone
import aws.sdk.kotlin.services.rds.model.UpgradeTarget
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DeleteCustomDBEngineVersionOperationDeserializer: HttpDeserialize<DeleteCustomDbEngineVersionResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DeleteCustomDbEngineVersionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteCustomDbEngineVersionError(context, call)
        }
        val builder = DeleteCustomDbEngineVersionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeleteCustomDBEngineVersionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDeleteCustomDbEngineVersionError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidCustomDBEngineVersionStateFault" -> InvalidCustomDbEngineVersionStateFaultDeserializer().deserialize(context, wrappedCall)
        "CustomDBEngineVersionNotFoundFault" -> CustomDbEngineVersionNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteCustomDBEngineVersionOperationBody(builder: DeleteCustomDbEngineVersionResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "DeleteCustomDBEngineVersion")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // CreateTime com.amazonaws.rds#DBEngineVersion$CreateTime
            "CreateTime" -> builder.createTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // CustomDBEngineVersionManifest com.amazonaws.rds#DBEngineVersion$CustomDBEngineVersionManifest
            "CustomDBEngineVersionManifest" -> builder.customDbEngineVersionManifest = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#CustomDBEngineVersionManifest`)" }
            // DBEngineDescription com.amazonaws.rds#DBEngineVersion$DBEngineDescription
            "DBEngineDescription" -> builder.dbEngineDescription = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DBEngineMediaType com.amazonaws.rds#DBEngineVersion$DBEngineMediaType
            "DBEngineMediaType" -> builder.dbEngineMediaType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DBEngineVersionArn com.amazonaws.rds#DBEngineVersion$DBEngineVersionArn
            "DBEngineVersionArn" -> builder.dbEngineVersionArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DBEngineVersionDescription com.amazonaws.rds#DBEngineVersion$DBEngineVersionDescription
            "DBEngineVersionDescription" -> builder.dbEngineVersionDescription = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DBParameterGroupFamily com.amazonaws.rds#DBEngineVersion$DBParameterGroupFamily
            "DBParameterGroupFamily" -> builder.dbParameterGroupFamily = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DatabaseInstallationFilesS3BucketName com.amazonaws.rds#DBEngineVersion$DatabaseInstallationFilesS3BucketName
            "DatabaseInstallationFilesS3BucketName" -> builder.databaseInstallationFilesS3BucketName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DatabaseInstallationFilesS3Prefix com.amazonaws.rds#DBEngineVersion$DatabaseInstallationFilesS3Prefix
            "DatabaseInstallationFilesS3Prefix" -> builder.databaseInstallationFilesS3Prefix = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DefaultCharacterSet com.amazonaws.rds#DBEngineVersion$DefaultCharacterSet
            "DefaultCharacterSet" -> builder.defaultCharacterSet = deserializeCharacterSetDocument(curr)
            // Engine com.amazonaws.rds#DBEngineVersion$Engine
            "Engine" -> builder.engine = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // EngineVersion com.amazonaws.rds#DBEngineVersion$EngineVersion
            "EngineVersion" -> builder.engineVersion = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // ExportableLogTypes com.amazonaws.rds#DBEngineVersion$ExportableLogTypes
            "ExportableLogTypes" -> builder.exportableLogTypes = deserializeLogTypeListShape(curr)
            // Image com.amazonaws.rds#DBEngineVersion$Image
            "Image" -> builder.image = deserializeCustomDbEngineVersionAmiDocument(curr)
            // KMSKeyId com.amazonaws.rds#DBEngineVersion$KMSKeyId
            "KMSKeyId" -> builder.kmsKeyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // MajorEngineVersion com.amazonaws.rds#DBEngineVersion$MajorEngineVersion
            "MajorEngineVersion" -> builder.majorEngineVersion = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // Status com.amazonaws.rds#DBEngineVersion$Status
            "Status" -> builder.status = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // SupportedCACertificateIdentifiers com.amazonaws.rds#DBEngineVersion$SupportedCACertificateIdentifiers
            "SupportedCACertificateIdentifiers" -> builder.supportedCaCertificateIdentifiers = deserializeCACertificateIdentifiersListShape(curr)
            // SupportedCharacterSets com.amazonaws.rds#DBEngineVersion$SupportedCharacterSets
            "SupportedCharacterSets" -> builder.supportedCharacterSets = deserializeSupportedCharacterSetsListShape(curr)
            // SupportedEngineModes com.amazonaws.rds#DBEngineVersion$SupportedEngineModes
            "SupportedEngineModes" -> builder.supportedEngineModes = deserializeEngineModeListShape(curr)
            // SupportedFeatureNames com.amazonaws.rds#DBEngineVersion$SupportedFeatureNames
            "SupportedFeatureNames" -> builder.supportedFeatureNames = deserializeFeatureNameListShape(curr)
            // SupportedNcharCharacterSets com.amazonaws.rds#DBEngineVersion$SupportedNcharCharacterSets
            "SupportedNcharCharacterSets" -> builder.supportedNcharCharacterSets = deserializeSupportedCharacterSetsListShape(curr)
            // SupportedTimezones com.amazonaws.rds#DBEngineVersion$SupportedTimezones
            "SupportedTimezones" -> builder.supportedTimezones = deserializeSupportedTimezonesListShape(curr)
            // SupportsBabelfish com.amazonaws.rds#DBEngineVersion$SupportsBabelfish
            "SupportsBabelfish" -> builder.supportsBabelfish = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#Boolean`)" }
            // SupportsCertificateRotationWithoutRestart com.amazonaws.rds#DBEngineVersion$SupportsCertificateRotationWithoutRestart
            "SupportsCertificateRotationWithoutRestart" -> builder.supportsCertificateRotationWithoutRestart = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#BooleanOptional`)" }
            // SupportsGlobalDatabases com.amazonaws.rds#DBEngineVersion$SupportsGlobalDatabases
            "SupportsGlobalDatabases" -> builder.supportsGlobalDatabases = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#Boolean`)" }
            // SupportsIntegrations com.amazonaws.rds#DBEngineVersion$SupportsIntegrations
            "SupportsIntegrations" -> builder.supportsIntegrations = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#Boolean`)" }
            // SupportsLocalWriteForwarding com.amazonaws.rds#DBEngineVersion$SupportsLocalWriteForwarding
            "SupportsLocalWriteForwarding" -> builder.supportsLocalWriteForwarding = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#BooleanOptional`)" }
            // SupportsLogExportsToCloudwatchLogs com.amazonaws.rds#DBEngineVersion$SupportsLogExportsToCloudwatchLogs
            "SupportsLogExportsToCloudwatchLogs" -> builder.supportsLogExportsToCloudwatchLogs = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#Boolean`)" }
            // SupportsParallelQuery com.amazonaws.rds#DBEngineVersion$SupportsParallelQuery
            "SupportsParallelQuery" -> builder.supportsParallelQuery = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#Boolean`)" }
            // SupportsReadReplica com.amazonaws.rds#DBEngineVersion$SupportsReadReplica
            "SupportsReadReplica" -> builder.supportsReadReplica = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#Boolean`)" }
            // TagList com.amazonaws.rds#DBEngineVersion$TagList
            "TagList" -> builder.tagList = deserializeTagListShape(curr)
            // ValidUpgradeTarget com.amazonaws.rds#DBEngineVersion$ValidUpgradeTarget
            "ValidUpgradeTarget" -> builder.validUpgradeTarget = deserializeValidUpgradeTargetListShape(curr)
            else -> {}
        }
        curr.drop()
    }
}
