// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.DbProxyTargetGroup
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeDbProxyTargetGroupDocument(reader: XmlTagReader): DbProxyTargetGroup {
    val builder = DbProxyTargetGroup.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBProxyName com.amazonaws.rds#DBProxyTargetGroup$DBProxyName
            "DBProxyName" -> builder.dbProxyName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // TargetGroupName com.amazonaws.rds#DBProxyTargetGroup$TargetGroupName
            "TargetGroupName" -> builder.targetGroupName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // TargetGroupArn com.amazonaws.rds#DBProxyTargetGroup$TargetGroupArn
            "TargetGroupArn" -> builder.targetGroupArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // IsDefault com.amazonaws.rds#DBProxyTargetGroup$IsDefault
            "IsDefault" -> builder.isDefault = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#Boolean`)" }
            // Status com.amazonaws.rds#DBProxyTargetGroup$Status
            "Status" -> builder.status = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // ConnectionPoolConfig com.amazonaws.rds#DBProxyTargetGroup$ConnectionPoolConfig
            "ConnectionPoolConfig" -> builder.connectionPoolConfig = deserializeConnectionPoolConfigurationInfoDocument(curr)
            // CreatedDate com.amazonaws.rds#DBProxyTargetGroup$CreatedDate
            "CreatedDate" -> builder.createdDate = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // UpdatedDate com.amazonaws.rds#DBProxyTargetGroup$UpdatedDate
            "UpdatedDate" -> builder.updatedDate = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
