// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.DbProxyTarget
import aws.sdk.kotlin.services.rds.model.TargetRole
import aws.sdk.kotlin.services.rds.model.TargetType
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData

internal fun deserializeDbProxyTargetDocument(reader: XmlTagReader): DbProxyTarget {
    val builder = DbProxyTarget.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // TargetArn com.amazonaws.rds#DBProxyTarget$TargetArn
            "TargetArn" -> builder.targetArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // Endpoint com.amazonaws.rds#DBProxyTarget$Endpoint
            "Endpoint" -> builder.endpoint = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // TrackedClusterId com.amazonaws.rds#DBProxyTarget$TrackedClusterId
            "TrackedClusterId" -> builder.trackedClusterId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // RdsResourceId com.amazonaws.rds#DBProxyTarget$RdsResourceId
            "RdsResourceId" -> builder.rdsResourceId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // Port com.amazonaws.rds#DBProxyTarget$Port
            "Port" -> builder.port = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#Integer`)" }
            // Type com.amazonaws.rds#DBProxyTarget$Type
            "Type" -> builder.type = curr.tryData()
                .parse { TargetType.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.rds#TargetType`)" }
            // Role com.amazonaws.rds#DBProxyTarget$Role
            "Role" -> builder.role = curr.tryData()
                .parse { TargetRole.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.rds#TargetRole`)" }
            // TargetHealth com.amazonaws.rds#DBProxyTarget$TargetHealth
            "TargetHealth" -> builder.targetHealth = deserializeTargetHealthDocument(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
