// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.CreateTenantDatabaseResponse
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.sdk.kotlin.services.rds.model.TenantDatabase
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CreateTenantDatabaseOperationDeserializer: HttpDeserialize<CreateTenantDatabaseResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateTenantDatabaseResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateTenantDatabaseError(context, call)
        }
        val builder = CreateTenantDatabaseResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateTenantDatabaseOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateTenantDatabaseError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "TenantDatabaseAlreadyExists" -> TenantDatabaseAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall)
        "DBInstanceNotFound" -> DbInstanceNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "TenantDatabaseQuotaExceeded" -> TenantDatabaseQuotaExceededFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidDBInstanceState" -> InvalidDbInstanceStateFaultDeserializer().deserialize(context, wrappedCall)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateTenantDatabaseOperationBody(builder: CreateTenantDatabaseResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateTenantDatabase")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // TenantDatabase com.amazonaws.rds#CreateTenantDatabaseResult$TenantDatabase
            "TenantDatabase" -> builder.tenantDatabase = deserializeTenantDatabaseDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
