// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.CreateOptionGroupResponse
import aws.sdk.kotlin.services.rds.model.OptionGroup
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CreateOptionGroupOperationDeserializer: HttpDeserialize<CreateOptionGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateOptionGroupResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateOptionGroupError(context, call)
        }
        val builder = CreateOptionGroupResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateOptionGroupOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateOptionGroupError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "OptionGroupAlreadyExistsFault" -> OptionGroupAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall)
        "OptionGroupQuotaExceededFault" -> OptionGroupQuotaExceededFaultDeserializer().deserialize(context, wrappedCall)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateOptionGroupOperationBody(builder: CreateOptionGroupResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateOptionGroup")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // OptionGroup com.amazonaws.rds#CreateOptionGroupResult$OptionGroup
            "OptionGroup" -> builder.optionGroup = deserializeOptionGroupDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
