// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.CreateIntegrationResponse
import aws.sdk.kotlin.services.rds.model.IntegrationError
import aws.sdk.kotlin.services.rds.model.IntegrationStatus
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.sdk.kotlin.services.rds.model.Tag
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class CreateIntegrationOperationDeserializer: HttpDeserialize<CreateIntegrationResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateIntegrationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateIntegrationError(context, call)
        }
        val builder = CreateIntegrationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateIntegrationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateIntegrationError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBClusterNotFoundFault" -> DbClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "DBInstanceNotFound" -> DbInstanceNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "IntegrationQuotaExceededFault" -> IntegrationQuotaExceededFaultDeserializer().deserialize(context, wrappedCall)
        "KMSKeyNotAccessibleFault" -> KmsKeyNotAccessibleFaultDeserializer().deserialize(context, wrappedCall)
        "IntegrationConflictOperationFault" -> IntegrationConflictOperationFaultDeserializer().deserialize(context, wrappedCall)
        "IntegrationAlreadyExistsFault" -> IntegrationAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateIntegrationOperationBody(builder: CreateIntegrationResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateIntegration")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // AdditionalEncryptionContext com.amazonaws.rds#Integration$AdditionalEncryptionContext
            "AdditionalEncryptionContext" -> builder.additionalEncryptionContext = deserializeEncryptionContextMapShape(curr)
            // CreateTime com.amazonaws.rds#Integration$CreateTime
            "CreateTime" -> builder.createTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // Errors com.amazonaws.rds#Integration$Errors
            "Errors" -> builder.errors = deserializeIntegrationErrorListShape(curr)
            // IntegrationArn com.amazonaws.rds#Integration$IntegrationArn
            "IntegrationArn" -> builder.integrationArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#IntegrationArn`)" }
            // IntegrationName com.amazonaws.rds#Integration$IntegrationName
            "IntegrationName" -> builder.integrationName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#IntegrationName`)" }
            // KMSKeyId com.amazonaws.rds#Integration$KMSKeyId
            "KMSKeyId" -> builder.kmsKeyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // SourceArn com.amazonaws.rds#Integration$SourceArn
            "SourceArn" -> builder.sourceArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#SourceArn`)" }
            // Status com.amazonaws.rds#Integration$Status
            "Status" -> builder.status = curr.tryData()
                .parse { IntegrationStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.rds#IntegrationStatus`)" }
            // Tags com.amazonaws.rds#Integration$Tags
            "Tags" -> builder.tags = deserializeTagListShape(curr)
            // TargetArn com.amazonaws.rds#Integration$TargetArn
            "TargetArn" -> builder.targetArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#Arn`)" }
            else -> {}
        }
        curr.drop()
    }
}
