// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.CreateEventSubscriptionResponse
import aws.sdk.kotlin.services.rds.model.EventSubscription
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CreateEventSubscriptionOperationDeserializer: HttpDeserialize<CreateEventSubscriptionResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateEventSubscriptionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateEventSubscriptionError(context, call)
        }
        val builder = CreateEventSubscriptionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateEventSubscriptionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateEventSubscriptionError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "SNSInvalidTopic" -> SnsInvalidTopicFaultDeserializer().deserialize(context, wrappedCall)
        "SubscriptionCategoryNotFound" -> SubscriptionCategoryNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "SourceNotFound" -> SourceNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "SNSNoAuthorization" -> SnsNoAuthorizationFaultDeserializer().deserialize(context, wrappedCall)
        "SNSTopicArnNotFound" -> SnsTopicArnNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "SubscriptionAlreadyExist" -> SubscriptionAlreadyExistFaultDeserializer().deserialize(context, wrappedCall)
        "EventSubscriptionQuotaExceeded" -> EventSubscriptionQuotaExceededFaultDeserializer().deserialize(context, wrappedCall)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateEventSubscriptionOperationBody(builder: CreateEventSubscriptionResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateEventSubscription")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // EventSubscription com.amazonaws.rds#CreateEventSubscriptionResult$EventSubscription
            "EventSubscription" -> builder.eventSubscription = deserializeEventSubscriptionDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
