// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.CreateDbSecurityGroupResponse
import aws.sdk.kotlin.services.rds.model.DbSecurityGroup
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CreateDBSecurityGroupOperationDeserializer: HttpDeserialize<CreateDbSecurityGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateDbSecurityGroupResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateDbSecurityGroupError(context, call)
        }
        val builder = CreateDbSecurityGroupResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateDBSecurityGroupOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateDbSecurityGroupError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBSecurityGroupNotSupported" -> DbSecurityGroupNotSupportedFaultDeserializer().deserialize(context, wrappedCall)
        "DBSecurityGroupAlreadyExists" -> DbSecurityGroupAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall)
        "QuotaExceeded.DBSecurityGroup" -> DbSecurityGroupQuotaExceededFaultDeserializer().deserialize(context, wrappedCall)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateDBSecurityGroupOperationBody(builder: CreateDbSecurityGroupResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateDBSecurityGroup")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBSecurityGroup com.amazonaws.rds#CreateDBSecurityGroupResult$DBSecurityGroup
            "DBSecurityGroup" -> builder.dbSecurityGroup = deserializeDbSecurityGroupDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
