// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.CreateDbProxyResponse
import aws.sdk.kotlin.services.rds.model.DbProxy
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CreateDBProxyOperationDeserializer: HttpDeserialize<CreateDbProxyResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateDbProxyResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateDbProxyError(context, call)
        }
        val builder = CreateDbProxyResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateDBProxyOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateDbProxyError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBProxyQuotaExceededFault" -> DbProxyQuotaExceededFaultDeserializer().deserialize(context, wrappedCall)
        "DBProxyAlreadyExistsFault" -> DbProxyAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidSubnet" -> InvalidSubnetDeserializer().deserialize(context, wrappedCall)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateDBProxyOperationBody(builder: CreateDbProxyResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateDBProxy")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBProxy com.amazonaws.rds#CreateDBProxyResponse$DBProxy
            "DBProxy" -> builder.dbProxy = deserializeDbProxyDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
