// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.CreateDbClusterSnapshotResponse
import aws.sdk.kotlin.services.rds.model.DbClusterSnapshot
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CreateDBClusterSnapshotOperationDeserializer: HttpDeserialize<CreateDbClusterSnapshotResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateDbClusterSnapshotResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateDbClusterSnapshotError(context, call)
        }
        val builder = CreateDbClusterSnapshotResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateDBClusterSnapshotOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateDbClusterSnapshotError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidDBClusterSnapshotStateFault" -> InvalidDbClusterSnapshotStateFaultDeserializer().deserialize(context, wrappedCall)
        "DBClusterNotFoundFault" -> DbClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "SnapshotQuotaExceeded" -> SnapshotQuotaExceededFaultDeserializer().deserialize(context, wrappedCall)
        "DBClusterSnapshotAlreadyExistsFault" -> DbClusterSnapshotAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidDBClusterStateFault" -> InvalidDbClusterStateFaultDeserializer().deserialize(context, wrappedCall)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateDBClusterSnapshotOperationBody(builder: CreateDbClusterSnapshotResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateDBClusterSnapshot")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBClusterSnapshot com.amazonaws.rds#CreateDBClusterSnapshotResult$DBClusterSnapshot
            "DBClusterSnapshot" -> builder.dbClusterSnapshot = deserializeDbClusterSnapshotDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
