// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.CreateDbClusterEndpointResponse
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CreateDBClusterEndpointOperationDeserializer: HttpDeserialize<CreateDbClusterEndpointResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateDbClusterEndpointResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateDbClusterEndpointError(context, call)
        }
        val builder = CreateDbClusterEndpointResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateDBClusterEndpointOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateDbClusterEndpointError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBClusterNotFoundFault" -> DbClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "DBInstanceNotFound" -> DbInstanceNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidDBClusterStateFault" -> InvalidDbClusterStateFaultDeserializer().deserialize(context, wrappedCall)
        "DBClusterEndpointQuotaExceededFault" -> DbClusterEndpointQuotaExceededFaultDeserializer().deserialize(context, wrappedCall)
        "DBClusterEndpointAlreadyExistsFault" -> DbClusterEndpointAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidDBInstanceState" -> InvalidDbInstanceStateFaultDeserializer().deserialize(context, wrappedCall)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateDBClusterEndpointOperationBody(builder: CreateDbClusterEndpointResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateDBClusterEndpoint")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // CustomEndpointType com.amazonaws.rds#DBClusterEndpoint$CustomEndpointType
            "CustomEndpointType" -> builder.customEndpointType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DBClusterEndpointArn com.amazonaws.rds#DBClusterEndpoint$DBClusterEndpointArn
            "DBClusterEndpointArn" -> builder.dbClusterEndpointArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DBClusterEndpointIdentifier com.amazonaws.rds#DBClusterEndpoint$DBClusterEndpointIdentifier
            "DBClusterEndpointIdentifier" -> builder.dbClusterEndpointIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DBClusterEndpointResourceIdentifier com.amazonaws.rds#DBClusterEndpoint$DBClusterEndpointResourceIdentifier
            "DBClusterEndpointResourceIdentifier" -> builder.dbClusterEndpointResourceIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DBClusterIdentifier com.amazonaws.rds#DBClusterEndpoint$DBClusterIdentifier
            "DBClusterIdentifier" -> builder.dbClusterIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // Endpoint com.amazonaws.rds#DBClusterEndpoint$Endpoint
            "Endpoint" -> builder.endpoint = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // EndpointType com.amazonaws.rds#DBClusterEndpoint$EndpointType
            "EndpointType" -> builder.endpointType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // ExcludedMembers com.amazonaws.rds#DBClusterEndpoint$ExcludedMembers
            "ExcludedMembers" -> builder.excludedMembers = deserializeStringListShape(curr)
            // StaticMembers com.amazonaws.rds#DBClusterEndpoint$StaticMembers
            "StaticMembers" -> builder.staticMembers = deserializeStringListShape(curr)
            // Status com.amazonaws.rds#DBClusterEndpoint$Status
            "Status" -> builder.status = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            else -> {}
        }
        curr.drop()
    }
}
