// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.BlueGreenDeployment
import aws.sdk.kotlin.services.rds.model.CreateBlueGreenDeploymentResponse
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CreateBlueGreenDeploymentOperationDeserializer: HttpDeserialize<CreateBlueGreenDeploymentResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateBlueGreenDeploymentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateBlueGreenDeploymentError(context, call)
        }
        val builder = CreateBlueGreenDeploymentResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateBlueGreenDeploymentOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateBlueGreenDeploymentError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBClusterNotFoundFault" -> DbClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "DBInstanceNotFound" -> DbInstanceNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "SourceDatabaseNotSupportedFault" -> SourceDatabaseNotSupportedFaultDeserializer().deserialize(context, wrappedCall)
        "InstanceQuotaExceeded" -> InstanceQuotaExceededFaultDeserializer().deserialize(context, wrappedCall)
        "DBClusterQuotaExceededFault" -> DbClusterQuotaExceededFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidDBClusterStateFault" -> InvalidDbClusterStateFaultDeserializer().deserialize(context, wrappedCall)
        "DBClusterParameterGroupNotFound" -> DbClusterParameterGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "BlueGreenDeploymentAlreadyExistsFault" -> BlueGreenDeploymentAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall)
        "DBParameterGroupNotFound" -> DbParameterGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidDBInstanceState" -> InvalidDbInstanceStateFaultDeserializer().deserialize(context, wrappedCall)
        "SourceClusterNotSupportedFault" -> SourceClusterNotSupportedFaultDeserializer().deserialize(context, wrappedCall)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateBlueGreenDeploymentOperationBody(builder: CreateBlueGreenDeploymentResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateBlueGreenDeployment")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // BlueGreenDeployment com.amazonaws.rds#CreateBlueGreenDeploymentResponse$BlueGreenDeployment
            "BlueGreenDeployment" -> builder.blueGreenDeployment = deserializeBlueGreenDeploymentDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
