// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.BlueGreenDeployment
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeBlueGreenDeploymentDocument(reader: XmlTagReader): BlueGreenDeployment {
    val builder = BlueGreenDeployment.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // BlueGreenDeploymentIdentifier com.amazonaws.rds#BlueGreenDeployment$BlueGreenDeploymentIdentifier
            "BlueGreenDeploymentIdentifier" -> builder.blueGreenDeploymentIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#BlueGreenDeploymentIdentifier`)" }
            // BlueGreenDeploymentName com.amazonaws.rds#BlueGreenDeployment$BlueGreenDeploymentName
            "BlueGreenDeploymentName" -> builder.blueGreenDeploymentName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#BlueGreenDeploymentName`)" }
            // Source com.amazonaws.rds#BlueGreenDeployment$Source
            "Source" -> builder.source = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#DatabaseArn`)" }
            // Target com.amazonaws.rds#BlueGreenDeployment$Target
            "Target" -> builder.target = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#DatabaseArn`)" }
            // SwitchoverDetails com.amazonaws.rds#BlueGreenDeployment$SwitchoverDetails
            "SwitchoverDetails" -> builder.switchoverDetails = deserializeSwitchoverDetailListShape(curr)
            // Tasks com.amazonaws.rds#BlueGreenDeployment$Tasks
            "Tasks" -> builder.tasks = deserializeBlueGreenDeploymentTaskListShape(curr)
            // Status com.amazonaws.rds#BlueGreenDeployment$Status
            "Status" -> builder.status = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#BlueGreenDeploymentStatus`)" }
            // StatusDetails com.amazonaws.rds#BlueGreenDeployment$StatusDetails
            "StatusDetails" -> builder.statusDetails = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#BlueGreenDeploymentStatusDetails`)" }
            // CreateTime com.amazonaws.rds#BlueGreenDeployment$CreateTime
            "CreateTime" -> builder.createTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // DeleteTime com.amazonaws.rds#BlueGreenDeployment$DeleteTime
            "DeleteTime" -> builder.deleteTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // TagList com.amazonaws.rds#BlueGreenDeployment$TagList
            "TagList" -> builder.tagList = deserializeTagListShape(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
