// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 * Specifies the details of authentication used by a proxy to log in as a specific database user.
 */
public class UserAuthConfig private constructor(builder: Builder) {
    /**
     * The type of authentication that the proxy uses for connections from the proxy to the underlying database.
     */
    public val authScheme: aws.sdk.kotlin.services.rds.model.AuthScheme? = builder.authScheme
    /**
     * The type of authentication the proxy uses for connections from clients.
     */
    public val clientPasswordAuthType: aws.sdk.kotlin.services.rds.model.ClientPasswordAuthType? = builder.clientPasswordAuthType
    /**
     * A user-specified description about the authentication used by a proxy to log in as a specific database user.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A value that indicates whether to require or disallow Amazon Web Services Identity and Access Management (IAM) authentication for connections to the proxy. The `ENABLED` value is valid only for proxies with RDS for Microsoft SQL Server.
     */
    public val iamAuth: aws.sdk.kotlin.services.rds.model.IamAuthMode? = builder.iamAuth
    /**
     * The Amazon Resource Name (ARN) representing the secret that the proxy uses to authenticate to the RDS DB instance or Aurora DB cluster. These secrets are stored within Amazon Secrets Manager.
     */
    public val secretArn: kotlin.String? = builder.secretArn
    /**
     * The name of the database user to which the proxy connects.
     */
    public val userName: kotlin.String? = builder.userName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.UserAuthConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UserAuthConfig(")
        append("authScheme=$authScheme,")
        append("clientPasswordAuthType=$clientPasswordAuthType,")
        append("description=$description,")
        append("iamAuth=$iamAuth,")
        append("secretArn=$secretArn,")
        append("userName=$userName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authScheme?.hashCode() ?: 0
        result = 31 * result + (clientPasswordAuthType?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (iamAuth?.hashCode() ?: 0)
        result = 31 * result + (secretArn?.hashCode() ?: 0)
        result = 31 * result + (userName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UserAuthConfig

        if (authScheme != other.authScheme) return false
        if (clientPasswordAuthType != other.clientPasswordAuthType) return false
        if (description != other.description) return false
        if (iamAuth != other.iamAuth) return false
        if (secretArn != other.secretArn) return false
        if (userName != other.userName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.UserAuthConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The type of authentication that the proxy uses for connections from the proxy to the underlying database.
         */
        public var authScheme: aws.sdk.kotlin.services.rds.model.AuthScheme? = null
        /**
         * The type of authentication the proxy uses for connections from clients.
         */
        public var clientPasswordAuthType: aws.sdk.kotlin.services.rds.model.ClientPasswordAuthType? = null
        /**
         * A user-specified description about the authentication used by a proxy to log in as a specific database user.
         */
        public var description: kotlin.String? = null
        /**
         * A value that indicates whether to require or disallow Amazon Web Services Identity and Access Management (IAM) authentication for connections to the proxy. The `ENABLED` value is valid only for proxies with RDS for Microsoft SQL Server.
         */
        public var iamAuth: aws.sdk.kotlin.services.rds.model.IamAuthMode? = null
        /**
         * The Amazon Resource Name (ARN) representing the secret that the proxy uses to authenticate to the RDS DB instance or Aurora DB cluster. These secrets are stored within Amazon Secrets Manager.
         */
        public var secretArn: kotlin.String? = null
        /**
         * The name of the database user to which the proxy connects.
         */
        public var userName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.UserAuthConfig) : this() {
            this.authScheme = x.authScheme
            this.clientPasswordAuthType = x.clientPasswordAuthType
            this.description = x.description
            this.iamAuth = x.iamAuth
            this.secretArn = x.secretArn
            this.userName = x.userName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.UserAuthConfig = UserAuthConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
