// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



public class StartExportTaskRequest private constructor(builder: Builder) {
    /**
     * The data to be exported from the snapshot or cluster. If this parameter isn't provided, all of the data is exported.
     *
     * Valid Values:
     * + `database` - Export all the data from a specified database.
     * + `database.table`*table-name* - Export a table of the snapshot or cluster. This format is valid only for RDS for MySQL, RDS for MariaDB, and Aurora MySQL.
     * + `database.schema`*schema-name* - Export a database schema of the snapshot or cluster. This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.
     * + `database.schema.table`*table-name* - Export a table of the database schema. This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.
     */
    public val exportOnly: List<String>? = builder.exportOnly
    /**
     * A unique identifier for the export task. This ID isn't an identifier for the Amazon S3 bucket where the data is to be exported.
     */
    public val exportTaskIdentifier: kotlin.String? = builder.exportTaskIdentifier
    /**
     * The name of the IAM role to use for writing to the Amazon S3 bucket when exporting a snapshot or cluster.
     *
     * In the IAM policy attached to your IAM role, include the following required actions to allow the transfer of files from Amazon RDS or Amazon Aurora to an S3 bucket:
     * + s3:PutObject*
     * + s3:GetObject*
     * + s3:ListBucket
     * + s3:DeleteObject*
     * + s3:GetBucketLocation
     *
     * In the policy, include the resources to identify the S3 bucket and objects in the bucket. The following list of resources shows the Amazon Resource Name (ARN) format for accessing S3:
     * + `arn:aws:s3:::<i>your-s3-bucket</i> `
     * + `arn:aws:s3:::<i>your-s3-bucket</i>&#47;*`
     */
    public val iamRoleArn: kotlin.String? = builder.iamRoleArn
    /**
     * The ID of the Amazon Web Services KMS key to use to encrypt the data exported to Amazon S3. The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. The caller of this operation must be authorized to run the following operations. These can be set in the Amazon Web Services KMS key policy:
     * + kms:Encrypt
     * + kms:Decrypt
     * + kms:GenerateDataKey
     * + kms:GenerateDataKeyWithoutPlaintext
     * + kms:ReEncryptFrom
     * + kms:ReEncryptTo
     * + kms:CreateGrant
     * + kms:DescribeKey
     * + kms:RetireGrant
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The name of the Amazon S3 bucket to export the snapshot or cluster data to.
     */
    public val s3BucketName: kotlin.String? = builder.s3BucketName
    /**
     * The Amazon S3 bucket prefix to use as the file name and path of the exported data.
     */
    public val s3Prefix: kotlin.String? = builder.s3Prefix
    /**
     * The Amazon Resource Name (ARN) of the snapshot or cluster to export to Amazon S3.
     */
    public val sourceArn: kotlin.String? = builder.sourceArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.StartExportTaskRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartExportTaskRequest(")
        append("exportOnly=$exportOnly,")
        append("exportTaskIdentifier=$exportTaskIdentifier,")
        append("iamRoleArn=$iamRoleArn,")
        append("kmsKeyId=$kmsKeyId,")
        append("s3BucketName=$s3BucketName,")
        append("s3Prefix=$s3Prefix,")
        append("sourceArn=$sourceArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = exportOnly?.hashCode() ?: 0
        result = 31 * result + (exportTaskIdentifier?.hashCode() ?: 0)
        result = 31 * result + (iamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (s3BucketName?.hashCode() ?: 0)
        result = 31 * result + (s3Prefix?.hashCode() ?: 0)
        result = 31 * result + (sourceArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartExportTaskRequest

        if (exportOnly != other.exportOnly) return false
        if (exportTaskIdentifier != other.exportTaskIdentifier) return false
        if (iamRoleArn != other.iamRoleArn) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (s3BucketName != other.s3BucketName) return false
        if (s3Prefix != other.s3Prefix) return false
        if (sourceArn != other.sourceArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.StartExportTaskRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The data to be exported from the snapshot or cluster. If this parameter isn't provided, all of the data is exported.
         *
         * Valid Values:
         * + `database` - Export all the data from a specified database.
         * + `database.table`*table-name* - Export a table of the snapshot or cluster. This format is valid only for RDS for MySQL, RDS for MariaDB, and Aurora MySQL.
         * + `database.schema`*schema-name* - Export a database schema of the snapshot or cluster. This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.
         * + `database.schema.table`*table-name* - Export a table of the database schema. This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.
         */
        public var exportOnly: List<String>? = null
        /**
         * A unique identifier for the export task. This ID isn't an identifier for the Amazon S3 bucket where the data is to be exported.
         */
        public var exportTaskIdentifier: kotlin.String? = null
        /**
         * The name of the IAM role to use for writing to the Amazon S3 bucket when exporting a snapshot or cluster.
         *
         * In the IAM policy attached to your IAM role, include the following required actions to allow the transfer of files from Amazon RDS or Amazon Aurora to an S3 bucket:
         * + s3:PutObject*
         * + s3:GetObject*
         * + s3:ListBucket
         * + s3:DeleteObject*
         * + s3:GetBucketLocation
         *
         * In the policy, include the resources to identify the S3 bucket and objects in the bucket. The following list of resources shows the Amazon Resource Name (ARN) format for accessing S3:
         * + `arn:aws:s3:::<i>your-s3-bucket</i> `
         * + `arn:aws:s3:::<i>your-s3-bucket</i>&#47;*`
         */
        public var iamRoleArn: kotlin.String? = null
        /**
         * The ID of the Amazon Web Services KMS key to use to encrypt the data exported to Amazon S3. The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. The caller of this operation must be authorized to run the following operations. These can be set in the Amazon Web Services KMS key policy:
         * + kms:Encrypt
         * + kms:Decrypt
         * + kms:GenerateDataKey
         * + kms:GenerateDataKeyWithoutPlaintext
         * + kms:ReEncryptFrom
         * + kms:ReEncryptTo
         * + kms:CreateGrant
         * + kms:DescribeKey
         * + kms:RetireGrant
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The name of the Amazon S3 bucket to export the snapshot or cluster data to.
         */
        public var s3BucketName: kotlin.String? = null
        /**
         * The Amazon S3 bucket prefix to use as the file name and path of the exported data.
         */
        public var s3Prefix: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the snapshot or cluster to export to Amazon S3.
         */
        public var sourceArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.StartExportTaskRequest) : this() {
            this.exportOnly = x.exportOnly
            this.exportTaskIdentifier = x.exportTaskIdentifier
            this.iamRoleArn = x.iamRoleArn
            this.kmsKeyId = x.kmsKeyId
            this.s3BucketName = x.s3BucketName
            this.s3Prefix = x.s3Prefix
            this.sourceArn = x.sourceArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.StartExportTaskRequest = StartExportTaskRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
