// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 * Contains the secret managed by RDS in Amazon Web Services Secrets Manager for the master user password.
 *
 * For more information, see [Password management with Amazon Web Services Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html) in the *Amazon RDS User Guide* and [Password management with Amazon Web Services Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html) in the *Amazon Aurora User Guide.*
 */
public class MasterUserSecret private constructor(builder: Builder) {
    /**
     * The Amazon Web Services KMS key identifier that is used to encrypt the secret.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The Amazon Resource Name (ARN) of the secret.
     */
    public val secretArn: kotlin.String? = builder.secretArn
    /**
     * The status of the secret.
     *
     * The possible status values include the following:
     * + `creating` - The secret is being created.
     * + `active` - The secret is available for normal use and rotation.
     * + `rotating` - The secret is being rotated.
     * + `impaired` - The secret can be used to access database credentials, but it can't be rotated. A secret might have this status if, for example, permissions are changed so that RDS can no longer access either the secret or the KMS key for the secret.When a secret has this status, you can correct the condition that caused the status. Alternatively, modify the DB instance to turn off automatic management of database credentials, and then modify the DB instance again to turn on automatic management of database credentials.
     */
    public val secretStatus: kotlin.String? = builder.secretStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.MasterUserSecret = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MasterUserSecret(")
        append("kmsKeyId=$kmsKeyId,")
        append("secretArn=$secretArn,")
        append("secretStatus=$secretStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsKeyId?.hashCode() ?: 0
        result = 31 * result + (secretArn?.hashCode() ?: 0)
        result = 31 * result + (secretStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MasterUserSecret

        if (kmsKeyId != other.kmsKeyId) return false
        if (secretArn != other.secretArn) return false
        if (secretStatus != other.secretStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.MasterUserSecret = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Web Services KMS key identifier that is used to encrypt the secret.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the secret.
         */
        public var secretArn: kotlin.String? = null
        /**
         * The status of the secret.
         *
         * The possible status values include the following:
         * + `creating` - The secret is being created.
         * + `active` - The secret is available for normal use and rotation.
         * + `rotating` - The secret is being rotated.
         * + `impaired` - The secret can be used to access database credentials, but it can't be rotated. A secret might have this status if, for example, permissions are changed so that RDS can no longer access either the secret or the KMS key for the secret.When a secret has this status, you can correct the condition that caused the status. Alternatively, modify the DB instance to turn off automatic management of database credentials, and then modify the DB instance again to turn on automatic management of database credentials.
         */
        public var secretStatus: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.MasterUserSecret) : this() {
            this.kmsKeyId = x.kmsKeyId
            this.secretArn = x.secretArn
            this.secretStatus = x.secretStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.MasterUserSecret = MasterUserSecret(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
