// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



public class DescribeTenantDatabasesRequest private constructor(builder: Builder) {
    /**
     * The user-supplied DB instance identifier, which must match the identifier of an existing instance owned by the Amazon Web Services account. This parameter isn't case-sensitive.
     */
    public val dbInstanceIdentifier: kotlin.String? = builder.dbInstanceIdentifier
    /**
     * A filter that specifies one or more database tenants to describe.
     *
     * Supported filters:
     * + `tenant-db-name` - Tenant database names. The results list only includes information about the tenant databases that match these tenant DB names.
     * + `tenant-database-resource-id` - Tenant database resource identifiers.
     * + `dbi-resource-id` - DB instance resource identifiers. The results list only includes information about the tenants contained within the DB instances identified by these resource identifiers.
     */
    public val filters: List<Filter>? = builder.filters
    /**
     * An optional pagination token provided by a previous `DescribeTenantDatabases` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by `MaxRecords`.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * The maximum number of records to include in the response. If more records exist than the specified `MaxRecords` value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.
     */
    public val maxRecords: kotlin.Int? = builder.maxRecords
    /**
     * The user-supplied tenant database name, which must match the name of an existing tenant database on the specified DB instance owned by your Amazon Web Services account. This parameter isn’t case-sensitive.
     */
    public val tenantDbName: kotlin.String? = builder.tenantDbName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DescribeTenantDatabasesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeTenantDatabasesRequest(")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("filters=$filters,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("tenantDbName=$tenantDbName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbInstanceIdentifier?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (tenantDbName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeTenantDatabasesRequest

        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (filters != other.filters) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (tenantDbName != other.tenantDbName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DescribeTenantDatabasesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The user-supplied DB instance identifier, which must match the identifier of an existing instance owned by the Amazon Web Services account. This parameter isn't case-sensitive.
         */
        public var dbInstanceIdentifier: kotlin.String? = null
        /**
         * A filter that specifies one or more database tenants to describe.
         *
         * Supported filters:
         * + `tenant-db-name` - Tenant database names. The results list only includes information about the tenant databases that match these tenant DB names.
         * + `tenant-database-resource-id` - Tenant database resource identifiers.
         * + `dbi-resource-id` - DB instance resource identifiers. The results list only includes information about the tenants contained within the DB instances identified by these resource identifiers.
         */
        public var filters: List<Filter>? = null
        /**
         * An optional pagination token provided by a previous `DescribeTenantDatabases` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by `MaxRecords`.
         */
        public var marker: kotlin.String? = null
        /**
         * The maximum number of records to include in the response. If more records exist than the specified `MaxRecords` value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.
         */
        public var maxRecords: kotlin.Int? = null
        /**
         * The user-supplied tenant database name, which must match the name of an existing tenant database on the specified DB instance owned by your Amazon Web Services account. This parameter isn’t case-sensitive.
         */
        public var tenantDbName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DescribeTenantDatabasesRequest) : this() {
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.filters = x.filters
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.tenantDbName = x.tenantDbName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DescribeTenantDatabasesRequest = DescribeTenantDatabasesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
