// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The data structure representing an endpoint associated with a DB proxy. RDS automatically creates one endpoint for each DB proxy. For Aurora DB clusters, you can associate additional endpoints with the same DB proxy. These endpoints can be read/write or read-only. They can also reside in different VPCs than the associated DB proxy.
 *
 * This data type is used as a response element in the `DescribeDBProxyEndpoints` operation.
 */
public class DbProxyEndpoint private constructor(builder: Builder) {
    /**
     * The date and time when the DB proxy endpoint was first created.
     */
    public val createdDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createdDate
    /**
     * The Amazon Resource Name (ARN) for the DB proxy endpoint.
     */
    public val dbProxyEndpointArn: kotlin.String? = builder.dbProxyEndpointArn
    /**
     * The name for the DB proxy endpoint. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.
     */
    public val dbProxyEndpointName: kotlin.String? = builder.dbProxyEndpointName
    /**
     * The identifier for the DB proxy that is associated with this DB proxy endpoint.
     */
    public val dbProxyName: kotlin.String? = builder.dbProxyName
    /**
     * The endpoint that you can use to connect to the DB proxy. You include the endpoint value in the connection string for a database client application.
     */
    public val endpoint: kotlin.String? = builder.endpoint
    /**
     * Indicates whether this endpoint is the default endpoint for the associated DB proxy. Default DB proxy endpoints always have read/write capability. Other endpoints that you associate with the DB proxy can be either read/write or read-only.
     */
    public val isDefault: kotlin.Boolean? = builder.isDefault
    /**
     * The current status of this DB proxy endpoint. A status of `available` means the endpoint is ready to handle requests. Other values indicate that you must wait for the endpoint to be ready, or take some action to resolve an issue.
     */
    public val status: aws.sdk.kotlin.services.rds.model.DbProxyEndpointStatus? = builder.status
    /**
     * A value that indicates whether the DB proxy endpoint can be used for read/write or read-only operations.
     */
    public val targetRole: aws.sdk.kotlin.services.rds.model.DbProxyEndpointTargetRole? = builder.targetRole
    /**
     * Provides the VPC ID of the DB proxy endpoint.
     */
    public val vpcId: kotlin.String? = builder.vpcId
    /**
     * Provides a list of VPC security groups that the DB proxy endpoint belongs to.
     */
    public val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds
    /**
     * The EC2 subnet IDs for the DB proxy endpoint.
     */
    public val vpcSubnetIds: List<String>? = builder.vpcSubnetIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DbProxyEndpoint = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DbProxyEndpoint(")
        append("createdDate=$createdDate,")
        append("dbProxyEndpointArn=$dbProxyEndpointArn,")
        append("dbProxyEndpointName=$dbProxyEndpointName,")
        append("dbProxyName=$dbProxyName,")
        append("endpoint=$endpoint,")
        append("isDefault=$isDefault,")
        append("status=$status,")
        append("targetRole=$targetRole,")
        append("vpcId=$vpcId,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds,")
        append("vpcSubnetIds=$vpcSubnetIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdDate?.hashCode() ?: 0
        result = 31 * result + (dbProxyEndpointArn?.hashCode() ?: 0)
        result = 31 * result + (dbProxyEndpointName?.hashCode() ?: 0)
        result = 31 * result + (dbProxyName?.hashCode() ?: 0)
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (isDefault?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (targetRole?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (vpcSubnetIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DbProxyEndpoint

        if (createdDate != other.createdDate) return false
        if (dbProxyEndpointArn != other.dbProxyEndpointArn) return false
        if (dbProxyEndpointName != other.dbProxyEndpointName) return false
        if (dbProxyName != other.dbProxyName) return false
        if (endpoint != other.endpoint) return false
        if (isDefault != other.isDefault) return false
        if (status != other.status) return false
        if (targetRole != other.targetRole) return false
        if (vpcId != other.vpcId) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false
        if (vpcSubnetIds != other.vpcSubnetIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DbProxyEndpoint = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date and time when the DB proxy endpoint was first created.
         */
        public var createdDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) for the DB proxy endpoint.
         */
        public var dbProxyEndpointArn: kotlin.String? = null
        /**
         * The name for the DB proxy endpoint. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.
         */
        public var dbProxyEndpointName: kotlin.String? = null
        /**
         * The identifier for the DB proxy that is associated with this DB proxy endpoint.
         */
        public var dbProxyName: kotlin.String? = null
        /**
         * The endpoint that you can use to connect to the DB proxy. You include the endpoint value in the connection string for a database client application.
         */
        public var endpoint: kotlin.String? = null
        /**
         * Indicates whether this endpoint is the default endpoint for the associated DB proxy. Default DB proxy endpoints always have read/write capability. Other endpoints that you associate with the DB proxy can be either read/write or read-only.
         */
        public var isDefault: kotlin.Boolean? = null
        /**
         * The current status of this DB proxy endpoint. A status of `available` means the endpoint is ready to handle requests. Other values indicate that you must wait for the endpoint to be ready, or take some action to resolve an issue.
         */
        public var status: aws.sdk.kotlin.services.rds.model.DbProxyEndpointStatus? = null
        /**
         * A value that indicates whether the DB proxy endpoint can be used for read/write or read-only operations.
         */
        public var targetRole: aws.sdk.kotlin.services.rds.model.DbProxyEndpointTargetRole? = null
        /**
         * Provides the VPC ID of the DB proxy endpoint.
         */
        public var vpcId: kotlin.String? = null
        /**
         * Provides a list of VPC security groups that the DB proxy endpoint belongs to.
         */
        public var vpcSecurityGroupIds: List<String>? = null
        /**
         * The EC2 subnet IDs for the DB proxy endpoint.
         */
        public var vpcSubnetIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DbProxyEndpoint) : this() {
            this.createdDate = x.createdDate
            this.dbProxyEndpointArn = x.dbProxyEndpointArn
            this.dbProxyEndpointName = x.dbProxyEndpointName
            this.dbProxyName = x.dbProxyName
            this.endpoint = x.endpoint
            this.isDefault = x.isDefault
            this.status = x.status
            this.targetRole = x.targetRole
            this.vpcId = x.vpcId
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
            this.vpcSubnetIds = x.vpcSubnetIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DbProxyEndpoint = DbProxyEndpoint(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
