// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An automated backup of a DB cluster. It consists of system backups, transaction logs, and the database cluster properties that existed at the time you deleted the source cluster.
 */
public class DbClusterAutomatedBackup private constructor(builder: Builder) {
    /**
     * For all database engines except Amazon Aurora, `AllocatedStorage` specifies the allocated storage size in gibibytes (GiB). For Aurora, `AllocatedStorage` always returns 1, because Aurora DB cluster storage size isn't fixed, but instead automatically adjusts as needed.
     */
    public val allocatedStorage: kotlin.Int? = builder.allocatedStorage
    /**
     * The Availability Zones where instances in the DB cluster can be created. For information on Amazon Web Services Regions and Availability Zones, see [Regions and Availability Zones](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html).
     */
    public val availabilityZones: List<String>? = builder.availabilityZones
    /**
     * The Amazon Resource Name (ARN) of the recovery point in Amazon Web Services Backup.
     */
    public val awsBackupRecoveryPointArn: kotlin.String? = builder.awsBackupRecoveryPointArn
    /**
     * The retention period for the automated backups.
     */
    public val backupRetentionPeriod: kotlin.Int? = builder.backupRetentionPeriod
    /**
     * The time when the DB cluster was created, in Universal Coordinated Time (UTC).
     */
    public val clusterCreateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.clusterCreateTime
    /**
     * The Amazon Resource Name (ARN) for the source DB cluster.
     */
    public val dbClusterArn: kotlin.String? = builder.dbClusterArn
    /**
     * The Amazon Resource Name (ARN) for the automated backups.
     */
    public val dbClusterAutomatedBackupsArn: kotlin.String? = builder.dbClusterAutomatedBackupsArn
    /**
     * The identifier for the source DB cluster, which can't be changed and which is unique to an Amazon Web Services Region.
     */
    public val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * The resource ID for the source DB cluster, which can't be changed and which is unique to an Amazon Web Services Region.
     */
    public val dbClusterResourceId: kotlin.String? = builder.dbClusterResourceId
    /**
     * The name of the database engine for this automated backup.
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The engine mode of the database engine for the automated backup.
     */
    public val engineMode: kotlin.String? = builder.engineMode
    /**
     * The version of the database engine for the automated backup.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * Indicates whether mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled.
     */
    public val iamDatabaseAuthenticationEnabled: kotlin.Boolean? = builder.iamDatabaseAuthenticationEnabled
    /**
     * The IOPS (I/O operations per second) value for the automated backup.
     *
     * This setting is only for non-Aurora Multi-AZ DB clusters.
     */
    public val iops: kotlin.Int? = builder.iops
    /**
     * The Amazon Web Services KMS key ID for an automated backup.
     *
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The license model information for this DB cluster automated backup.
     */
    public val licenseModel: kotlin.String? = builder.licenseModel
    /**
     * The master user name of the automated backup.
     */
    public val masterUsername: kotlin.String? = builder.masterUsername
    /**
     * The port number that the automated backup used for connections.
     *
     * Default: Inherits from the source DB cluster
     *
     * Valid Values: `1150-65535`
     */
    public val port: kotlin.Int? = builder.port
    /**
     * The Amazon Web Services Region associated with the automated backup.
     */
    public val region: kotlin.String? = builder.region
    /**
     * Earliest and latest time an instance can be restored to:
     */
    public val restoreWindow: aws.sdk.kotlin.services.rds.model.RestoreWindow? = builder.restoreWindow
    /**
     * A list of status information for an automated backup:
     * + `retained` - Automated backups for deleted clusters.
     */
    public val status: kotlin.String? = builder.status
    /**
     * Indicates whether the source DB cluster is encrypted.
     */
    public val storageEncrypted: kotlin.Boolean? = builder.storageEncrypted
    /**
     * The storage throughput for the automated backup. The throughput is automatically set based on the IOPS that you provision, and is not configurable.
     *
     * This setting is only for non-Aurora Multi-AZ DB clusters.
     */
    public val storageThroughput: kotlin.Int? = builder.storageThroughput
    /**
     * The storage type associated with the DB cluster.
     *
     * This setting is only for non-Aurora Multi-AZ DB clusters.
     */
    public val storageType: kotlin.String? = builder.storageType
    /**
     * The VPC ID associated with the DB cluster.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DbClusterAutomatedBackup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DbClusterAutomatedBackup(")
        append("allocatedStorage=$allocatedStorage,")
        append("availabilityZones=$availabilityZones,")
        append("awsBackupRecoveryPointArn=$awsBackupRecoveryPointArn,")
        append("backupRetentionPeriod=$backupRetentionPeriod,")
        append("clusterCreateTime=$clusterCreateTime,")
        append("dbClusterArn=$dbClusterArn,")
        append("dbClusterAutomatedBackupsArn=$dbClusterAutomatedBackupsArn,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbClusterResourceId=$dbClusterResourceId,")
        append("engine=$engine,")
        append("engineMode=$engineMode,")
        append("engineVersion=$engineVersion,")
        append("iamDatabaseAuthenticationEnabled=$iamDatabaseAuthenticationEnabled,")
        append("iops=$iops,")
        append("kmsKeyId=$kmsKeyId,")
        append("licenseModel=$licenseModel,")
        append("masterUsername=$masterUsername,")
        append("port=$port,")
        append("region=$region,")
        append("restoreWindow=$restoreWindow,")
        append("status=$status,")
        append("storageEncrypted=$storageEncrypted,")
        append("storageThroughput=$storageThroughput,")
        append("storageType=$storageType,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocatedStorage ?: 0
        result = 31 * result + (availabilityZones?.hashCode() ?: 0)
        result = 31 * result + (awsBackupRecoveryPointArn?.hashCode() ?: 0)
        result = 31 * result + (backupRetentionPeriod ?: 0)
        result = 31 * result + (clusterCreateTime?.hashCode() ?: 0)
        result = 31 * result + (dbClusterArn?.hashCode() ?: 0)
        result = 31 * result + (dbClusterAutomatedBackupsArn?.hashCode() ?: 0)
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbClusterResourceId?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineMode?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (iamDatabaseAuthenticationEnabled?.hashCode() ?: 0)
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (licenseModel?.hashCode() ?: 0)
        result = 31 * result + (masterUsername?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (restoreWindow?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (storageEncrypted?.hashCode() ?: 0)
        result = 31 * result + (storageThroughput ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DbClusterAutomatedBackup

        if (allocatedStorage != other.allocatedStorage) return false
        if (availabilityZones != other.availabilityZones) return false
        if (awsBackupRecoveryPointArn != other.awsBackupRecoveryPointArn) return false
        if (backupRetentionPeriod != other.backupRetentionPeriod) return false
        if (clusterCreateTime != other.clusterCreateTime) return false
        if (dbClusterArn != other.dbClusterArn) return false
        if (dbClusterAutomatedBackupsArn != other.dbClusterAutomatedBackupsArn) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbClusterResourceId != other.dbClusterResourceId) return false
        if (engine != other.engine) return false
        if (engineMode != other.engineMode) return false
        if (engineVersion != other.engineVersion) return false
        if (iamDatabaseAuthenticationEnabled != other.iamDatabaseAuthenticationEnabled) return false
        if (iops != other.iops) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (licenseModel != other.licenseModel) return false
        if (masterUsername != other.masterUsername) return false
        if (port != other.port) return false
        if (region != other.region) return false
        if (restoreWindow != other.restoreWindow) return false
        if (status != other.status) return false
        if (storageEncrypted != other.storageEncrypted) return false
        if (storageThroughput != other.storageThroughput) return false
        if (storageType != other.storageType) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DbClusterAutomatedBackup = Builder(this).apply(block).build()

    public class Builder {
        /**
         * For all database engines except Amazon Aurora, `AllocatedStorage` specifies the allocated storage size in gibibytes (GiB). For Aurora, `AllocatedStorage` always returns 1, because Aurora DB cluster storage size isn't fixed, but instead automatically adjusts as needed.
         */
        public var allocatedStorage: kotlin.Int? = null
        /**
         * The Availability Zones where instances in the DB cluster can be created. For information on Amazon Web Services Regions and Availability Zones, see [Regions and Availability Zones](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html).
         */
        public var availabilityZones: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) of the recovery point in Amazon Web Services Backup.
         */
        public var awsBackupRecoveryPointArn: kotlin.String? = null
        /**
         * The retention period for the automated backups.
         */
        public var backupRetentionPeriod: kotlin.Int? = null
        /**
         * The time when the DB cluster was created, in Universal Coordinated Time (UTC).
         */
        public var clusterCreateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) for the source DB cluster.
         */
        public var dbClusterArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the automated backups.
         */
        public var dbClusterAutomatedBackupsArn: kotlin.String? = null
        /**
         * The identifier for the source DB cluster, which can't be changed and which is unique to an Amazon Web Services Region.
         */
        public var dbClusterIdentifier: kotlin.String? = null
        /**
         * The resource ID for the source DB cluster, which can't be changed and which is unique to an Amazon Web Services Region.
         */
        public var dbClusterResourceId: kotlin.String? = null
        /**
         * The name of the database engine for this automated backup.
         */
        public var engine: kotlin.String? = null
        /**
         * The engine mode of the database engine for the automated backup.
         */
        public var engineMode: kotlin.String? = null
        /**
         * The version of the database engine for the automated backup.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * Indicates whether mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled.
         */
        public var iamDatabaseAuthenticationEnabled: kotlin.Boolean? = null
        /**
         * The IOPS (I/O operations per second) value for the automated backup.
         *
         * This setting is only for non-Aurora Multi-AZ DB clusters.
         */
        public var iops: kotlin.Int? = null
        /**
         * The Amazon Web Services KMS key ID for an automated backup.
         *
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The license model information for this DB cluster automated backup.
         */
        public var licenseModel: kotlin.String? = null
        /**
         * The master user name of the automated backup.
         */
        public var masterUsername: kotlin.String? = null
        /**
         * The port number that the automated backup used for connections.
         *
         * Default: Inherits from the source DB cluster
         *
         * Valid Values: `1150-65535`
         */
        public var port: kotlin.Int? = null
        /**
         * The Amazon Web Services Region associated with the automated backup.
         */
        public var region: kotlin.String? = null
        /**
         * Earliest and latest time an instance can be restored to:
         */
        public var restoreWindow: aws.sdk.kotlin.services.rds.model.RestoreWindow? = null
        /**
         * A list of status information for an automated backup:
         * + `retained` - Automated backups for deleted clusters.
         */
        public var status: kotlin.String? = null
        /**
         * Indicates whether the source DB cluster is encrypted.
         */
        public var storageEncrypted: kotlin.Boolean? = null
        /**
         * The storage throughput for the automated backup. The throughput is automatically set based on the IOPS that you provision, and is not configurable.
         *
         * This setting is only for non-Aurora Multi-AZ DB clusters.
         */
        public var storageThroughput: kotlin.Int? = null
        /**
         * The storage type associated with the DB cluster.
         *
         * This setting is only for non-Aurora Multi-AZ DB clusters.
         */
        public var storageType: kotlin.String? = null
        /**
         * The VPC ID associated with the DB cluster.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DbClusterAutomatedBackup) : this() {
            this.allocatedStorage = x.allocatedStorage
            this.availabilityZones = x.availabilityZones
            this.awsBackupRecoveryPointArn = x.awsBackupRecoveryPointArn
            this.backupRetentionPeriod = x.backupRetentionPeriod
            this.clusterCreateTime = x.clusterCreateTime
            this.dbClusterArn = x.dbClusterArn
            this.dbClusterAutomatedBackupsArn = x.dbClusterAutomatedBackupsArn
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbClusterResourceId = x.dbClusterResourceId
            this.engine = x.engine
            this.engineMode = x.engineMode
            this.engineVersion = x.engineVersion
            this.iamDatabaseAuthenticationEnabled = x.iamDatabaseAuthenticationEnabled
            this.iops = x.iops
            this.kmsKeyId = x.kmsKeyId
            this.licenseModel = x.licenseModel
            this.masterUsername = x.masterUsername
            this.port = x.port
            this.region = x.region
            this.restoreWindow = x.restoreWindow
            this.status = x.status
            this.storageEncrypted = x.storageEncrypted
            this.storageThroughput = x.storageThroughput
            this.storageType = x.storageType
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DbClusterAutomatedBackup = DbClusterAutomatedBackup(this)

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.RestoreWindow] inside the given [block]
         */
        public fun restoreWindow(block: aws.sdk.kotlin.services.rds.model.RestoreWindow.Builder.() -> kotlin.Unit) {
            this.restoreWindow = aws.sdk.kotlin.services.rds.model.RestoreWindow.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
