// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 *
 */
public class CreateOptionGroupRequest private constructor(builder: Builder) {
    /**
     * The name of the engine to associate this option group with.
     *
     * Valid Values:
     * + `db2-ae`
     * + `db2-se`
     * + `mariadb`
     * + `mysql`
     * + `oracle-ee`
     * + `oracle-ee-cdb`
     * + `oracle-se2`
     * + `oracle-se2-cdb`
     * + `postgres`
     * + `sqlserver-ee`
     * + `sqlserver-se`
     * + `sqlserver-ex`
     * + `sqlserver-web`
     */
    public val engineName: kotlin.String? = builder.engineName
    /**
     * Specifies the major version of the engine that this option group should be associated with.
     */
    public val majorEngineVersion: kotlin.String? = builder.majorEngineVersion
    /**
     * The description of the option group.
     */
    public val optionGroupDescription: kotlin.String? = builder.optionGroupDescription
    /**
     * Specifies the name of the option group to be created.
     *
     * Constraints:
     * + Must be 1 to 255 letters, numbers, or hyphens
     * + First character must be a letter
     * + Can't end with a hyphen or contain two consecutive hyphens
     *
     * Example: `myoptiongroup`
     */
    public val optionGroupName: kotlin.String? = builder.optionGroupName
    /**
     * Tags to assign to the option group.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.CreateOptionGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateOptionGroupRequest(")
        append("engineName=$engineName,")
        append("majorEngineVersion=$majorEngineVersion,")
        append("optionGroupDescription=$optionGroupDescription,")
        append("optionGroupName=$optionGroupName,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = engineName?.hashCode() ?: 0
        result = 31 * result + (majorEngineVersion?.hashCode() ?: 0)
        result = 31 * result + (optionGroupDescription?.hashCode() ?: 0)
        result = 31 * result + (optionGroupName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateOptionGroupRequest

        if (engineName != other.engineName) return false
        if (majorEngineVersion != other.majorEngineVersion) return false
        if (optionGroupDescription != other.optionGroupDescription) return false
        if (optionGroupName != other.optionGroupName) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.CreateOptionGroupRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the engine to associate this option group with.
         *
         * Valid Values:
         * + `db2-ae`
         * + `db2-se`
         * + `mariadb`
         * + `mysql`
         * + `oracle-ee`
         * + `oracle-ee-cdb`
         * + `oracle-se2`
         * + `oracle-se2-cdb`
         * + `postgres`
         * + `sqlserver-ee`
         * + `sqlserver-se`
         * + `sqlserver-ex`
         * + `sqlserver-web`
         */
        public var engineName: kotlin.String? = null
        /**
         * Specifies the major version of the engine that this option group should be associated with.
         */
        public var majorEngineVersion: kotlin.String? = null
        /**
         * The description of the option group.
         */
        public var optionGroupDescription: kotlin.String? = null
        /**
         * Specifies the name of the option group to be created.
         *
         * Constraints:
         * + Must be 1 to 255 letters, numbers, or hyphens
         * + First character must be a letter
         * + Can't end with a hyphen or contain two consecutive hyphens
         *
         * Example: `myoptiongroup`
         */
        public var optionGroupName: kotlin.String? = null
        /**
         * Tags to assign to the option group.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.CreateOptionGroupRequest) : this() {
            this.engineName = x.engineName
            this.majorEngineVersion = x.majorEngineVersion
            this.optionGroupDescription = x.optionGroupDescription
            this.optionGroupName = x.optionGroupName
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.CreateOptionGroupRequest = CreateOptionGroupRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
