// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



public class CreateDbShardGroupRequest private constructor(builder: Builder) {
    /**
     * Specifies whether to create standby instances for the DB shard group. Valid values are the following:
     * + 0 - Creates a single, primary DB instance for each physical shard. This is the default value, and the only one supported for the preview.
     * + 1 - Creates a primary DB instance and a standby instance in a different Availability Zone (AZ) for each physical shard.
     * + 2 - Creates a primary DB instance and two standby instances in different AZs for each physical shard.
     */
    public val computeRedundancy: kotlin.Int? = builder.computeRedundancy
    /**
     * The name of the primary DB cluster for the DB shard group.
     */
    public val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * The name of the DB shard group.
     */
    public val dbShardGroupIdentifier: kotlin.String? = builder.dbShardGroupIdentifier
    /**
     * The maximum capacity of the DB shard group in Aurora capacity units (ACUs).
     */
    public val maxAcu: kotlin.Double? = builder.maxAcu
    /**
     * Specifies whether the DB shard group is publicly accessible.
     *
     * When the DB shard group is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB shard group's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB shard group's VPC. Access to the DB shard group is ultimately controlled by the security group it uses. That public access is not permitted if the security group assigned to the DB shard group doesn't permit it.
     *
     * When the DB shard group isn't publicly accessible, it is an internal DB shard group with a DNS name that resolves to a private IP address.
     *
     * Default: The default behavior varies depending on whether `DBSubnetGroupName` is specified.
     *
     * If `DBSubnetGroupName` isn't specified, and `PubliclyAccessible` isn't specified, the following applies:
     * + If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB shard group is private.
     * + If the default VPC in the target Region has an internet gateway attached to it, the DB shard group is public.
     *
     * If `DBSubnetGroupName` is specified, and `PubliclyAccessible` isn't specified, the following applies:
     * + If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB shard group is private.
     * + If the subnets are part of a VPC that has an internet gateway attached to it, the DB shard group is public.
     */
    public val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.CreateDbShardGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDbShardGroupRequest(")
        append("computeRedundancy=$computeRedundancy,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbShardGroupIdentifier=$dbShardGroupIdentifier,")
        append("maxAcu=$maxAcu,")
        append("publiclyAccessible=$publiclyAccessible")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = computeRedundancy ?: 0
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbShardGroupIdentifier?.hashCode() ?: 0)
        result = 31 * result + (maxAcu?.hashCode() ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDbShardGroupRequest

        if (computeRedundancy != other.computeRedundancy) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbShardGroupIdentifier != other.dbShardGroupIdentifier) return false
        if (maxAcu != other.maxAcu) return false
        if (publiclyAccessible != other.publiclyAccessible) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.CreateDbShardGroupRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether to create standby instances for the DB shard group. Valid values are the following:
         * + 0 - Creates a single, primary DB instance for each physical shard. This is the default value, and the only one supported for the preview.
         * + 1 - Creates a primary DB instance and a standby instance in a different Availability Zone (AZ) for each physical shard.
         * + 2 - Creates a primary DB instance and two standby instances in different AZs for each physical shard.
         */
        public var computeRedundancy: kotlin.Int? = null
        /**
         * The name of the primary DB cluster for the DB shard group.
         */
        public var dbClusterIdentifier: kotlin.String? = null
        /**
         * The name of the DB shard group.
         */
        public var dbShardGroupIdentifier: kotlin.String? = null
        /**
         * The maximum capacity of the DB shard group in Aurora capacity units (ACUs).
         */
        public var maxAcu: kotlin.Double? = null
        /**
         * Specifies whether the DB shard group is publicly accessible.
         *
         * When the DB shard group is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB shard group's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB shard group's VPC. Access to the DB shard group is ultimately controlled by the security group it uses. That public access is not permitted if the security group assigned to the DB shard group doesn't permit it.
         *
         * When the DB shard group isn't publicly accessible, it is an internal DB shard group with a DNS name that resolves to a private IP address.
         *
         * Default: The default behavior varies depending on whether `DBSubnetGroupName` is specified.
         *
         * If `DBSubnetGroupName` isn't specified, and `PubliclyAccessible` isn't specified, the following applies:
         * + If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB shard group is private.
         * + If the default VPC in the target Region has an internet gateway attached to it, the DB shard group is public.
         *
         * If `DBSubnetGroupName` is specified, and `PubliclyAccessible` isn't specified, the following applies:
         * + If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB shard group is private.
         * + If the subnets are part of a VPC that has an internet gateway attached to it, the DB shard group is public.
         */
        public var publiclyAccessible: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.CreateDbShardGroupRequest) : this() {
            this.computeRedundancy = x.computeRedundancy
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbShardGroupIdentifier = x.dbShardGroupIdentifier
            this.maxAcu = x.maxAcu
            this.publiclyAccessible = x.publiclyAccessible
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.CreateDbShardGroupRequest = CreateDbShardGroupRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
